// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ReplicationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub role: ::std::string::String,
    /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.</p>
    pub rules: ::std::vec::Vec<crate::types::ReplicationRule>,
}
impl ReplicationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn role(&self) -> &str {
        use std::ops::Deref;
        self.role.deref()
    }
    /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.</p>
    pub fn rules(&self) -> &[crate::types::ReplicationRule] {
        use std::ops::Deref;
        self.rules.deref()
    }
}
impl ReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`ReplicationConfiguration`](crate::types::ReplicationConfiguration).
    pub fn builder() -> crate::types::builders::ReplicationConfigurationBuilder {
        crate::types::builders::ReplicationConfigurationBuilder::default()
    }
}

/// A builder for [`ReplicationConfiguration`](crate::types::ReplicationConfiguration).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ReplicationConfigurationBuilder {
    pub(crate) role: ::std::option::Option<::std::string::String>,
    pub(crate) rules: ::std::option::Option<::std::vec::Vec<crate::types::ReplicationRule>>,
}
impl ReplicationConfigurationBuilder {
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// This field is required.
    pub fn role(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.role = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_role(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.role = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_role(&self) -> &::std::option::Option<::std::string::String> {
        &self.role
    }
    /// Appends an item to `rules`.
    ///
    /// To override the contents of this collection use [`set_rules`](Self::set_rules).
    ///
    /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.</p>
    pub fn rules(mut self, input: crate::types::ReplicationRule) -> Self {
        let mut v = self.rules.unwrap_or_default();
        v.push(input);
        self.rules = ::std::option::Option::Some(v);
        self
    }
    /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.</p>
    pub fn set_rules(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::ReplicationRule>>) -> Self {
        self.rules = input;
        self
    }
    /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules.</p>
    pub fn get_rules(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ReplicationRule>> {
        &self.rules
    }
    /// Consumes the builder and constructs a [`ReplicationConfiguration`](crate::types::ReplicationConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`role`](crate::types::builders::ReplicationConfigurationBuilder::role)
    /// - [`rules`](crate::types::builders::ReplicationConfigurationBuilder::rules)
    pub fn build(self) -> ::std::result::Result<crate::types::ReplicationConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ReplicationConfiguration {
            role: self.role.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "role",
                    "role was not specified but it is required when building ReplicationConfiguration",
                )
            })?,
            rules: self.rules.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "rules",
                    "rules was not specified but it is required when building ReplicationConfiguration",
                )
            })?,
        })
    }
}
