// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RedirectAllRequestsTo {
    /// <p>Name of the host where requests are redirected.</p>
    pub host_name: ::std::string::String,
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub protocol: ::std::option::Option<crate::types::Protocol>,
}
impl RedirectAllRequestsTo {
    /// <p>Name of the host where requests are redirected.</p>
    pub fn host_name(&self) -> &str {
        use std::ops::Deref;
        self.host_name.deref()
    }
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub fn protocol(&self) -> ::std::option::Option<&crate::types::Protocol> {
        self.protocol.as_ref()
    }
}
impl RedirectAllRequestsTo {
    /// Creates a new builder-style object to manufacture [`RedirectAllRequestsTo`](crate::types::RedirectAllRequestsTo).
    pub fn builder() -> crate::types::builders::RedirectAllRequestsToBuilder {
        crate::types::builders::RedirectAllRequestsToBuilder::default()
    }
}

/// A builder for [`RedirectAllRequestsTo`](crate::types::RedirectAllRequestsTo).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct RedirectAllRequestsToBuilder {
    pub(crate) host_name: ::std::option::Option<::std::string::String>,
    pub(crate) protocol: ::std::option::Option<crate::types::Protocol>,
}
impl RedirectAllRequestsToBuilder {
    /// <p>Name of the host where requests are redirected.</p>
    /// This field is required.
    pub fn host_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.host_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Name of the host where requests are redirected.</p>
    pub fn set_host_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.host_name = input;
        self
    }
    /// <p>Name of the host where requests are redirected.</p>
    pub fn get_host_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.host_name
    }
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub fn protocol(mut self, input: crate::types::Protocol) -> Self {
        self.protocol = ::std::option::Option::Some(input);
        self
    }
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub fn set_protocol(mut self, input: ::std::option::Option<crate::types::Protocol>) -> Self {
        self.protocol = input;
        self
    }
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub fn get_protocol(&self) -> &::std::option::Option<crate::types::Protocol> {
        &self.protocol
    }
    /// Consumes the builder and constructs a [`RedirectAllRequestsTo`](crate::types::RedirectAllRequestsTo).
    /// This method will fail if any of the following fields are not set:
    /// - [`host_name`](crate::types::builders::RedirectAllRequestsToBuilder::host_name)
    pub fn build(self) -> ::std::result::Result<crate::types::RedirectAllRequestsTo, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::RedirectAllRequestsTo {
            host_name: self.host_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "host_name",
                    "host_name was not specified but it is required when building RedirectAllRequestsTo",
                )
            })?,
            protocol: self.protocol,
        })
    }
}
