// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Container for the person being granted permissions.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Grantee {
    /// <p>Screen name of the grantee.</p>
    pub display_name: ::std::option::Option<::std::string::String>,
    /// <p>Email address of the grantee.</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note>
    pub email_address: ::std::option::Option<::std::string::String>,
    /// <p>The canonical user ID of the grantee.</p>
    pub id: ::std::option::Option<::std::string::String>,
    /// <p>URI of the grantee group.</p>
    pub uri: ::std::option::Option<::std::string::String>,
    /// <p>Type of grantee</p>
    pub r#type: crate::types::Type,
}
impl Grantee {
    /// <p>Screen name of the grantee.</p>
    pub fn display_name(&self) -> ::std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>Email address of the grantee.</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note>
    pub fn email_address(&self) -> ::std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The canonical user ID of the grantee.</p>
    pub fn id(&self) -> ::std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>URI of the grantee group.</p>
    pub fn uri(&self) -> ::std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>Type of grantee</p>
    pub fn r#type(&self) -> &crate::types::Type {
        &self.r#type
    }
}
impl Grantee {
    /// Creates a new builder-style object to manufacture [`Grantee`](crate::types::Grantee).
    pub fn builder() -> crate::types::builders::GranteeBuilder {
        crate::types::builders::GranteeBuilder::default()
    }
}

/// A builder for [`Grantee`](crate::types::Grantee).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct GranteeBuilder {
    pub(crate) display_name: ::std::option::Option<::std::string::String>,
    pub(crate) email_address: ::std::option::Option<::std::string::String>,
    pub(crate) id: ::std::option::Option<::std::string::String>,
    pub(crate) uri: ::std::option::Option<::std::string::String>,
    pub(crate) r#type: ::std::option::Option<crate::types::Type>,
}
impl GranteeBuilder {
    /// <p>Screen name of the grantee.</p>
    pub fn display_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.display_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Screen name of the grantee.</p>
    pub fn set_display_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.display_name = input;
        self
    }
    /// <p>Screen name of the grantee.</p>
    pub fn get_display_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.display_name
    }
    /// <p>Email address of the grantee.</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note>
    pub fn email_address(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.email_address = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Email address of the grantee.</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note>
    pub fn set_email_address(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.email_address = input;
        self
    }
    /// <p>Email address of the grantee.</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note>
    pub fn get_email_address(&self) -> &::std::option::Option<::std::string::String> {
        &self.email_address
    }
    /// <p>The canonical user ID of the grantee.</p>
    pub fn id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The canonical user ID of the grantee.</p>
    pub fn set_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.id = input;
        self
    }
    /// <p>The canonical user ID of the grantee.</p>
    pub fn get_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.id
    }
    /// <p>URI of the grantee group.</p>
    pub fn uri(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.uri = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>URI of the grantee group.</p>
    pub fn set_uri(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.uri = input;
        self
    }
    /// <p>URI of the grantee group.</p>
    pub fn get_uri(&self) -> &::std::option::Option<::std::string::String> {
        &self.uri
    }
    /// <p>Type of grantee</p>
    /// This field is required.
    pub fn r#type(mut self, input: crate::types::Type) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Type of grantee</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::Type>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>Type of grantee</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::Type> {
        &self.r#type
    }
    /// Consumes the builder and constructs a [`Grantee`](crate::types::Grantee).
    /// This method will fail if any of the following fields are not set:
    /// - [`r#type`](crate::types::builders::GranteeBuilder::r#type)
    pub fn build(self) -> ::std::result::Result<crate::types::Grantee, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Grantee {
            display_name: self.display_name,
            email_address: self.email_address,
            id: self.id,
            uri: self.uri,
            r#type: self.r#type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#type",
                    "r#type was not specified but it is required when building Grantee",
                )
            })?,
        })
    }
}
