// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `BucketLocationConstraint`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let bucketlocationconstraint = unimplemented!();
/// match bucketlocationconstraint {
///     BucketLocationConstraint::Eu => { /* ... */ },
///     BucketLocationConstraint::AfSouth1 => { /* ... */ },
///     BucketLocationConstraint::ApEast1 => { /* ... */ },
///     BucketLocationConstraint::ApNortheast1 => { /* ... */ },
///     BucketLocationConstraint::ApNortheast2 => { /* ... */ },
///     BucketLocationConstraint::ApNortheast3 => { /* ... */ },
///     BucketLocationConstraint::ApSouth1 => { /* ... */ },
///     BucketLocationConstraint::ApSouth2 => { /* ... */ },
///     BucketLocationConstraint::ApSoutheast1 => { /* ... */ },
///     BucketLocationConstraint::ApSoutheast2 => { /* ... */ },
///     BucketLocationConstraint::ApSoutheast3 => { /* ... */ },
///     BucketLocationConstraint::CaCentral1 => { /* ... */ },
///     BucketLocationConstraint::CnNorth1 => { /* ... */ },
///     BucketLocationConstraint::CnNorthwest1 => { /* ... */ },
///     BucketLocationConstraint::EuCentral1 => { /* ... */ },
///     BucketLocationConstraint::EuNorth1 => { /* ... */ },
///     BucketLocationConstraint::EuSouth1 => { /* ... */ },
///     BucketLocationConstraint::EuSouth2 => { /* ... */ },
///     BucketLocationConstraint::EuWest1 => { /* ... */ },
///     BucketLocationConstraint::EuWest2 => { /* ... */ },
///     BucketLocationConstraint::EuWest3 => { /* ... */ },
///     BucketLocationConstraint::MeSouth1 => { /* ... */ },
///     BucketLocationConstraint::SaEast1 => { /* ... */ },
///     BucketLocationConstraint::UsEast2 => { /* ... */ },
///     BucketLocationConstraint::UsGovEast1 => { /* ... */ },
///     BucketLocationConstraint::UsGovWest1 => { /* ... */ },
///     BucketLocationConstraint::UsWest1 => { /* ... */ },
///     BucketLocationConstraint::UsWest2 => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `bucketlocationconstraint` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `BucketLocationConstraint::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `BucketLocationConstraint::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `BucketLocationConstraint::NewFeature` is defined.
/// Specifically, when `bucketlocationconstraint` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `BucketLocationConstraint::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum BucketLocationConstraint {
    #[allow(missing_docs)] // documentation missing in model
    Eu,
    #[allow(missing_docs)] // documentation missing in model
    AfSouth1,
    #[allow(missing_docs)] // documentation missing in model
    ApEast1,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast2,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast3,
    #[allow(missing_docs)] // documentation missing in model
    ApSouth1,
    #[allow(missing_docs)] // documentation missing in model
    ApSouth2,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast3,
    #[allow(missing_docs)] // documentation missing in model
    CaCentral1,
    #[allow(missing_docs)] // documentation missing in model
    CnNorth1,
    #[allow(missing_docs)] // documentation missing in model
    CnNorthwest1,
    #[allow(missing_docs)] // documentation missing in model
    EuCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuNorth1,
    #[allow(missing_docs)] // documentation missing in model
    EuSouth1,
    #[allow(missing_docs)] // documentation missing in model
    EuSouth2,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest2,
    #[allow(missing_docs)] // documentation missing in model
    EuWest3,
    #[allow(missing_docs)] // documentation missing in model
    MeSouth1,
    #[allow(missing_docs)] // documentation missing in model
    SaEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast2,
    #[allow(missing_docs)] // documentation missing in model
    UsGovEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsGovWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for BucketLocationConstraint {
    fn from(s: &str) -> Self {
        match s {
            "EU" => BucketLocationConstraint::Eu,
            "af-south-1" => BucketLocationConstraint::AfSouth1,
            "ap-east-1" => BucketLocationConstraint::ApEast1,
            "ap-northeast-1" => BucketLocationConstraint::ApNortheast1,
            "ap-northeast-2" => BucketLocationConstraint::ApNortheast2,
            "ap-northeast-3" => BucketLocationConstraint::ApNortheast3,
            "ap-south-1" => BucketLocationConstraint::ApSouth1,
            "ap-south-2" => BucketLocationConstraint::ApSouth2,
            "ap-southeast-1" => BucketLocationConstraint::ApSoutheast1,
            "ap-southeast-2" => BucketLocationConstraint::ApSoutheast2,
            "ap-southeast-3" => BucketLocationConstraint::ApSoutheast3,
            "ca-central-1" => BucketLocationConstraint::CaCentral1,
            "cn-north-1" => BucketLocationConstraint::CnNorth1,
            "cn-northwest-1" => BucketLocationConstraint::CnNorthwest1,
            "eu-central-1" => BucketLocationConstraint::EuCentral1,
            "eu-north-1" => BucketLocationConstraint::EuNorth1,
            "eu-south-1" => BucketLocationConstraint::EuSouth1,
            "eu-south-2" => BucketLocationConstraint::EuSouth2,
            "eu-west-1" => BucketLocationConstraint::EuWest1,
            "eu-west-2" => BucketLocationConstraint::EuWest2,
            "eu-west-3" => BucketLocationConstraint::EuWest3,
            "me-south-1" => BucketLocationConstraint::MeSouth1,
            "sa-east-1" => BucketLocationConstraint::SaEast1,
            "us-east-2" => BucketLocationConstraint::UsEast2,
            "us-gov-east-1" => BucketLocationConstraint::UsGovEast1,
            "us-gov-west-1" => BucketLocationConstraint::UsGovWest1,
            "us-west-1" => BucketLocationConstraint::UsWest1,
            "us-west-2" => BucketLocationConstraint::UsWest2,
            other => BucketLocationConstraint::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for BucketLocationConstraint {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(BucketLocationConstraint::from(s))
    }
}
impl BucketLocationConstraint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketLocationConstraint::Eu => "EU",
            BucketLocationConstraint::AfSouth1 => "af-south-1",
            BucketLocationConstraint::ApEast1 => "ap-east-1",
            BucketLocationConstraint::ApNortheast1 => "ap-northeast-1",
            BucketLocationConstraint::ApNortheast2 => "ap-northeast-2",
            BucketLocationConstraint::ApNortheast3 => "ap-northeast-3",
            BucketLocationConstraint::ApSouth1 => "ap-south-1",
            BucketLocationConstraint::ApSouth2 => "ap-south-2",
            BucketLocationConstraint::ApSoutheast1 => "ap-southeast-1",
            BucketLocationConstraint::ApSoutheast2 => "ap-southeast-2",
            BucketLocationConstraint::ApSoutheast3 => "ap-southeast-3",
            BucketLocationConstraint::CaCentral1 => "ca-central-1",
            BucketLocationConstraint::CnNorth1 => "cn-north-1",
            BucketLocationConstraint::CnNorthwest1 => "cn-northwest-1",
            BucketLocationConstraint::EuCentral1 => "eu-central-1",
            BucketLocationConstraint::EuNorth1 => "eu-north-1",
            BucketLocationConstraint::EuSouth1 => "eu-south-1",
            BucketLocationConstraint::EuSouth2 => "eu-south-2",
            BucketLocationConstraint::EuWest1 => "eu-west-1",
            BucketLocationConstraint::EuWest2 => "eu-west-2",
            BucketLocationConstraint::EuWest3 => "eu-west-3",
            BucketLocationConstraint::MeSouth1 => "me-south-1",
            BucketLocationConstraint::SaEast1 => "sa-east-1",
            BucketLocationConstraint::UsEast2 => "us-east-2",
            BucketLocationConstraint::UsGovEast1 => "us-gov-east-1",
            BucketLocationConstraint::UsGovWest1 => "us-gov-west-1",
            BucketLocationConstraint::UsWest1 => "us-west-1",
            BucketLocationConstraint::UsWest2 => "us-west-2",
            BucketLocationConstraint::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "EU",
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-south-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "cn-north-1",
            "cn-northwest-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-south-2",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
        ]
    }
}
impl ::std::convert::AsRef<str> for BucketLocationConstraint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl BucketLocationConstraint {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for BucketLocationConstraint {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            BucketLocationConstraint::Eu => write!(f, "EU"),
            BucketLocationConstraint::AfSouth1 => write!(f, "af-south-1"),
            BucketLocationConstraint::ApEast1 => write!(f, "ap-east-1"),
            BucketLocationConstraint::ApNortheast1 => write!(f, "ap-northeast-1"),
            BucketLocationConstraint::ApNortheast2 => write!(f, "ap-northeast-2"),
            BucketLocationConstraint::ApNortheast3 => write!(f, "ap-northeast-3"),
            BucketLocationConstraint::ApSouth1 => write!(f, "ap-south-1"),
            BucketLocationConstraint::ApSouth2 => write!(f, "ap-south-2"),
            BucketLocationConstraint::ApSoutheast1 => write!(f, "ap-southeast-1"),
            BucketLocationConstraint::ApSoutheast2 => write!(f, "ap-southeast-2"),
            BucketLocationConstraint::ApSoutheast3 => write!(f, "ap-southeast-3"),
            BucketLocationConstraint::CaCentral1 => write!(f, "ca-central-1"),
            BucketLocationConstraint::CnNorth1 => write!(f, "cn-north-1"),
            BucketLocationConstraint::CnNorthwest1 => write!(f, "cn-northwest-1"),
            BucketLocationConstraint::EuCentral1 => write!(f, "eu-central-1"),
            BucketLocationConstraint::EuNorth1 => write!(f, "eu-north-1"),
            BucketLocationConstraint::EuSouth1 => write!(f, "eu-south-1"),
            BucketLocationConstraint::EuSouth2 => write!(f, "eu-south-2"),
            BucketLocationConstraint::EuWest1 => write!(f, "eu-west-1"),
            BucketLocationConstraint::EuWest2 => write!(f, "eu-west-2"),
            BucketLocationConstraint::EuWest3 => write!(f, "eu-west-3"),
            BucketLocationConstraint::MeSouth1 => write!(f, "me-south-1"),
            BucketLocationConstraint::SaEast1 => write!(f, "sa-east-1"),
            BucketLocationConstraint::UsEast2 => write!(f, "us-east-2"),
            BucketLocationConstraint::UsGovEast1 => write!(f, "us-gov-east-1"),
            BucketLocationConstraint::UsGovWest1 => write!(f, "us-gov-west-1"),
            BucketLocationConstraint::UsWest1 => write!(f, "us-west-1"),
            BucketLocationConstraint::UsWest2 => write!(f, "us-west-2"),
            BucketLocationConstraint::Unknown(value) => write!(f, "{}", value),
        }
    }
}
