// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AccelerateConfiguration {
    /// <p>Specifies the transfer acceleration status of the bucket.</p>
    pub status: ::std::option::Option<crate::types::BucketAccelerateStatus>,
}
impl AccelerateConfiguration {
    /// <p>Specifies the transfer acceleration status of the bucket.</p>
    pub fn status(&self) -> ::std::option::Option<&crate::types::BucketAccelerateStatus> {
        self.status.as_ref()
    }
}
impl AccelerateConfiguration {
    /// Creates a new builder-style object to manufacture [`AccelerateConfiguration`](crate::types::AccelerateConfiguration).
    pub fn builder() -> crate::types::builders::AccelerateConfigurationBuilder {
        crate::types::builders::AccelerateConfigurationBuilder::default()
    }
}

/// A builder for [`AccelerateConfiguration`](crate::types::AccelerateConfiguration).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct AccelerateConfigurationBuilder {
    pub(crate) status: ::std::option::Option<crate::types::BucketAccelerateStatus>,
}
impl AccelerateConfigurationBuilder {
    /// <p>Specifies the transfer acceleration status of the bucket.</p>
    pub fn status(mut self, input: crate::types::BucketAccelerateStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the transfer acceleration status of the bucket.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::BucketAccelerateStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>Specifies the transfer acceleration status of the bucket.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::BucketAccelerateStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`AccelerateConfiguration`](crate::types::AccelerateConfiguration).
    pub fn build(self) -> crate::types::AccelerateConfiguration {
        crate::types::AccelerateConfiguration { status: self.status }
    }
}
