// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_create_session_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::create_session::CreateSessionOutput, crate::operation::create_session::CreateSessionError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::create_session::CreateSessionError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::create_session::CreateSessionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchBucket" => crate::operation::create_session::CreateSessionError::NoSuchBucket({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::NoSuchBucketBuilder::default();
                output = crate::protocol_serde::shape_no_such_bucket::de_no_such_bucket_xml_err(_response_body, output)
                    .map_err(crate::operation::create_session::CreateSessionError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::create_session::CreateSessionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_create_session_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::create_session::CreateSessionOutput, crate::operation::create_session::CreateSessionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::create_session::builders::CreateSessionOutputBuilder::default();
        output = crate::protocol_serde::shape_create_session::de_create_session(_response_body, output)
            .map_err(crate::operation::create_session::CreateSessionError::unhandled)?;
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        crate::serde_util::create_session_output_output_correct_errors(output).build()
    })
}

pub fn ser_create_session_headers(
    input: &crate::operation::create_session::CreateSessionInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.session_mode {
        let formatted_2 = inner_1.as_str();
        if !formatted_2.is_empty() {
            let header_value = formatted_2;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "session_mode",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-create-session-mode", header_value);
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn de_create_session(
    inp: &[u8],
    mut builder: crate::operation::create_session::builders::CreateSessionOutputBuilder,
) -> Result<crate::operation::create_session::builders::CreateSessionOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Credentials") /* Credentials com.amazonaws.s3.synthetic#CreateSessionOutput$Credentials */ =>  {
                let var_3 =
                    Some(
                        crate::protocol_serde::shape_session_credentials::de_session_credentials(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_credentials(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}
