// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetObjectLockConfiguration`](crate::operation::get_object_lock_configuration::builders::GetObjectLockConfigurationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_object_lock_configuration::builders::GetObjectLockConfigurationFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_object_lock_configuration::builders::GetObjectLockConfigurationFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket whose Object Lock configuration you want to retrieve.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_object_lock_configuration::builders::GetObjectLockConfigurationFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_object_lock_configuration::builders::GetObjectLockConfigurationFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`GetObjectLockConfigurationOutput`](crate::operation::get_object_lock_configuration::GetObjectLockConfigurationOutput) with field(s):
    ///   - [`object_lock_configuration(Option<ObjectLockConfiguration>)`](crate::operation::get_object_lock_configuration::GetObjectLockConfigurationOutput::object_lock_configuration): <p>The specified bucket's Object Lock configuration.</p>
    /// - On failure, responds with [`SdkError<GetObjectLockConfigurationError>`](crate::operation::get_object_lock_configuration::GetObjectLockConfigurationError)
    pub fn get_object_lock_configuration(
        &self,
    ) -> crate::operation::get_object_lock_configuration::builders::GetObjectLockConfigurationFluentBuilder {
        crate::operation::get_object_lock_configuration::builders::GetObjectLockConfigurationFluentBuilder::new(self.handle.clone())
    }
}
