// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`CreateMultipartUpload`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(ObjectCannedAcl)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::acl) / [`set_acl(Option<ObjectCannedAcl>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_acl):<br>required: **false**<br><p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p> <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`bucket(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`cache_control(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::cache_control) / [`set_cache_control(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_cache_control):<br>required: **false**<br><p>Specifies caching behavior along the request/reply chain.</p><br>
    ///   - [`content_disposition(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::content_disposition) / [`set_content_disposition(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_content_disposition):<br>required: **false**<br><p>Specifies presentational information for the object.</p><br>
    ///   - [`content_encoding(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::content_encoding) / [`set_content_encoding(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_content_encoding):<br>required: **false**<br><p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>  <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p> </note><br>
    ///   - [`content_language(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::content_language) / [`set_content_language(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_content_language):<br>required: **false**<br><p>The language that the content is in.</p><br>
    ///   - [`content_type(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::content_type) / [`set_content_type(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_content_type):<br>required: **false**<br><p>A standard MIME type describing the format of the object data.</p><br>
    ///   - [`expires(DateTime)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::expires) / [`set_expires(Option<DateTime>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_expires):<br>required: **false**<br><p>The date and time at which the object is no longer cacheable.</p><br>
    ///   - [`grant_full_control(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_grant_full_control):<br>required: **false**<br><p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p> <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul>  <li>   <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>  <li>   <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>  <li>   <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>    <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>    <ul>     <li>      <p>US East (N. Virginia)</p></li>     <li>      <p>US West (N. California)</p></li>     <li>      <p>US West (Oregon)</p></li>     <li>      <p>Asia Pacific (Singapore)</p></li>     <li>      <p>Asia Pacific (Sydney)</p></li>     <li>      <p>Asia Pacific (Tokyo)</p></li>     <li>      <p>Europe (Ireland)</p></li>     <li>      <p>South America (São Paulo)</p></li>    </ul>    <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>   </note></li> </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p> <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_read(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::grant_read) / [`set_grant_read(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_grant_read):<br>required: **false**<br><p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p> <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul>  <li>   <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>  <li>   <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>  <li>   <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>    <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>    <ul>     <li>      <p>US East (N. Virginia)</p></li>     <li>      <p>US West (N. California)</p></li>     <li>      <p>US West (Oregon)</p></li>     <li>      <p>Asia Pacific (Singapore)</p></li>     <li>      <p>Asia Pacific (Sydney)</p></li>     <li>      <p>Asia Pacific (Tokyo)</p></li>     <li>      <p>Europe (Ireland)</p></li>     <li>      <p>South America (São Paulo)</p></li>    </ul>    <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>   </note></li> </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p> <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_grant_read_acp):<br>required: **false**<br><p>Specify access permissions explicitly to allows grantee to read the object ACL.</p> <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul>  <li>   <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>  <li>   <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>  <li>   <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>    <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>    <ul>     <li>      <p>US East (N. Virginia)</p></li>     <li>      <p>US West (N. California)</p></li>     <li>      <p>US West (Oregon)</p></li>     <li>      <p>Asia Pacific (Singapore)</p></li>     <li>      <p>Asia Pacific (Sydney)</p></li>     <li>      <p>Asia Pacific (Tokyo)</p></li>     <li>      <p>Europe (Ireland)</p></li>     <li>      <p>South America (São Paulo)</p></li>    </ul>    <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>   </note></li> </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p> <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_grant_write_acp):<br>required: **false**<br><p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p> <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p> <ul>  <li>   <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>  <li>   <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>  <li>   <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>    <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>    <ul>     <li>      <p>US East (N. Virginia)</p></li>     <li>      <p>US West (N. California)</p></li>     <li>      <p>US West (Oregon)</p></li>     <li>      <p>Asia Pacific (Singapore)</p></li>     <li>      <p>Asia Pacific (Sydney)</p></li>     <li>      <p>Asia Pacific (Tokyo)</p></li>     <li>      <p>Europe (Ireland)</p></li>     <li>      <p>South America (São Paulo)</p></li>    </ul>    <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>   </note></li> </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p> <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`key(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_key):<br>required: **true**<br><p>Object key for which the multipart upload is to be initiated.</p><br>
    ///   - [`metadata(impl Into<String>, impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::metadata) / [`set_metadata(Option<HashMap::<String, String>>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_metadata):<br>required: **false**<br><p>A map of metadata to store with the object in S3.</p><br>
    ///   - [`server_side_encryption(ServerSideEncryption)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::server_side_encryption) / [`set_server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_server_side_encryption):<br>required: **false**<br><p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>  <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p> </note><br>
    ///   - [`storage_class(StorageClass)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::storage_class) / [`set_storage_class(Option<StorageClass>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_storage_class):<br>required: **false**<br><p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <ul>   <li>    <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>   <li>    <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>  </ul> </note><br>
    ///   - [`website_redirect_location(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::website_redirect_location) / [`set_website_redirect_location(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_website_redirect_location):<br>required: **false**<br><p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`ssekms_key_id(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::ssekms_key_id) / [`set_ssekms_key_id(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_ssekms_key_id):<br>required: **false**<br><p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`ssekms_encryption_context(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::ssekms_encryption_context) / [`set_ssekms_encryption_context(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_ssekms_encryption_context):<br>required: **false**<br><p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`bucket_key_enabled(bool)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::bucket_key_enabled) / [`set_bucket_key_enabled(Option<bool>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_bucket_key_enabled):<br>required: **false**<br><p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p> <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`tagging(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::tagging) / [`set_tagging(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_tagging):<br>required: **false**<br><p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_mode(ObjectLockMode)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::object_lock_mode) / [`set_object_lock_mode(Option<ObjectLockMode>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_object_lock_mode):<br>required: **false**<br><p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_retain_until_date(DateTime)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::object_lock_retain_until_date) / [`set_object_lock_retain_until_date(Option<DateTime>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_object_lock_retain_until_date):<br>required: **false**<br><p>Specifies the date and time when you want the Object Lock to expire.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_legal_hold_status(ObjectLockLegalHoldStatus)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::object_lock_legal_hold_status) / [`set_object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_object_lock_legal_hold_status):<br>required: **false**<br><p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    /// - On success, responds with [`CreateMultipartUploadOutput`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput) with field(s):
    ///   - [`abort_date(Option<DateTime>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::abort_date): <p>If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, the response includes this header. The header indicates when the initiated multipart upload becomes eligible for an abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The response also includes the <code>x-amz-abort-rule-id</code> header that provides the ID of the lifecycle configuration rule that defines the abort action.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`abort_rule_id(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::abort_rule_id): <p>This header is returned along with the <code>x-amz-abort-date</code> header. It identifies the applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`bucket(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::bucket): <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p><note>  <p>Access points are not supported by directory buckets.</p> </note>
    ///   - [`key(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`upload_id(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::upload_id): <p>ID for the initiated multipart upload.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::server_side_encryption): <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>  <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p> </note>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_key_id(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::ssekms_key_id): <p>If present, indicates the ID of the Key Management Service (KMS) symmetric encryption customer managed key that was used for the object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_encryption_context(Option<String>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::ssekms_encryption_context): <p>If present, indicates the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`bucket_key_enabled(Option<bool>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::bucket_key_enabled): <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::create_multipart_upload::CreateMultipartUploadOutput::checksum_algorithm): <p>The algorithm that was used to create a checksum of the object.</p>
    /// - On failure, responds with [`SdkError<CreateMultipartUploadError>`](crate::operation::create_multipart_upload::CreateMultipartUploadError)
    pub fn create_multipart_upload(&self) -> crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder {
        crate::operation::create_multipart_upload::builders::CreateMultipartUploadFluentBuilder::new(self.handle.clone())
    }
}
