// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct EdgeConfig {
    /// <p>The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.</p>
    pub hub_device_arn: ::std::string::String,
    /// <p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as credentials to access the local media files streamed on the camera.</p>
    pub recorder_config: ::std::option::Option<crate::types::RecorderConfig>,
    /// <p>The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.</p>
    pub uploader_config: ::std::option::Option<crate::types::UploaderConfig>,
    /// <p>The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.</p>
    pub deletion_config: ::std::option::Option<crate::types::DeletionConfig>,
}
impl EdgeConfig {
    /// <p>The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.</p>
    pub fn hub_device_arn(&self) -> &str {
        use std::ops::Deref;
        self.hub_device_arn.deref()
    }
    /// <p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as credentials to access the local media files streamed on the camera.</p>
    pub fn recorder_config(&self) -> ::std::option::Option<&crate::types::RecorderConfig> {
        self.recorder_config.as_ref()
    }
    /// <p>The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.</p>
    pub fn uploader_config(&self) -> ::std::option::Option<&crate::types::UploaderConfig> {
        self.uploader_config.as_ref()
    }
    /// <p>The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.</p>
    pub fn deletion_config(&self) -> ::std::option::Option<&crate::types::DeletionConfig> {
        self.deletion_config.as_ref()
    }
}
impl EdgeConfig {
    /// Creates a new builder-style object to manufacture [`EdgeConfig`](crate::types::EdgeConfig).
    pub fn builder() -> crate::types::builders::EdgeConfigBuilder {
        crate::types::builders::EdgeConfigBuilder::default()
    }
}

/// A builder for [`EdgeConfig`](crate::types::EdgeConfig).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct EdgeConfigBuilder {
    pub(crate) hub_device_arn: ::std::option::Option<::std::string::String>,
    pub(crate) recorder_config: ::std::option::Option<crate::types::RecorderConfig>,
    pub(crate) uploader_config: ::std::option::Option<crate::types::UploaderConfig>,
    pub(crate) deletion_config: ::std::option::Option<crate::types::DeletionConfig>,
}
impl EdgeConfigBuilder {
    /// <p>The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.</p>
    /// This field is required.
    pub fn hub_device_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.hub_device_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.</p>
    pub fn set_hub_device_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.hub_device_arn = input;
        self
    }
    /// <p>The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.</p>
    pub fn get_hub_device_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.hub_device_arn
    }
    /// <p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as credentials to access the local media files streamed on the camera.</p>
    /// This field is required.
    pub fn recorder_config(mut self, input: crate::types::RecorderConfig) -> Self {
        self.recorder_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as credentials to access the local media files streamed on the camera.</p>
    pub fn set_recorder_config(mut self, input: ::std::option::Option<crate::types::RecorderConfig>) -> Self {
        self.recorder_config = input;
        self
    }
    /// <p>The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as credentials to access the local media files streamed on the camera.</p>
    pub fn get_recorder_config(&self) -> &::std::option::Option<crate::types::RecorderConfig> {
        &self.recorder_config
    }
    /// <p>The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.</p>
    pub fn uploader_config(mut self, input: crate::types::UploaderConfig) -> Self {
        self.uploader_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.</p>
    pub fn set_uploader_config(mut self, input: ::std::option::Option<crate::types::UploaderConfig>) -> Self {
        self.uploader_config = input;
        self
    }
    /// <p>The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.</p>
    pub fn get_uploader_config(&self) -> &::std::option::Option<crate::types::UploaderConfig> {
        &self.uploader_config
    }
    /// <p>The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.</p>
    pub fn deletion_config(mut self, input: crate::types::DeletionConfig) -> Self {
        self.deletion_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.</p>
    pub fn set_deletion_config(mut self, input: ::std::option::Option<crate::types::DeletionConfig>) -> Self {
        self.deletion_config = input;
        self
    }
    /// <p>The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.</p>
    pub fn get_deletion_config(&self) -> &::std::option::Option<crate::types::DeletionConfig> {
        &self.deletion_config
    }
    /// Consumes the builder and constructs a [`EdgeConfig`](crate::types::EdgeConfig).
    /// This method will fail if any of the following fields are not set:
    /// - [`hub_device_arn`](crate::types::builders::EdgeConfigBuilder::hub_device_arn)
    pub fn build(self) -> ::std::result::Result<crate::types::EdgeConfig, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::EdgeConfig {
            hub_device_arn: self.hub_device_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "hub_device_arn",
                    "hub_device_arn was not specified but it is required when building EdgeConfig",
                )
            })?,
            recorder_config: self.recorder_config,
            uploader_config: self.uploader_config,
            deletion_config: self.deletion_config,
        })
    }
}
