// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_create_stream_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::create_stream::CreateStreamOutput, crate::operation::create_stream::CreateStreamError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::create_stream::CreateStreamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccountStreamLimitExceededException" => crate::operation::create_stream::CreateStreamError::AccountStreamLimitExceededException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::AccountStreamLimitExceededExceptionBuilder::default();
                output = crate::protocol_serde::shape_account_stream_limit_exceeded_exception::de_account_stream_limit_exceeded_exception_json_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "ClientLimitExceededException" => crate::operation::create_stream::CreateStreamError::ClientLimitExceededException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::ClientLimitExceededExceptionBuilder::default();
                output =
                    crate::protocol_serde::shape_client_limit_exceeded_exception::de_client_limit_exceeded_exception_json_err(_response_body, output)
                        .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "DeviceStreamLimitExceededException" => crate::operation::create_stream::CreateStreamError::DeviceStreamLimitExceededException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::DeviceStreamLimitExceededExceptionBuilder::default();
                output = crate::protocol_serde::shape_device_stream_limit_exceeded_exception::de_device_stream_limit_exceeded_exception_json_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "InvalidArgumentException" => crate::operation::create_stream::CreateStreamError::InvalidArgumentException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::InvalidArgumentExceptionBuilder::default();
                output = crate::protocol_serde::shape_invalid_argument_exception::de_invalid_argument_exception_json_err(_response_body, output)
                    .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "InvalidDeviceException" => crate::operation::create_stream::CreateStreamError::InvalidDeviceException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::InvalidDeviceExceptionBuilder::default();
                output = crate::protocol_serde::shape_invalid_device_exception::de_invalid_device_exception_json_err(_response_body, output)
                    .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "ResourceInUseException" => crate::operation::create_stream::CreateStreamError::ResourceInUseException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::ResourceInUseExceptionBuilder::default();
                output = crate::protocol_serde::shape_resource_in_use_exception::de_resource_in_use_exception_json_err(_response_body, output)
                    .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "TagsPerResourceExceededLimitException" => {
            crate::operation::create_stream::CreateStreamError::TagsPerResourceExceededLimitException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::types::error::builders::TagsPerResourceExceededLimitExceptionBuilder::default();
                    output = crate::protocol_serde::shape_tags_per_resource_exceeded_limit_exception::de_tags_per_resource_exceeded_limit_exception_json_err(_response_body, output).map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
                    let output = output.meta(generic);
                    output.build()
                };
                if tmp.message.is_none() {
                    tmp.message = _error_message;
                }
                tmp
            })
        }
        _ => crate::operation::create_stream::CreateStreamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_create_stream_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::create_stream::CreateStreamOutput, crate::operation::create_stream::CreateStreamError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::create_stream::builders::CreateStreamOutputBuilder::default();
        output = crate::protocol_serde::shape_create_stream::de_create_stream(_response_body, output)
            .map_err(crate::operation::create_stream::CreateStreamError::unhandled)?;
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_create_stream_input(
    input: &crate::operation::create_stream::CreateStreamInput,
) -> Result<::aws_smithy_types::body::SdkBody, ::aws_smithy_types::error::operation::SerializationError> {
    let mut out = String::new();
    let mut object = ::aws_smithy_json::serialize::JsonObjectWriter::new(&mut out);
    crate::protocol_serde::shape_create_stream_input::ser_create_stream_input_input(&mut object, input)?;
    object.finish();
    Ok(::aws_smithy_types::body::SdkBody::from(out))
}

pub(crate) fn de_create_stream(
    value: &[u8],
    mut builder: crate::operation::create_stream::builders::CreateStreamOutputBuilder,
) -> Result<crate::operation::create_stream::builders::CreateStreamOutputBuilder, ::aws_smithy_json::deserialize::error::DeserializeError> {
    let mut tokens_owned = ::aws_smithy_json::deserialize::json_token_iter(crate::protocol_serde::or_empty_doc(value)).peekable();
    let tokens = &mut tokens_owned;
    ::aws_smithy_json::deserialize::token::expect_start_object(tokens.next())?;
    loop {
        match tokens.next().transpose()? {
            Some(::aws_smithy_json::deserialize::Token::EndObject { .. }) => break,
            Some(::aws_smithy_json::deserialize::Token::ObjectKey { key, .. }) => match key.to_unescaped()?.as_ref() {
                "StreamARN" => {
                    builder = builder.set_stream_arn(
                        ::aws_smithy_json::deserialize::token::expect_string_or_null(tokens.next())?
                            .map(|s| s.to_unescaped().map(|u| u.into_owned()))
                            .transpose()?,
                    );
                }
                _ => ::aws_smithy_json::deserialize::token::skip_value(tokens)?,
            },
            other => {
                return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(format!(
                    "expected object key or end object, found: {:?}",
                    other
                )))
            }
        }
    }
    if tokens.next().is_some() {
        return Err(::aws_smithy_json::deserialize::error::DeserializeError::custom(
            "found more JSON tokens after completing parsing",
        ));
    }
    Ok(builder)
}
