// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::update_signaling_channel::_update_signaling_channel_output::UpdateSignalingChannelOutputBuilder;

pub use crate::operation::update_signaling_channel::_update_signaling_channel_input::UpdateSignalingChannelInputBuilder;

impl UpdateSignalingChannelInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::update_signaling_channel::UpdateSignalingChannelOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_signaling_channel::UpdateSignalingChannelError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.update_signaling_channel();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `UpdateSignalingChannel`.
///
/// <p>Updates the existing signaling channel. This is an asynchronous operation and takes time to complete.</p>
/// <p>If the <code>MessageTtlSeconds</code> value is updated (either increased or reduced), it only applies to new messages sent via this channel after it's been updated. Existing messages are still expired as per the previous <code>MessageTtlSeconds</code> value.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct UpdateSignalingChannelFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::update_signaling_channel::builders::UpdateSignalingChannelInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::update_signaling_channel::UpdateSignalingChannelOutput,
        crate::operation::update_signaling_channel::UpdateSignalingChannelError,
    > for UpdateSignalingChannelFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::update_signaling_channel::UpdateSignalingChannelOutput,
            crate::operation::update_signaling_channel::UpdateSignalingChannelError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl UpdateSignalingChannelFluentBuilder {
    /// Creates a new `UpdateSignalingChannel`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the UpdateSignalingChannel as a reference.
    pub fn as_input(&self) -> &crate::operation::update_signaling_channel::builders::UpdateSignalingChannelInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::update_signaling_channel::UpdateSignalingChannelOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_signaling_channel::UpdateSignalingChannelError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::update_signaling_channel::UpdateSignalingChannel::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::update_signaling_channel::UpdateSignalingChannel::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::update_signaling_channel::UpdateSignalingChannelOutput,
        crate::operation::update_signaling_channel::UpdateSignalingChannelError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>
    pub fn channel_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.channel_arn(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>
    pub fn set_channel_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_channel_arn(input);
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>
    pub fn get_channel_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_channel_arn()
    }
    /// <p>The current version of the signaling channel that you want to update.</p>
    pub fn current_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.current_version(input.into());
        self
    }
    /// <p>The current version of the signaling channel that you want to update.</p>
    pub fn set_current_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_current_version(input);
        self
    }
    /// <p>The current version of the signaling channel that you want to update.</p>
    pub fn get_current_version(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_current_version()
    }
    /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update.</p>
    pub fn single_master_configuration(mut self, input: crate::types::SingleMasterConfiguration) -> Self {
        self.inner = self.inner.single_master_configuration(input);
        self
    }
    /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update.</p>
    pub fn set_single_master_configuration(mut self, input: ::std::option::Option<crate::types::SingleMasterConfiguration>) -> Self {
        self.inner = self.inner.set_single_master_configuration(input);
        self
    }
    /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update.</p>
    pub fn get_single_master_configuration(&self) -> &::std::option::Option<crate::types::SingleMasterConfiguration> {
        self.inner.get_single_master_configuration()
    }
}
