// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DeleteStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
    /// <p>Optional: The version of the stream that you want to delete.</p>
    /// <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
    /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
    pub current_version: ::std::option::Option<::std::string::String>,
}
impl DeleteStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>Optional: The version of the stream that you want to delete.</p>
    /// <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
    /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
    pub fn current_version(&self) -> ::std::option::Option<&str> {
        self.current_version.as_deref()
    }
}
impl DeleteStreamInput {
    /// Creates a new builder-style object to manufacture [`DeleteStreamInput`](crate::operation::delete_stream::DeleteStreamInput).
    pub fn builder() -> crate::operation::delete_stream::builders::DeleteStreamInputBuilder {
        crate::operation::delete_stream::builders::DeleteStreamInputBuilder::default()
    }
}

/// A builder for [`DeleteStreamInput`](crate::operation::delete_stream::DeleteStreamInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct DeleteStreamInputBuilder {
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) current_version: ::std::option::Option<::std::string::String>,
}
impl DeleteStreamInputBuilder {
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete.</p>
    /// This field is required.
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>Optional: The version of the stream that you want to delete.</p>
    /// <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
    /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
    pub fn current_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.current_version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Optional: The version of the stream that you want to delete.</p>
    /// <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
    /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
    pub fn set_current_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.current_version = input;
        self
    }
    /// <p>Optional: The version of the stream that you want to delete.</p>
    /// <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
    /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
    pub fn get_current_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.current_version
    }
    /// Consumes the builder and constructs a [`DeleteStreamInput`](crate::operation::delete_stream::DeleteStreamInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::delete_stream::DeleteStreamInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::delete_stream::DeleteStreamInput {
            stream_arn: self.stream_arn,
            current_version: self.current_version,
        })
    }
}
