// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CreateStreamInput {
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub device_name: ::std::option::Option<::std::string::String>,
    /// <p>A name for the stream that you are creating.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub stream_name: ::std::option::Option<::std::string::String>,
    /// <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
    /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
    /// <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
    pub media_type: ::std::option::Option<::std::string::String>,
    /// <p>The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>
    /// <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>Amazon Web Services/kinesisvideo</code>) is used.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>.</p>
    pub kms_key_id: ::std::option::Option<::std::string::String>,
    /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
    pub data_retention_in_hours: ::std::option::Option<i32>,
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
    pub tags: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
}
impl CreateStreamInput {
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn device_name(&self) -> ::std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>A name for the stream that you are creating.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub fn stream_name(&self) -> ::std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
    /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
    /// <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
    pub fn media_type(&self) -> ::std::option::Option<&str> {
        self.media_type.as_deref()
    }
    /// <p>The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>
    /// <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>Amazon Web Services/kinesisvideo</code>) is used.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>.</p>
    pub fn kms_key_id(&self) -> ::std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
    pub fn data_retention_in_hours(&self) -> ::std::option::Option<i32> {
        self.data_retention_in_hours
    }
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
    pub fn tags(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.tags.as_ref()
    }
}
impl CreateStreamInput {
    /// Creates a new builder-style object to manufacture [`CreateStreamInput`](crate::operation::create_stream::CreateStreamInput).
    pub fn builder() -> crate::operation::create_stream::builders::CreateStreamInputBuilder {
        crate::operation::create_stream::builders::CreateStreamInputBuilder::default()
    }
}

/// A builder for [`CreateStreamInput`](crate::operation::create_stream::CreateStreamInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct CreateStreamInputBuilder {
    pub(crate) device_name: ::std::option::Option<::std::string::String>,
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) media_type: ::std::option::Option<::std::string::String>,
    pub(crate) kms_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) data_retention_in_hours: ::std::option::Option<i32>,
    pub(crate) tags: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
}
impl CreateStreamInputBuilder {
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn device_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.device_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn set_device_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.device_name = input;
        self
    }
    /// <p>The name of the device that is writing to the stream.</p><note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
    /// </note>
    pub fn get_device_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.device_name
    }
    /// <p>A name for the stream that you are creating.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    /// This field is required.
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A name for the stream that you are creating.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>A name for the stream that you are creating.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
    /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
    /// <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
    pub fn media_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.media_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
    /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
    /// <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
    pub fn set_media_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.media_type = input;
        self
    }
    /// <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
    /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
    /// <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
    pub fn get_media_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.media_type
    }
    /// <p>The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>
    /// <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>Amazon Web Services/kinesisvideo</code>) is used.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>.</p>
    pub fn kms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.kms_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>
    /// <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>Amazon Web Services/kinesisvideo</code>) is used.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>.</p>
    pub fn set_kms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.kms_key_id = input;
        self
    }
    /// <p>The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>
    /// <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>Amazon Web Services/kinesisvideo</code>) is used.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>.</p>
    pub fn get_kms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.kms_key_id
    }
    /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
    pub fn data_retention_in_hours(mut self, input: i32) -> Self {
        self.data_retention_in_hours = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
    pub fn set_data_retention_in_hours(mut self, input: ::std::option::Option<i32>) -> Self {
        self.data_retention_in_hours = input;
        self
    }
    /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
    pub fn get_data_retention_in_hours(&self) -> &::std::option::Option<i32> {
        &self.data_retention_in_hours
    }
    /// Adds a key-value pair to `tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
    pub fn tags(mut self, k: impl ::std::convert::Into<::std::string::String>, v: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut hash_map = self.tags.unwrap_or_default();
        hash_map.insert(k.into(), v.into());
        self.tags = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>) -> Self {
        self.tags = input;
        self
    }
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        &self.tags
    }
    /// Consumes the builder and constructs a [`CreateStreamInput`](crate::operation::create_stream::CreateStreamInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::create_stream::CreateStreamInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::create_stream::CreateStreamInput {
            device_name: self.device_name,
            stream_name: self.stream_name,
            media_type: self.media_type,
            kms_key_id: self.kms_key_id,
            data_retention_in_hours: self.data_retention_in_hours,
            tags: self.tags,
        })
    }
}
