// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`DescribeEdgeConfiguration`](crate::operation::describe_edge_configuration::builders::DescribeEdgeConfigurationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::operation::describe_edge_configuration::builders::DescribeEdgeConfigurationFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::describe_edge_configuration::builders::DescribeEdgeConfigurationFluentBuilder::set_stream_name):<br>required: **false**<br><p>The name of the stream whose edge configuration you want to update. Specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p><br>
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::describe_edge_configuration::builders::DescribeEdgeConfigurationFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::describe_edge_configuration::builders::DescribeEdgeConfigurationFluentBuilder::set_stream_arn):<br>required: **false**<br><p>The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code>or the <code>StreamARN</code>.</p><br>
    /// - On success, responds with [`DescribeEdgeConfigurationOutput`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput) with field(s):
    ///   - [`stream_name(Option<String>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::stream_name): <p>The name of the stream from which the edge configuration was updated.</p>
    ///   - [`stream_arn(Option<String>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::stream_arn): <p>The Amazon Resource Name (ARN) of the stream.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::creation_time): <p>The timestamp at which a stream’s edge configuration was first created.</p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::last_updated_time): <p>The timestamp at which a stream’s edge configuration was last updated.</p>
    ///   - [`sync_status(Option<SyncStatus>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::sync_status): <p>The latest status of the edge configuration update.</p>
    ///   - [`failed_status_details(Option<String>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::failed_status_details): <p>A description of the generated failure status.</p>
    ///   - [`edge_config(Option<EdgeConfig>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::edge_config): <p>A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.</p>
    ///   - [`edge_agent_status(Option<EdgeAgentStatus>)`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationOutput::edge_agent_status): <p>An object that contains the latest status details for an edge agent's recorder and uploader jobs. Use this information to determine the current health of an edge agent.</p>
    /// - On failure, responds with [`SdkError<DescribeEdgeConfigurationError>`](crate::operation::describe_edge_configuration::DescribeEdgeConfigurationError)
    pub fn describe_edge_configuration(&self) -> crate::operation::describe_edge_configuration::builders::DescribeEdgeConfigurationFluentBuilder {
        crate::operation::describe_edge_configuration::builders::DescribeEdgeConfigurationFluentBuilder::new(self.handle.clone())
    }
}
