// Code generated by protoc-gen-psrpc v0.5.1, DO NOT EDIT.
// source: rpc/egress.proto

package rpc

import (
	"context"

	"github.com/livekit/psrpc"
	"github.com/livekit/psrpc/pkg/client"
	"github.com/livekit/psrpc/pkg/info"
	"github.com/livekit/psrpc/pkg/rand"
	"github.com/livekit/psrpc/pkg/server"
	"github.com/livekit/psrpc/version"
)
import livekit2 "github.com/livekit/protocol/livekit"

var _ = version.PsrpcVersion_0_5

// ===============================
// EgressInternal Client Interface
// ===============================

type EgressInternalClient interface {
	StartEgress(ctx context.Context, topic string, req *StartEgressRequest, opts ...psrpc.RequestOption) (*livekit2.EgressInfo, error)

	ListActiveEgress(ctx context.Context, topic string, req *ListActiveEgressRequest, opts ...psrpc.RequestOption) (<-chan *psrpc.Response[*ListActiveEgressResponse], error)
}

// ===================================
// EgressInternal ServerImpl Interface
// ===================================

type EgressInternalServerImpl interface {
	StartEgress(context.Context, *StartEgressRequest) (*livekit2.EgressInfo, error)
	StartEgressAffinity(context.Context, *StartEgressRequest) float32

	ListActiveEgress(context.Context, *ListActiveEgressRequest) (*ListActiveEgressResponse, error)
}

// ===============================
// EgressInternal Server Interface
// ===============================

type EgressInternalServer interface {
	RegisterStartEgressTopic(topic string) error
	DeregisterStartEgressTopic(topic string)
	RegisterListActiveEgressTopic(topic string) error
	DeregisterListActiveEgressTopic(topic string)

	// Close and wait for pending RPCs to complete
	Shutdown()

	// Close immediately, without waiting for pending RPCs
	Kill()
}

// =====================
// EgressInternal Client
// =====================

type egressInternalClient struct {
	client *client.RPCClient
}

// NewEgressInternalClient creates a psrpc client that implements the EgressInternalClient interface.
func NewEgressInternalClient(bus psrpc.MessageBus, opts ...psrpc.ClientOption) (EgressInternalClient, error) {
	sd := &info.ServiceDefinition{
		Name: "EgressInternal",
		ID:   rand.NewClientID(),
	}

	sd.RegisterMethod("StartEgress", true, false, true, false)
	sd.RegisterMethod("ListActiveEgress", false, true, false, false)

	rpcClient, err := client.NewRPCClient(sd, bus, opts...)
	if err != nil {
		return nil, err
	}

	return &egressInternalClient{
		client: rpcClient,
	}, nil
}

func (c *egressInternalClient) StartEgress(ctx context.Context, topic string, req *StartEgressRequest, opts ...psrpc.RequestOption) (*livekit2.EgressInfo, error) {
	return client.RequestSingle[*livekit2.EgressInfo](ctx, c.client, "StartEgress", []string{topic}, req, opts...)
}

func (c *egressInternalClient) ListActiveEgress(ctx context.Context, topic string, req *ListActiveEgressRequest, opts ...psrpc.RequestOption) (<-chan *psrpc.Response[*ListActiveEgressResponse], error) {
	return client.RequestMulti[*ListActiveEgressResponse](ctx, c.client, "ListActiveEgress", []string{topic}, req, opts...)
}

// =====================
// EgressInternal Server
// =====================

type egressInternalServer struct {
	svc EgressInternalServerImpl
	rpc *server.RPCServer
}

// NewEgressInternalServer builds a RPCServer that will route requests
// to the corresponding method in the provided svc implementation.
func NewEgressInternalServer(svc EgressInternalServerImpl, bus psrpc.MessageBus, opts ...psrpc.ServerOption) (EgressInternalServer, error) {
	sd := &info.ServiceDefinition{
		Name: "EgressInternal",
		ID:   rand.NewServerID(),
	}

	s := server.NewRPCServer(sd, bus, opts...)

	sd.RegisterMethod("StartEgress", true, false, true, false)
	sd.RegisterMethod("ListActiveEgress", false, true, false, false)
	return &egressInternalServer{
		svc: svc,
		rpc: s,
	}, nil
}

func (s *egressInternalServer) RegisterStartEgressTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "StartEgress", []string{topic}, s.svc.StartEgress, s.svc.StartEgressAffinity)
}

func (s *egressInternalServer) DeregisterStartEgressTopic(topic string) {
	s.rpc.DeregisterHandler("StartEgress", []string{topic})
}

func (s *egressInternalServer) RegisterListActiveEgressTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "ListActiveEgress", []string{topic}, s.svc.ListActiveEgress, nil)
}

func (s *egressInternalServer) DeregisterListActiveEgressTopic(topic string) {
	s.rpc.DeregisterHandler("ListActiveEgress", []string{topic})
}

func (s *egressInternalServer) Shutdown() {
	s.rpc.Close(false)
}

func (s *egressInternalServer) Kill() {
	s.rpc.Close(true)
}

// ==============================
// EgressHandler Client Interface
// ==============================

type EgressHandlerClient interface {
	UpdateStream(ctx context.Context, topic string, req *livekit2.UpdateStreamRequest, opts ...psrpc.RequestOption) (*livekit2.EgressInfo, error)

	StopEgress(ctx context.Context, topic string, req *livekit2.StopEgressRequest, opts ...psrpc.RequestOption) (*livekit2.EgressInfo, error)
}

// ==================================
// EgressHandler ServerImpl Interface
// ==================================

type EgressHandlerServerImpl interface {
	UpdateStream(context.Context, *livekit2.UpdateStreamRequest) (*livekit2.EgressInfo, error)

	StopEgress(context.Context, *livekit2.StopEgressRequest) (*livekit2.EgressInfo, error)
}

// ==============================
// EgressHandler Server Interface
// ==============================

type EgressHandlerServer interface {
	RegisterUpdateStreamTopic(topic string) error
	DeregisterUpdateStreamTopic(topic string)
	RegisterStopEgressTopic(topic string) error
	DeregisterStopEgressTopic(topic string)

	// Close and wait for pending RPCs to complete
	Shutdown()

	// Close immediately, without waiting for pending RPCs
	Kill()
}

// ====================
// EgressHandler Client
// ====================

type egressHandlerClient struct {
	client *client.RPCClient
}

// NewEgressHandlerClient creates a psrpc client that implements the EgressHandlerClient interface.
func NewEgressHandlerClient(bus psrpc.MessageBus, opts ...psrpc.ClientOption) (EgressHandlerClient, error) {
	sd := &info.ServiceDefinition{
		Name: "EgressHandler",
		ID:   rand.NewClientID(),
	}

	sd.RegisterMethod("UpdateStream", false, false, true, true)
	sd.RegisterMethod("StopEgress", false, false, true, true)

	rpcClient, err := client.NewRPCClient(sd, bus, opts...)
	if err != nil {
		return nil, err
	}

	return &egressHandlerClient{
		client: rpcClient,
	}, nil
}

func (c *egressHandlerClient) UpdateStream(ctx context.Context, topic string, req *livekit2.UpdateStreamRequest, opts ...psrpc.RequestOption) (*livekit2.EgressInfo, error) {
	return client.RequestSingle[*livekit2.EgressInfo](ctx, c.client, "UpdateStream", []string{topic}, req, opts...)
}

func (c *egressHandlerClient) StopEgress(ctx context.Context, topic string, req *livekit2.StopEgressRequest, opts ...psrpc.RequestOption) (*livekit2.EgressInfo, error) {
	return client.RequestSingle[*livekit2.EgressInfo](ctx, c.client, "StopEgress", []string{topic}, req, opts...)
}

// ====================
// EgressHandler Server
// ====================

type egressHandlerServer struct {
	svc EgressHandlerServerImpl
	rpc *server.RPCServer
}

// NewEgressHandlerServer builds a RPCServer that will route requests
// to the corresponding method in the provided svc implementation.
func NewEgressHandlerServer(svc EgressHandlerServerImpl, bus psrpc.MessageBus, opts ...psrpc.ServerOption) (EgressHandlerServer, error) {
	sd := &info.ServiceDefinition{
		Name: "EgressHandler",
		ID:   rand.NewServerID(),
	}

	s := server.NewRPCServer(sd, bus, opts...)

	sd.RegisterMethod("UpdateStream", false, false, true, true)
	sd.RegisterMethod("StopEgress", false, false, true, true)
	return &egressHandlerServer{
		svc: svc,
		rpc: s,
	}, nil
}

func (s *egressHandlerServer) RegisterUpdateStreamTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "UpdateStream", []string{topic}, s.svc.UpdateStream, nil)
}

func (s *egressHandlerServer) DeregisterUpdateStreamTopic(topic string) {
	s.rpc.DeregisterHandler("UpdateStream", []string{topic})
}

func (s *egressHandlerServer) RegisterStopEgressTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "StopEgress", []string{topic}, s.svc.StopEgress, nil)
}

func (s *egressHandlerServer) DeregisterStopEgressTopic(topic string) {
	s.rpc.DeregisterHandler("StopEgress", []string{topic})
}

func (s *egressHandlerServer) Shutdown() {
	s.rpc.Close(false)
}

func (s *egressHandlerServer) Kill() {
	s.rpc.Close(true)
}

var psrpcFileDescriptor1 = []byte{
	// 584 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x52, 0xdd, 0x6e, 0x12, 0x41,
	0x14, 0x76, 0x40, 0x68, 0x39, 0x94, 0x4a, 0xc6, 0x9a, 0x4e, 0xb7, 0x6d, 0x82, 0xa8, 0x09, 0x69,
	0x74, 0x31, 0xf4, 0x46, 0xbd, 0xb2, 0x35, 0xc4, 0x92, 0xd4, 0xa8, 0x5b, 0x1b, 0x13, 0xbd, 0x20,
	0xc3, 0xee, 0x14, 0x27, 0x2c, 0x3b, 0xe3, 0xcc, 0x00, 0xe1, 0x11, 0xfa, 0x18, 0xbe, 0x42, 0x2f,
	0x7c, 0x20, 0x9f, 0xc4, 0x30, 0x03, 0xdb, 0x85, 0x06, 0xe3, 0xd5, 0xee, 0x7c, 0x7f, 0x73, 0xce,
	0x99, 0x03, 0x55, 0x25, 0xc3, 0x26, 0xeb, 0x2b, 0xa6, 0xb5, 0x2f, 0x95, 0x30, 0x02, 0xe7, 0x95,
	0x0c, 0xbd, 0xbd, 0xbe, 0x10, 0xfd, 0x98, 0x35, 0x2d, 0xd4, 0x1b, 0x5d, 0x35, 0x69, 0x32, 0x75,
	0xbc, 0x57, 0x11, 0xd2, 0x70, 0x91, 0xcc, 0xe5, 0xde, 0x4e, 0xcc, 0xc7, 0x6c, 0xc0, 0x4d, 0x37,
	0x1b, 0x52, 0xff, 0x73, 0x1f, 0xf0, 0x85, 0xa1, 0xca, 0xb4, 0x2d, 0x1a, 0xb0, 0x9f, 0x23, 0xa6,
	0x0d, 0xde, 0x87, 0x92, 0x93, 0x75, 0x79, 0x44, 0x50, 0x0d, 0x35, 0x4a, 0xc1, 0xa6, 0x03, 0x3a,
	0x11, 0x3e, 0x87, 0x6d, 0x25, 0xc4, 0xb0, 0x1b, 0x8a, 0xa1, 0x14, 0x9a, 0x1b, 0x46, 0x0a, 0x35,
	0xd4, 0x28, 0xb7, 0x9e, 0xf8, 0xf3, 0x2b, 0xfc, 0x40, 0x88, 0xe1, 0xbb, 0x05, 0xbb, 0x94, 0x7c,
	0x76, 0x2f, 0xa8, 0xa8, 0x2c, 0x8b, 0x5f, 0x40, 0x7e, 0xc2, 0x7a, 0xa4, 0x6c, 0x23, 0xf6, 0xd2,
	0x88, 0xaf, 0xac, 0xb7, 0x6a, 0x9c, 0xe9, 0x70, 0x1b, 0xca, 0x92, 0x2a, 0xc3, 0x43, 0x2e, 0x69,
	0x62, 0x48, 0xc5, 0xda, 0x1e, 0xa7, 0xb6, 0x4f, 0xb7, 0xdc, 0xaa, 0x3d, 0xeb, 0xc3, 0x1f, 0xe1,
	0x81, 0x51, 0x34, 0x1c, 0x64, 0x9a, 0x28, 0xda, 0xa8, 0xa7, 0x69, 0xd4, 0x97, 0x19, 0xbf, 0xb6,
	0x8b, 0x6d, 0xb3, 0x44, 0xe3, 0x63, 0x28, 0x58, 0x84, 0x6c, 0xd8, 0x98, 0xfd, 0xe5, 0x98, 0x55,
	0xb7, 0xd3, 0xe2, 0x5d, 0xd8, 0xb0, 0x93, 0xe4, 0x11, 0xc9, 0xdb, 0x21, 0x17, 0x67, 0xc7, 0x4e,
	0x84, 0x77, 0xa0, 0x60, 0xc4, 0x80, 0x25, 0x64, 0xd3, 0xc2, 0xee, 0x80, 0x1f, 0x41, 0x71, 0xa2,
	0xbb, 0x23, 0x15, 0x93, 0x92, 0x83, 0x27, 0xfa, 0x52, 0xc5, 0xf8, 0x04, 0x36, 0x87, 0xcc, 0xd0,
	0x88, 0x1a, 0x4a, 0xb6, 0x6a, 0xf9, 0x46, 0xb9, 0xf5, 0xcc, 0x57, 0x32, 0xf4, 0xef, 0xbe, 0xab,
	0xff, 0x61, 0xae, 0x6b, 0x27, 0x46, 0x4d, 0x83, 0xd4, 0xe6, 0x7d, 0x86, 0xca, 0x12, 0x85, 0xab,
	0x90, 0x1f, 0xb0, 0xe9, 0xfc, 0xe9, 0x67, 0xbf, 0xf8, 0x08, 0x0a, 0x63, 0x1a, 0x8f, 0x18, 0xc9,
	0xd9, 0x06, 0x77, 0x7c, 0xb7, 0x79, 0xfe, 0x62, 0xf3, 0xfc, 0x93, 0x64, 0x1a, 0x38, 0xc9, 0x9b,
	0xdc, 0x2b, 0x74, 0x5a, 0x82, 0x0d, 0xe5, 0x6e, 0xad, 0xef, 0xc1, 0xee, 0x39, 0xd7, 0xe6, 0x24,
	0x34, 0x7c, 0xbc, 0x3c, 0xc8, 0xfa, 0x6b, 0x20, 0x77, 0x29, 0x2d, 0x45, 0xa2, 0x19, 0x3e, 0x04,
	0x48, 0x97, 0x50, 0x13, 0x54, 0xcb, 0x37, 0x4a, 0x41, 0x69, 0xb1, 0x85, 0xba, 0xf5, 0x1b, 0xc1,
	0xb6, 0x73, 0x74, 0x12, 0xc3, 0x54, 0x42, 0x63, 0xfc, 0x1e, 0xca, 0x99, 0xa6, 0xf1, 0xee, 0x9a,
	0x31, 0x78, 0x0f, 0xd3, 0xd7, 0x59, 0x04, 0x5c, 0x89, 0x3a, 0xdc, 0x5c, 0xa3, 0x62, 0x15, 0xbd,
	0x45, 0x2f, 0x11, 0xfe, 0x0e, 0xd5, 0xd5, 0xb2, 0xf0, 0x81, 0x4d, 0x5b, 0xd3, 0x88, 0x77, 0xb8,
	0x86, 0x75, 0xbd, 0xa4, 0xe1, 0xb9, 0x06, 0x6a, 0xfd, 0x42, 0x50, 0x71, 0xf4, 0x19, 0x4d, 0xa2,
	0x98, 0x29, 0xdc, 0x81, 0xad, 0x4b, 0x19, 0x51, 0xc3, 0x2e, 0x8c, 0x62, 0x74, 0x88, 0x0f, 0xd2,
	0xfa, 0xb2, 0xf0, 0x3f, 0xab, 0x2f, 0xde, 0x5c, 0xa3, 0x5c, 0x15, 0xe1, 0x36, 0xc0, 0x85, 0x11,
	0x72, 0x5e, 0xb3, 0x97, 0x4a, 0x6f, 0xc1, 0xff, 0x89, 0x39, 0x7d, 0xfe, 0xed, 0xa8, 0xcf, 0xcd,
	0x8f, 0x51, 0xcf, 0x0f, 0xc5, 0xb0, 0x39, 0x17, 0xa6, 0x5f, 0x39, 0xe8, 0x37, 0x35, 0x53, 0x63,
	0x1e, 0xb2, 0xa6, 0x92, 0x61, 0xaf, 0x68, 0x97, 0xe0, 0xf8, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x95, 0xb8, 0x97, 0x1a, 0xa5, 0x04, 0x00, 0x00,
}
