// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use glib_sys as glib;
use gstreamer_sys as gst;

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE,
};
#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type GstMIKEYCacheType = c_int;
pub const GST_MIKEY_CACHE_NONE: GstMIKEYCacheType = 0;
pub const GST_MIKEY_CACHE_ALWAYS: GstMIKEYCacheType = 1;
pub const GST_MIKEY_CACHE_FOR_CSB: GstMIKEYCacheType = 2;

pub type GstMIKEYEncAlg = c_int;
pub const GST_MIKEY_ENC_NULL: GstMIKEYEncAlg = 0;
pub const GST_MIKEY_ENC_AES_CM_128: GstMIKEYEncAlg = 1;
pub const GST_MIKEY_ENC_AES_KW_128: GstMIKEYEncAlg = 2;
pub const GST_MIKEY_ENC_AES_GCM_128: GstMIKEYEncAlg = 6;

pub type GstMIKEYKVType = c_int;
pub const GST_MIKEY_KV_NULL: GstMIKEYKVType = 0;
pub const GST_MIKEY_KV_SPI: GstMIKEYKVType = 1;
pub const GST_MIKEY_KV_INTERVAL: GstMIKEYKVType = 2;

pub type GstMIKEYKeyDataType = c_int;
pub const GST_MIKEY_KD_TGK: GstMIKEYKeyDataType = 0;
pub const GST_MIKEY_KD_TEK: GstMIKEYKeyDataType = 2;

pub type GstMIKEYMacAlg = c_int;
pub const GST_MIKEY_MAC_NULL: GstMIKEYMacAlg = 0;
pub const GST_MIKEY_MAC_HMAC_SHA_1_160: GstMIKEYMacAlg = 1;

pub type GstMIKEYMapType = c_int;
pub const GST_MIKEY_MAP_TYPE_SRTP: GstMIKEYMapType = 0;

pub type GstMIKEYPRFFunc = c_int;
pub const GST_MIKEY_PRF_MIKEY_1: GstMIKEYPRFFunc = 0;

pub type GstMIKEYPayloadType = c_int;
pub const GST_MIKEY_PT_LAST: GstMIKEYPayloadType = 0;
pub const GST_MIKEY_PT_KEMAC: GstMIKEYPayloadType = 1;
pub const GST_MIKEY_PT_PKE: GstMIKEYPayloadType = 2;
pub const GST_MIKEY_PT_DH: GstMIKEYPayloadType = 3;
pub const GST_MIKEY_PT_SIGN: GstMIKEYPayloadType = 4;
pub const GST_MIKEY_PT_T: GstMIKEYPayloadType = 5;
pub const GST_MIKEY_PT_ID: GstMIKEYPayloadType = 6;
pub const GST_MIKEY_PT_CERT: GstMIKEYPayloadType = 7;
pub const GST_MIKEY_PT_CHASH: GstMIKEYPayloadType = 8;
pub const GST_MIKEY_PT_V: GstMIKEYPayloadType = 9;
pub const GST_MIKEY_PT_SP: GstMIKEYPayloadType = 10;
pub const GST_MIKEY_PT_RAND: GstMIKEYPayloadType = 11;
pub const GST_MIKEY_PT_ERR: GstMIKEYPayloadType = 12;
pub const GST_MIKEY_PT_KEY_DATA: GstMIKEYPayloadType = 20;
pub const GST_MIKEY_PT_GEN_EXT: GstMIKEYPayloadType = 21;

pub type GstMIKEYSecProto = c_int;
pub const GST_MIKEY_SEC_PROTO_SRTP: GstMIKEYSecProto = 0;

pub type GstMIKEYSecSRTP = c_int;
pub const GST_MIKEY_SP_SRTP_ENC_ALG: GstMIKEYSecSRTP = 0;
pub const GST_MIKEY_SP_SRTP_ENC_KEY_LEN: GstMIKEYSecSRTP = 1;
pub const GST_MIKEY_SP_SRTP_AUTH_ALG: GstMIKEYSecSRTP = 2;
pub const GST_MIKEY_SP_SRTP_AUTH_KEY_LEN: GstMIKEYSecSRTP = 3;
pub const GST_MIKEY_SP_SRTP_SALT_KEY_LEN: GstMIKEYSecSRTP = 4;
pub const GST_MIKEY_SP_SRTP_PRF: GstMIKEYSecSRTP = 5;
pub const GST_MIKEY_SP_SRTP_KEY_DERIV_RATE: GstMIKEYSecSRTP = 6;
pub const GST_MIKEY_SP_SRTP_SRTP_ENC: GstMIKEYSecSRTP = 7;
pub const GST_MIKEY_SP_SRTP_SRTCP_ENC: GstMIKEYSecSRTP = 8;
pub const GST_MIKEY_SP_SRTP_FEC_ORDER: GstMIKEYSecSRTP = 9;
pub const GST_MIKEY_SP_SRTP_SRTP_AUTH: GstMIKEYSecSRTP = 10;
pub const GST_MIKEY_SP_SRTP_AUTH_TAG_LEN: GstMIKEYSecSRTP = 11;
pub const GST_MIKEY_SP_SRTP_SRTP_PREFIX_LEN: GstMIKEYSecSRTP = 12;
pub const GST_MIKEY_SP_SRTP_AEAD_AUTH_TAG_LEN: GstMIKEYSecSRTP = 20;

pub type GstMIKEYTSType = c_int;
pub const GST_MIKEY_TS_TYPE_NTP_UTC: GstMIKEYTSType = 0;
pub const GST_MIKEY_TS_TYPE_NTP: GstMIKEYTSType = 1;
pub const GST_MIKEY_TS_TYPE_COUNTER: GstMIKEYTSType = 2;

pub type GstMIKEYType = c_int;
pub const GST_MIKEY_TYPE_INVALID: GstMIKEYType = -1;
pub const GST_MIKEY_TYPE_PSK_INIT: GstMIKEYType = 0;
pub const GST_MIKEY_TYPE_PSK_VERIFY: GstMIKEYType = 1;
pub const GST_MIKEY_TYPE_PK_INIT: GstMIKEYType = 2;
pub const GST_MIKEY_TYPE_PK_VERIFY: GstMIKEYType = 3;
pub const GST_MIKEY_TYPE_DH_INIT: GstMIKEYType = 4;
pub const GST_MIKEY_TYPE_DH_RESP: GstMIKEYType = 5;
pub const GST_MIKEY_TYPE_ERROR: GstMIKEYType = 6;

pub type GstSDPResult = c_int;
pub const GST_SDP_OK: GstSDPResult = 0;
pub const GST_SDP_EINVAL: GstSDPResult = -1;

// Constants
pub const GST_MIKEY_VERSION: c_int = 1;
pub const GST_SDP_BWTYPE_AS: &[u8] = b"AS\0";
pub const GST_SDP_BWTYPE_CT: &[u8] = b"CT\0";
pub const GST_SDP_BWTYPE_EXT_PREFIX: &[u8] = b"X-\0";
pub const GST_SDP_BWTYPE_RR: &[u8] = b"RR\0";
pub const GST_SDP_BWTYPE_RS: &[u8] = b"RS\0";
pub const GST_SDP_BWTYPE_TIAS: &[u8] = b"TIAS\0";

// Records
#[repr(C)]
pub struct _GstMIKEYDecryptInfo {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstMIKEYDecryptInfo = _GstMIKEYDecryptInfo;

#[repr(C)]
pub struct _GstMIKEYEncryptInfo {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstMIKEYEncryptInfo = _GstMIKEYEncryptInfo;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYMapSRTP {
    pub policy: u8,
    pub ssrc: u32,
    pub roc: u32,
}

impl ::std::fmt::Debug for GstMIKEYMapSRTP {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYMapSRTP @ {self:p}"))
            .field("policy", &self.policy)
            .field("ssrc", &self.ssrc)
            .field("roc", &self.roc)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYMessage {
    pub mini_object: gst::GstMiniObject,
    pub version: u8,
    pub type_: GstMIKEYType,
    pub V: gboolean,
    pub prf_func: GstMIKEYPRFFunc,
    pub CSB_id: u32,
    pub map_type: GstMIKEYMapType,
    pub map_info: *mut glib::GArray,
    pub payloads: *mut glib::GArray,
}

impl ::std::fmt::Debug for GstMIKEYMessage {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYMessage @ {self:p}"))
            .field("version", &self.version)
            .field("type_", &self.type_)
            .field("V", &self.V)
            .field("prf_func", &self.prf_func)
            .field("CSB_id", &self.CSB_id)
            .field("map_type", &self.map_type)
            .field("map_info", &self.map_info)
            .field("payloads", &self.payloads)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayload {
    pub mini_object: gst::GstMiniObject,
    pub type_: GstMIKEYPayloadType,
    pub len: c_uint,
}

impl ::std::fmt::Debug for GstMIKEYPayload {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayload @ {self:p}"))
            .field("type_", &self.type_)
            .field("len", &self.len)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayloadKEMAC {
    pub pt: GstMIKEYPayload,
    pub enc_alg: GstMIKEYEncAlg,
    pub mac_alg: GstMIKEYMacAlg,
    pub subpayloads: *mut glib::GArray,
}

impl ::std::fmt::Debug for GstMIKEYPayloadKEMAC {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayloadKEMAC @ {self:p}"))
            .field("pt", &self.pt)
            .field("enc_alg", &self.enc_alg)
            .field("mac_alg", &self.mac_alg)
            .field("subpayloads", &self.subpayloads)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayloadKeyData {
    pub pt: GstMIKEYPayload,
    pub key_type: GstMIKEYKeyDataType,
    pub key_len: u16,
    pub key_data: *mut u8,
    pub salt_len: u16,
    pub salt_data: *mut u8,
    pub kv_type: GstMIKEYKVType,
    pub kv_len: [u8; 2],
    pub kv_data: [*mut u8; 2],
}

impl ::std::fmt::Debug for GstMIKEYPayloadKeyData {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayloadKeyData @ {self:p}"))
            .field("pt", &self.pt)
            .field("key_type", &self.key_type)
            .field("key_len", &self.key_len)
            .field("key_data", &self.key_data)
            .field("salt_len", &self.salt_len)
            .field("salt_data", &self.salt_data)
            .field("kv_type", &self.kv_type)
            .field("kv_len", &self.kv_len)
            .field("kv_data", &self.kv_data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayloadPKE {
    pub pt: GstMIKEYPayload,
    pub C: GstMIKEYCacheType,
    pub data_len: u16,
    pub data: *mut u8,
}

impl ::std::fmt::Debug for GstMIKEYPayloadPKE {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayloadPKE @ {self:p}"))
            .field("pt", &self.pt)
            .field("C", &self.C)
            .field("data_len", &self.data_len)
            .field("data", &self.data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayloadRAND {
    pub pt: GstMIKEYPayload,
    pub len: u8,
    pub rand: *mut u8,
}

impl ::std::fmt::Debug for GstMIKEYPayloadRAND {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayloadRAND @ {self:p}"))
            .field("pt", &self.pt)
            .field("len", &self.len)
            .field("rand", &self.rand)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayloadSP {
    pub pt: GstMIKEYPayload,
    pub policy: c_uint,
    pub proto: GstMIKEYSecProto,
    pub params: *mut glib::GArray,
}

impl ::std::fmt::Debug for GstMIKEYPayloadSP {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayloadSP @ {self:p}"))
            .field("pt", &self.pt)
            .field("policy", &self.policy)
            .field("proto", &self.proto)
            .field("params", &self.params)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayloadSPParam {
    pub type_: u8,
    pub len: u8,
    pub val: *mut u8,
}

impl ::std::fmt::Debug for GstMIKEYPayloadSPParam {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayloadSPParam @ {self:p}"))
            .field("type_", &self.type_)
            .field("len", &self.len)
            .field("val", &self.val)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstMIKEYPayloadT {
    pub pt: GstMIKEYPayload,
    pub type_: GstMIKEYTSType,
    pub ts_value: *mut u8,
}

impl ::std::fmt::Debug for GstMIKEYPayloadT {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstMIKEYPayloadT @ {self:p}"))
            .field("pt", &self.pt)
            .field("type_", &self.type_)
            .field("ts_value", &self.ts_value)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPAttribute {
    pub key: *mut c_char,
    pub value: *mut c_char,
}

impl ::std::fmt::Debug for GstSDPAttribute {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPAttribute @ {self:p}"))
            .field("key", &self.key)
            .field("value", &self.value)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPBandwidth {
    pub bwtype: *mut c_char,
    pub bandwidth: c_uint,
}

impl ::std::fmt::Debug for GstSDPBandwidth {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPBandwidth @ {self:p}"))
            .field("bwtype", &self.bwtype)
            .field("bandwidth", &self.bandwidth)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPConnection {
    pub nettype: *mut c_char,
    pub addrtype: *mut c_char,
    pub address: *mut c_char,
    pub ttl: c_uint,
    pub addr_number: c_uint,
}

impl ::std::fmt::Debug for GstSDPConnection {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPConnection @ {self:p}"))
            .field("nettype", &self.nettype)
            .field("addrtype", &self.addrtype)
            .field("address", &self.address)
            .field("ttl", &self.ttl)
            .field("addr_number", &self.addr_number)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPKey {
    pub type_: *mut c_char,
    pub data: *mut c_char,
}

impl ::std::fmt::Debug for GstSDPKey {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPKey @ {self:p}"))
            .field("type_", &self.type_)
            .field("data", &self.data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPMedia {
    pub media: *mut c_char,
    pub port: c_uint,
    pub num_ports: c_uint,
    pub proto: *mut c_char,
    pub fmts: *mut glib::GArray,
    pub information: *mut c_char,
    pub connections: *mut glib::GArray,
    pub bandwidths: *mut glib::GArray,
    pub key: GstSDPKey,
    pub attributes: *mut glib::GArray,
}

impl ::std::fmt::Debug for GstSDPMedia {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPMedia @ {self:p}"))
            .field("media", &self.media)
            .field("port", &self.port)
            .field("num_ports", &self.num_ports)
            .field("proto", &self.proto)
            .field("fmts", &self.fmts)
            .field("information", &self.information)
            .field("connections", &self.connections)
            .field("bandwidths", &self.bandwidths)
            .field("key", &self.key)
            .field("attributes", &self.attributes)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPMessage {
    pub version: *mut c_char,
    pub origin: GstSDPOrigin,
    pub session_name: *mut c_char,
    pub information: *mut c_char,
    pub uri: *mut c_char,
    pub emails: *mut glib::GArray,
    pub phones: *mut glib::GArray,
    pub connection: GstSDPConnection,
    pub bandwidths: *mut glib::GArray,
    pub times: *mut glib::GArray,
    pub zones: *mut glib::GArray,
    pub key: GstSDPKey,
    pub attributes: *mut glib::GArray,
    pub medias: *mut glib::GArray,
}

impl ::std::fmt::Debug for GstSDPMessage {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPMessage @ {self:p}"))
            .field("version", &self.version)
            .field("origin", &self.origin)
            .field("session_name", &self.session_name)
            .field("information", &self.information)
            .field("uri", &self.uri)
            .field("emails", &self.emails)
            .field("phones", &self.phones)
            .field("connection", &self.connection)
            .field("bandwidths", &self.bandwidths)
            .field("times", &self.times)
            .field("zones", &self.zones)
            .field("key", &self.key)
            .field("attributes", &self.attributes)
            .field("medias", &self.medias)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPOrigin {
    pub username: *mut c_char,
    pub sess_id: *mut c_char,
    pub sess_version: *mut c_char,
    pub nettype: *mut c_char,
    pub addrtype: *mut c_char,
    pub addr: *mut c_char,
}

impl ::std::fmt::Debug for GstSDPOrigin {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPOrigin @ {self:p}"))
            .field("username", &self.username)
            .field("sess_id", &self.sess_id)
            .field("sess_version", &self.sess_version)
            .field("nettype", &self.nettype)
            .field("addrtype", &self.addrtype)
            .field("addr", &self.addr)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPTime {
    pub start: *mut c_char,
    pub stop: *mut c_char,
    pub repeat: *mut glib::GArray,
}

impl ::std::fmt::Debug for GstSDPTime {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPTime @ {self:p}"))
            .field("start", &self.start)
            .field("stop", &self.stop)
            .field("repeat", &self.repeat)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstSDPZone {
    pub time: *mut c_char,
    pub typed_time: *mut c_char,
}

impl ::std::fmt::Debug for GstSDPZone {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstSDPZone @ {self:p}"))
            .field("time", &self.time)
            .field("typed_time", &self.typed_time)
            .finish()
    }
}

#[link(name = "gstsdp-1.0")]
extern "C" {

    //=========================================================================
    // GstMIKEYMessage
    //=========================================================================
    pub fn gst_mikey_message_get_type() -> GType;
    pub fn gst_mikey_message_new() -> *mut GstMIKEYMessage;
    pub fn gst_mikey_message_new_from_bytes(
        bytes: *mut glib::GBytes,
        info: *mut GstMIKEYDecryptInfo,
        error: *mut *mut glib::GError,
    ) -> *mut GstMIKEYMessage;
    pub fn gst_mikey_message_new_from_caps(caps: *mut gst::GstCaps) -> *mut GstMIKEYMessage;
    pub fn gst_mikey_message_new_from_data(
        data: gconstpointer,
        size: size_t,
        info: *mut GstMIKEYDecryptInfo,
        error: *mut *mut glib::GError,
    ) -> *mut GstMIKEYMessage;
    pub fn gst_mikey_message_add_cs_srtp(
        msg: *mut GstMIKEYMessage,
        policy: u8,
        ssrc: u32,
        roc: u32,
    ) -> gboolean;
    pub fn gst_mikey_message_add_payload(
        msg: *mut GstMIKEYMessage,
        payload: *mut GstMIKEYPayload,
    ) -> gboolean;
    pub fn gst_mikey_message_add_pke(
        msg: *mut GstMIKEYMessage,
        C: GstMIKEYCacheType,
        data_len: u16,
        data: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_message_add_rand(
        msg: *mut GstMIKEYMessage,
        len: u8,
        rand: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_message_add_rand_len(msg: *mut GstMIKEYMessage, len: u8) -> gboolean;
    pub fn gst_mikey_message_add_t(
        msg: *mut GstMIKEYMessage,
        type_: GstMIKEYTSType,
        ts_value: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_message_add_t_now_ntp_utc(msg: *mut GstMIKEYMessage) -> gboolean;
    pub fn gst_mikey_message_base64_encode(msg: *mut GstMIKEYMessage) -> *mut c_char;
    pub fn gst_mikey_message_find_payload(
        msg: *const GstMIKEYMessage,
        type_: GstMIKEYPayloadType,
        nth: c_uint,
    ) -> *const GstMIKEYPayload;
    pub fn gst_mikey_message_get_cs_srtp(
        msg: *const GstMIKEYMessage,
        idx: c_uint,
    ) -> *const GstMIKEYMapSRTP;
    pub fn gst_mikey_message_get_n_cs(msg: *const GstMIKEYMessage) -> c_uint;
    pub fn gst_mikey_message_get_n_payloads(msg: *const GstMIKEYMessage) -> c_uint;
    pub fn gst_mikey_message_get_payload(
        msg: *const GstMIKEYMessage,
        idx: c_uint,
    ) -> *const GstMIKEYPayload;
    pub fn gst_mikey_message_insert_cs_srtp(
        msg: *mut GstMIKEYMessage,
        idx: c_int,
        map: *const GstMIKEYMapSRTP,
    ) -> gboolean;
    pub fn gst_mikey_message_insert_payload(
        msg: *mut GstMIKEYMessage,
        idx: c_uint,
        payload: *mut GstMIKEYPayload,
    ) -> gboolean;
    pub fn gst_mikey_message_remove_cs_srtp(msg: *mut GstMIKEYMessage, idx: c_int) -> gboolean;
    pub fn gst_mikey_message_remove_payload(msg: *mut GstMIKEYMessage, idx: c_uint) -> gboolean;
    pub fn gst_mikey_message_replace_cs_srtp(
        msg: *mut GstMIKEYMessage,
        idx: c_int,
        map: *const GstMIKEYMapSRTP,
    ) -> gboolean;
    pub fn gst_mikey_message_replace_payload(
        msg: *mut GstMIKEYMessage,
        idx: c_uint,
        payload: *mut GstMIKEYPayload,
    ) -> gboolean;
    pub fn gst_mikey_message_set_info(
        msg: *mut GstMIKEYMessage,
        version: u8,
        type_: GstMIKEYType,
        V: gboolean,
        prf_func: GstMIKEYPRFFunc,
        CSB_id: u32,
        map_type: GstMIKEYMapType,
    ) -> gboolean;
    pub fn gst_mikey_message_to_bytes(
        msg: *mut GstMIKEYMessage,
        info: *mut GstMIKEYEncryptInfo,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GBytes;
    pub fn gst_mikey_message_to_caps(
        msg: *const GstMIKEYMessage,
        caps: *mut gst::GstCaps,
    ) -> gboolean;

    //=========================================================================
    // GstMIKEYPayload
    //=========================================================================
    pub fn gst_mikey_payload_get_type() -> GType;
    pub fn gst_mikey_payload_new(type_: GstMIKEYPayloadType) -> *mut GstMIKEYPayload;
    pub fn gst_mikey_payload_kemac_add_sub(
        payload: *mut GstMIKEYPayload,
        newpay: *mut GstMIKEYPayload,
    ) -> gboolean;
    pub fn gst_mikey_payload_kemac_get_n_sub(payload: *const GstMIKEYPayload) -> c_uint;
    pub fn gst_mikey_payload_kemac_get_sub(
        payload: *const GstMIKEYPayload,
        idx: c_uint,
    ) -> *const GstMIKEYPayload;
    pub fn gst_mikey_payload_kemac_remove_sub(
        payload: *mut GstMIKEYPayload,
        idx: c_uint,
    ) -> gboolean;
    pub fn gst_mikey_payload_kemac_set(
        payload: *mut GstMIKEYPayload,
        enc_alg: GstMIKEYEncAlg,
        mac_alg: GstMIKEYMacAlg,
    ) -> gboolean;
    pub fn gst_mikey_payload_key_data_set_interval(
        payload: *mut GstMIKEYPayload,
        vf_len: u8,
        vf_data: *const u8,
        vt_len: u8,
        vt_data: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_payload_key_data_set_key(
        payload: *mut GstMIKEYPayload,
        key_type: GstMIKEYKeyDataType,
        key_len: u16,
        key_data: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_payload_key_data_set_salt(
        payload: *mut GstMIKEYPayload,
        salt_len: u16,
        salt_data: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_payload_key_data_set_spi(
        payload: *mut GstMIKEYPayload,
        spi_len: u8,
        spi_data: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_payload_pke_set(
        payload: *mut GstMIKEYPayload,
        C: GstMIKEYCacheType,
        data_len: u16,
        data: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_payload_rand_set(
        payload: *mut GstMIKEYPayload,
        len: u8,
        rand: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_payload_sp_add_param(
        payload: *mut GstMIKEYPayload,
        type_: u8,
        len: u8,
        val: *const u8,
    ) -> gboolean;
    pub fn gst_mikey_payload_sp_get_n_params(payload: *const GstMIKEYPayload) -> c_uint;
    pub fn gst_mikey_payload_sp_get_param(
        payload: *const GstMIKEYPayload,
        idx: c_uint,
    ) -> *const GstMIKEYPayloadSPParam;
    pub fn gst_mikey_payload_sp_remove_param(
        payload: *mut GstMIKEYPayload,
        idx: c_uint,
    ) -> gboolean;
    pub fn gst_mikey_payload_sp_set(
        payload: *mut GstMIKEYPayload,
        policy: c_uint,
        proto: GstMIKEYSecProto,
    ) -> gboolean;
    pub fn gst_mikey_payload_t_set(
        payload: *mut GstMIKEYPayload,
        type_: GstMIKEYTSType,
        ts_value: *const u8,
    ) -> gboolean;

    //=========================================================================
    // GstSDPAttribute
    //=========================================================================
    pub fn gst_sdp_attribute_clear(attr: *mut GstSDPAttribute) -> GstSDPResult;
    pub fn gst_sdp_attribute_set(
        attr: *mut GstSDPAttribute,
        key: *const c_char,
        value: *const c_char,
    ) -> GstSDPResult;

    //=========================================================================
    // GstSDPBandwidth
    //=========================================================================
    pub fn gst_sdp_bandwidth_clear(bw: *mut GstSDPBandwidth) -> GstSDPResult;
    pub fn gst_sdp_bandwidth_set(
        bw: *mut GstSDPBandwidth,
        bwtype: *const c_char,
        bandwidth: c_uint,
    ) -> GstSDPResult;

    //=========================================================================
    // GstSDPConnection
    //=========================================================================
    pub fn gst_sdp_connection_clear(conn: *mut GstSDPConnection) -> GstSDPResult;
    pub fn gst_sdp_connection_set(
        conn: *mut GstSDPConnection,
        nettype: *const c_char,
        addrtype: *const c_char,
        address: *const c_char,
        ttl: c_uint,
        addr_number: c_uint,
    ) -> GstSDPResult;

    //=========================================================================
    // GstSDPMedia
    //=========================================================================
    pub fn gst_sdp_media_add_attribute(
        media: *mut GstSDPMedia,
        key: *const c_char,
        value: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_add_bandwidth(
        media: *mut GstSDPMedia,
        bwtype: *const c_char,
        bandwidth: c_uint,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_add_connection(
        media: *mut GstSDPMedia,
        nettype: *const c_char,
        addrtype: *const c_char,
        address: *const c_char,
        ttl: c_uint,
        addr_number: c_uint,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_add_format(media: *mut GstSDPMedia, format: *const c_char)
        -> GstSDPResult;
    pub fn gst_sdp_media_as_text(media: *const GstSDPMedia) -> *mut c_char;
    pub fn gst_sdp_media_attributes_len(media: *const GstSDPMedia) -> c_uint;
    pub fn gst_sdp_media_attributes_to_caps(
        media: *const GstSDPMedia,
        caps: *mut gst::GstCaps,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_bandwidths_len(media: *const GstSDPMedia) -> c_uint;
    pub fn gst_sdp_media_connections_len(media: *const GstSDPMedia) -> c_uint;
    pub fn gst_sdp_media_copy(
        media: *const GstSDPMedia,
        copy: *mut *mut GstSDPMedia,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_formats_len(media: *const GstSDPMedia) -> c_uint;
    pub fn gst_sdp_media_free(media: *mut GstSDPMedia) -> GstSDPResult;
    pub fn gst_sdp_media_get_attribute(
        media: *const GstSDPMedia,
        idx: c_uint,
    ) -> *const GstSDPAttribute;
    pub fn gst_sdp_media_get_attribute_val(
        media: *const GstSDPMedia,
        key: *const c_char,
    ) -> *const c_char;
    pub fn gst_sdp_media_get_attribute_val_n(
        media: *const GstSDPMedia,
        key: *const c_char,
        nth: c_uint,
    ) -> *const c_char;
    pub fn gst_sdp_media_get_bandwidth(
        media: *const GstSDPMedia,
        idx: c_uint,
    ) -> *const GstSDPBandwidth;
    pub fn gst_sdp_media_get_caps_from_media(
        media: *const GstSDPMedia,
        pt: c_int,
    ) -> *mut gst::GstCaps;
    pub fn gst_sdp_media_get_connection(
        media: *const GstSDPMedia,
        idx: c_uint,
    ) -> *const GstSDPConnection;
    pub fn gst_sdp_media_get_format(media: *const GstSDPMedia, idx: c_uint) -> *const c_char;
    pub fn gst_sdp_media_get_information(media: *const GstSDPMedia) -> *const c_char;
    pub fn gst_sdp_media_get_key(media: *const GstSDPMedia) -> *const GstSDPKey;
    pub fn gst_sdp_media_get_media(media: *const GstSDPMedia) -> *const c_char;
    pub fn gst_sdp_media_get_num_ports(media: *const GstSDPMedia) -> c_uint;
    pub fn gst_sdp_media_get_port(media: *const GstSDPMedia) -> c_uint;
    pub fn gst_sdp_media_get_proto(media: *const GstSDPMedia) -> *const c_char;
    pub fn gst_sdp_media_insert_attribute(
        media: *mut GstSDPMedia,
        idx: c_int,
        attr: *mut GstSDPAttribute,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_insert_bandwidth(
        media: *mut GstSDPMedia,
        idx: c_int,
        bw: *mut GstSDPBandwidth,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_insert_connection(
        media: *mut GstSDPMedia,
        idx: c_int,
        conn: *mut GstSDPConnection,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_insert_format(
        media: *mut GstSDPMedia,
        idx: c_int,
        format: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_parse_keymgmt(
        media: *const GstSDPMedia,
        mikey: *mut *mut GstMIKEYMessage,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_remove_attribute(media: *mut GstSDPMedia, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_media_remove_bandwidth(media: *mut GstSDPMedia, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_media_remove_connection(media: *mut GstSDPMedia, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_media_remove_format(media: *mut GstSDPMedia, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_media_replace_attribute(
        media: *mut GstSDPMedia,
        idx: c_uint,
        attr: *mut GstSDPAttribute,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_replace_bandwidth(
        media: *mut GstSDPMedia,
        idx: c_uint,
        bw: *mut GstSDPBandwidth,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_replace_connection(
        media: *mut GstSDPMedia,
        idx: c_uint,
        conn: *mut GstSDPConnection,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_replace_format(
        media: *mut GstSDPMedia,
        idx: c_uint,
        format: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_set_information(
        media: *mut GstSDPMedia,
        information: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_set_key(
        media: *mut GstSDPMedia,
        type_: *const c_char,
        data: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_set_media(media: *mut GstSDPMedia, med: *const c_char) -> GstSDPResult;
    pub fn gst_sdp_media_set_port_info(
        media: *mut GstSDPMedia,
        port: c_uint,
        num_ports: c_uint,
    ) -> GstSDPResult;
    pub fn gst_sdp_media_set_proto(media: *mut GstSDPMedia, proto: *const c_char) -> GstSDPResult;
    pub fn gst_sdp_media_uninit(media: *mut GstSDPMedia) -> GstSDPResult;
    pub fn gst_sdp_media_init(media: *mut GstSDPMedia) -> GstSDPResult;
    pub fn gst_sdp_media_new(media: *mut *mut GstSDPMedia) -> GstSDPResult;
    pub fn gst_sdp_media_set_media_from_caps(
        caps: *const gst::GstCaps,
        media: *mut GstSDPMedia,
    ) -> GstSDPResult;

    //=========================================================================
    // GstSDPMessage
    //=========================================================================
    pub fn gst_sdp_message_get_type() -> GType;
    pub fn gst_sdp_message_add_attribute(
        msg: *mut GstSDPMessage,
        key: *const c_char,
        value: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_add_bandwidth(
        msg: *mut GstSDPMessage,
        bwtype: *const c_char,
        bandwidth: c_uint,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_add_email(msg: *mut GstSDPMessage, email: *const c_char)
        -> GstSDPResult;
    pub fn gst_sdp_message_add_media(
        msg: *mut GstSDPMessage,
        media: *mut GstSDPMedia,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_add_phone(msg: *mut GstSDPMessage, phone: *const c_char)
        -> GstSDPResult;
    pub fn gst_sdp_message_add_time(
        msg: *mut GstSDPMessage,
        start: *const c_char,
        stop: *const c_char,
        repeat: *mut *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_add_zone(
        msg: *mut GstSDPMessage,
        adj_time: *const c_char,
        typed_time: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_as_text(msg: *const GstSDPMessage) -> *mut c_char;
    pub fn gst_sdp_message_attributes_len(msg: *const GstSDPMessage) -> c_uint;
    pub fn gst_sdp_message_attributes_to_caps(
        msg: *const GstSDPMessage,
        caps: *mut gst::GstCaps,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_bandwidths_len(msg: *const GstSDPMessage) -> c_uint;
    pub fn gst_sdp_message_copy(
        msg: *const GstSDPMessage,
        copy: *mut *mut GstSDPMessage,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_dump(msg: *const GstSDPMessage) -> GstSDPResult;
    pub fn gst_sdp_message_emails_len(msg: *const GstSDPMessage) -> c_uint;
    pub fn gst_sdp_message_free(msg: *mut GstSDPMessage) -> GstSDPResult;
    pub fn gst_sdp_message_get_attribute(
        msg: *const GstSDPMessage,
        idx: c_uint,
    ) -> *const GstSDPAttribute;
    pub fn gst_sdp_message_get_attribute_val(
        msg: *const GstSDPMessage,
        key: *const c_char,
    ) -> *const c_char;
    pub fn gst_sdp_message_get_attribute_val_n(
        msg: *const GstSDPMessage,
        key: *const c_char,
        nth: c_uint,
    ) -> *const c_char;
    pub fn gst_sdp_message_get_bandwidth(
        msg: *const GstSDPMessage,
        idx: c_uint,
    ) -> *const GstSDPBandwidth;
    pub fn gst_sdp_message_get_connection(msg: *const GstSDPMessage) -> *const GstSDPConnection;
    pub fn gst_sdp_message_get_email(msg: *const GstSDPMessage, idx: c_uint) -> *const c_char;
    pub fn gst_sdp_message_get_information(msg: *const GstSDPMessage) -> *const c_char;
    pub fn gst_sdp_message_get_key(msg: *const GstSDPMessage) -> *const GstSDPKey;
    pub fn gst_sdp_message_get_media(msg: *const GstSDPMessage, idx: c_uint) -> *const GstSDPMedia;
    pub fn gst_sdp_message_get_origin(msg: *const GstSDPMessage) -> *const GstSDPOrigin;
    pub fn gst_sdp_message_get_phone(msg: *const GstSDPMessage, idx: c_uint) -> *const c_char;
    pub fn gst_sdp_message_get_session_name(msg: *const GstSDPMessage) -> *const c_char;
    pub fn gst_sdp_message_get_time(msg: *const GstSDPMessage, idx: c_uint) -> *const GstSDPTime;
    pub fn gst_sdp_message_get_uri(msg: *const GstSDPMessage) -> *const c_char;
    pub fn gst_sdp_message_get_version(msg: *const GstSDPMessage) -> *const c_char;
    pub fn gst_sdp_message_get_zone(msg: *const GstSDPMessage, idx: c_uint) -> *const GstSDPZone;
    pub fn gst_sdp_message_insert_attribute(
        msg: *mut GstSDPMessage,
        idx: c_int,
        attr: *mut GstSDPAttribute,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_insert_bandwidth(
        msg: *mut GstSDPMessage,
        idx: c_int,
        bw: *mut GstSDPBandwidth,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_insert_email(
        msg: *mut GstSDPMessage,
        idx: c_int,
        email: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_insert_phone(
        msg: *mut GstSDPMessage,
        idx: c_int,
        phone: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_insert_time(
        msg: *mut GstSDPMessage,
        idx: c_int,
        t: *mut GstSDPTime,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_insert_zone(
        msg: *mut GstSDPMessage,
        idx: c_int,
        zone: *mut GstSDPZone,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_medias_len(msg: *const GstSDPMessage) -> c_uint;
    pub fn gst_sdp_message_parse_keymgmt(
        msg: *const GstSDPMessage,
        mikey: *mut *mut GstMIKEYMessage,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_phones_len(msg: *const GstSDPMessage) -> c_uint;
    pub fn gst_sdp_message_remove_attribute(msg: *mut GstSDPMessage, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_message_remove_bandwidth(msg: *mut GstSDPMessage, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_message_remove_email(msg: *mut GstSDPMessage, idx: c_uint) -> GstSDPResult;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_sdp_message_remove_media(msg: *mut GstSDPMessage, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_message_remove_phone(msg: *mut GstSDPMessage, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_message_remove_time(msg: *mut GstSDPMessage, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_message_remove_zone(msg: *mut GstSDPMessage, idx: c_uint) -> GstSDPResult;
    pub fn gst_sdp_message_replace_attribute(
        msg: *mut GstSDPMessage,
        idx: c_uint,
        attr: *mut GstSDPAttribute,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_replace_bandwidth(
        msg: *mut GstSDPMessage,
        idx: c_uint,
        bw: *mut GstSDPBandwidth,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_replace_email(
        msg: *mut GstSDPMessage,
        idx: c_uint,
        email: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_replace_phone(
        msg: *mut GstSDPMessage,
        idx: c_uint,
        phone: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_replace_time(
        msg: *mut GstSDPMessage,
        idx: c_uint,
        t: *mut GstSDPTime,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_replace_zone(
        msg: *mut GstSDPMessage,
        idx: c_uint,
        zone: *mut GstSDPZone,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_set_connection(
        msg: *mut GstSDPMessage,
        nettype: *const c_char,
        addrtype: *const c_char,
        address: *const c_char,
        ttl: c_uint,
        addr_number: c_uint,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_set_information(
        msg: *mut GstSDPMessage,
        information: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_set_key(
        msg: *mut GstSDPMessage,
        type_: *const c_char,
        data: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_set_origin(
        msg: *mut GstSDPMessage,
        username: *const c_char,
        sess_id: *const c_char,
        sess_version: *const c_char,
        nettype: *const c_char,
        addrtype: *const c_char,
        addr: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_set_session_name(
        msg: *mut GstSDPMessage,
        session_name: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_set_uri(msg: *mut GstSDPMessage, uri: *const c_char) -> GstSDPResult;
    pub fn gst_sdp_message_set_version(
        msg: *mut GstSDPMessage,
        version: *const c_char,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_times_len(msg: *const GstSDPMessage) -> c_uint;
    pub fn gst_sdp_message_uninit(msg: *mut GstSDPMessage) -> GstSDPResult;
    pub fn gst_sdp_message_zones_len(msg: *const GstSDPMessage) -> c_uint;
    pub fn gst_sdp_message_as_uri(scheme: *const c_char, msg: *const GstSDPMessage) -> *mut c_char;
    pub fn gst_sdp_message_init(msg: *mut GstSDPMessage) -> GstSDPResult;
    pub fn gst_sdp_message_new(msg: *mut *mut GstSDPMessage) -> GstSDPResult;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_sdp_message_new_from_text(
        text: *const c_char,
        msg: *mut *mut GstSDPMessage,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_parse_buffer(
        data: *const u8,
        size: c_uint,
        msg: *mut GstSDPMessage,
    ) -> GstSDPResult;
    pub fn gst_sdp_message_parse_uri(uri: *const c_char, msg: *mut GstSDPMessage) -> GstSDPResult;

    //=========================================================================
    // GstSDPTime
    //=========================================================================
    pub fn gst_sdp_time_clear(t: *mut GstSDPTime) -> GstSDPResult;
    pub fn gst_sdp_time_set(
        t: *mut GstSDPTime,
        start: *const c_char,
        stop: *const c_char,
        repeat: *mut *const c_char,
    ) -> GstSDPResult;

    //=========================================================================
    // GstSDPZone
    //=========================================================================
    pub fn gst_sdp_zone_clear(zone: *mut GstSDPZone) -> GstSDPResult;
    pub fn gst_sdp_zone_set(
        zone: *mut GstSDPZone,
        adj_time: *const c_char,
        typed_time: *const c_char,
    ) -> GstSDPResult;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_sdp_address_is_multicast(
        nettype: *const c_char,
        addrtype: *const c_char,
        addr: *const c_char,
    ) -> gboolean;
    pub fn gst_sdp_make_keymgmt(uri: *const c_char, base64: *const c_char) -> *mut c_char;

}
