// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{prelude::*, translate::*};

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GChecksumType")]
pub enum ChecksumType {
    #[doc(alias = "G_CHECKSUM_MD5")]
    Md5,
    #[doc(alias = "G_CHECKSUM_SHA1")]
    Sha1,
    #[doc(alias = "G_CHECKSUM_SHA256")]
    Sha256,
    #[doc(alias = "G_CHECKSUM_SHA512")]
    Sha512,
    #[doc(alias = "G_CHECKSUM_SHA384")]
    Sha384,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ChecksumType {
    type GlibType = ffi::GChecksumType;

    #[inline]
    fn into_glib(self) -> ffi::GChecksumType {
        match self {
            Self::Md5 => ffi::G_CHECKSUM_MD5,
            Self::Sha1 => ffi::G_CHECKSUM_SHA1,
            Self::Sha256 => ffi::G_CHECKSUM_SHA256,
            Self::Sha512 => ffi::G_CHECKSUM_SHA512,
            Self::Sha384 => ffi::G_CHECKSUM_SHA384,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GChecksumType> for ChecksumType {
    #[inline]
    unsafe fn from_glib(value: ffi::GChecksumType) -> Self {
        match value {
            ffi::G_CHECKSUM_MD5 => Self::Md5,
            ffi::G_CHECKSUM_SHA1 => Self::Sha1,
            ffi::G_CHECKSUM_SHA256 => Self::Sha256,
            ffi::G_CHECKSUM_SHA512 => Self::Sha512,
            ffi::G_CHECKSUM_SHA384 => Self::Sha384,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GConvertError")]
pub enum ConvertError {
    #[doc(alias = "G_CONVERT_ERROR_NO_CONVERSION")]
    NoConversion,
    #[doc(alias = "G_CONVERT_ERROR_ILLEGAL_SEQUENCE")]
    IllegalSequence,
    #[doc(alias = "G_CONVERT_ERROR_FAILED")]
    Failed,
    #[doc(alias = "G_CONVERT_ERROR_PARTIAL_INPUT")]
    PartialInput,
    #[doc(alias = "G_CONVERT_ERROR_BAD_URI")]
    BadUri,
    #[doc(alias = "G_CONVERT_ERROR_NOT_ABSOLUTE_PATH")]
    NotAbsolutePath,
    #[doc(alias = "G_CONVERT_ERROR_NO_MEMORY")]
    NoMemory,
    #[doc(alias = "G_CONVERT_ERROR_EMBEDDED_NUL")]
    EmbeddedNul,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ConvertError {
    type GlibType = ffi::GConvertError;

    #[inline]
    fn into_glib(self) -> ffi::GConvertError {
        match self {
            Self::NoConversion => ffi::G_CONVERT_ERROR_NO_CONVERSION,
            Self::IllegalSequence => ffi::G_CONVERT_ERROR_ILLEGAL_SEQUENCE,
            Self::Failed => ffi::G_CONVERT_ERROR_FAILED,
            Self::PartialInput => ffi::G_CONVERT_ERROR_PARTIAL_INPUT,
            Self::BadUri => ffi::G_CONVERT_ERROR_BAD_URI,
            Self::NotAbsolutePath => ffi::G_CONVERT_ERROR_NOT_ABSOLUTE_PATH,
            Self::NoMemory => ffi::G_CONVERT_ERROR_NO_MEMORY,
            Self::EmbeddedNul => ffi::G_CONVERT_ERROR_EMBEDDED_NUL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GConvertError> for ConvertError {
    #[inline]
    unsafe fn from_glib(value: ffi::GConvertError) -> Self {
        match value {
            ffi::G_CONVERT_ERROR_NO_CONVERSION => Self::NoConversion,
            ffi::G_CONVERT_ERROR_ILLEGAL_SEQUENCE => Self::IllegalSequence,
            ffi::G_CONVERT_ERROR_FAILED => Self::Failed,
            ffi::G_CONVERT_ERROR_PARTIAL_INPUT => Self::PartialInput,
            ffi::G_CONVERT_ERROR_BAD_URI => Self::BadUri,
            ffi::G_CONVERT_ERROR_NOT_ABSOLUTE_PATH => Self::NotAbsolutePath,
            ffi::G_CONVERT_ERROR_NO_MEMORY => Self::NoMemory,
            ffi::G_CONVERT_ERROR_EMBEDDED_NUL => Self::EmbeddedNul,
            value => Self::__Unknown(value),
        }
    }
}

impl crate::error::ErrorDomain for ConvertError {
    #[inline]
    fn domain() -> crate::Quark {
        unsafe { from_glib(ffi::g_convert_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            Self::__Unknown(_) => Some(Self::Failed),
            value => Some(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDateMonth")]
pub enum DateMonth {
    #[doc(alias = "G_DATE_BAD_MONTH")]
    BadMonth,
    #[doc(alias = "G_DATE_JANUARY")]
    January,
    #[doc(alias = "G_DATE_FEBRUARY")]
    February,
    #[doc(alias = "G_DATE_MARCH")]
    March,
    #[doc(alias = "G_DATE_APRIL")]
    April,
    #[doc(alias = "G_DATE_MAY")]
    May,
    #[doc(alias = "G_DATE_JUNE")]
    June,
    #[doc(alias = "G_DATE_JULY")]
    July,
    #[doc(alias = "G_DATE_AUGUST")]
    August,
    #[doc(alias = "G_DATE_SEPTEMBER")]
    September,
    #[doc(alias = "G_DATE_OCTOBER")]
    October,
    #[doc(alias = "G_DATE_NOVEMBER")]
    November,
    #[doc(alias = "G_DATE_DECEMBER")]
    December,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DateMonth {
    type GlibType = ffi::GDateMonth;

    fn into_glib(self) -> ffi::GDateMonth {
        match self {
            Self::BadMonth => ffi::G_DATE_BAD_MONTH,
            Self::January => ffi::G_DATE_JANUARY,
            Self::February => ffi::G_DATE_FEBRUARY,
            Self::March => ffi::G_DATE_MARCH,
            Self::April => ffi::G_DATE_APRIL,
            Self::May => ffi::G_DATE_MAY,
            Self::June => ffi::G_DATE_JUNE,
            Self::July => ffi::G_DATE_JULY,
            Self::August => ffi::G_DATE_AUGUST,
            Self::September => ffi::G_DATE_SEPTEMBER,
            Self::October => ffi::G_DATE_OCTOBER,
            Self::November => ffi::G_DATE_NOVEMBER,
            Self::December => ffi::G_DATE_DECEMBER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDateMonth> for DateMonth {
    unsafe fn from_glib(value: ffi::GDateMonth) -> Self {
        match value {
            ffi::G_DATE_BAD_MONTH => Self::BadMonth,
            ffi::G_DATE_JANUARY => Self::January,
            ffi::G_DATE_FEBRUARY => Self::February,
            ffi::G_DATE_MARCH => Self::March,
            ffi::G_DATE_APRIL => Self::April,
            ffi::G_DATE_MAY => Self::May,
            ffi::G_DATE_JUNE => Self::June,
            ffi::G_DATE_JULY => Self::July,
            ffi::G_DATE_AUGUST => Self::August,
            ffi::G_DATE_SEPTEMBER => Self::September,
            ffi::G_DATE_OCTOBER => Self::October,
            ffi::G_DATE_NOVEMBER => Self::November,
            ffi::G_DATE_DECEMBER => Self::December,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDateWeekday")]
pub enum DateWeekday {
    #[doc(alias = "G_DATE_BAD_WEEKDAY")]
    BadWeekday,
    #[doc(alias = "G_DATE_MONDAY")]
    Monday,
    #[doc(alias = "G_DATE_TUESDAY")]
    Tuesday,
    #[doc(alias = "G_DATE_WEDNESDAY")]
    Wednesday,
    #[doc(alias = "G_DATE_THURSDAY")]
    Thursday,
    #[doc(alias = "G_DATE_FRIDAY")]
    Friday,
    #[doc(alias = "G_DATE_SATURDAY")]
    Saturday,
    #[doc(alias = "G_DATE_SUNDAY")]
    Sunday,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DateWeekday {
    type GlibType = ffi::GDateWeekday;

    #[inline]
    fn into_glib(self) -> ffi::GDateWeekday {
        match self {
            Self::BadWeekday => ffi::G_DATE_BAD_WEEKDAY,
            Self::Monday => ffi::G_DATE_MONDAY,
            Self::Tuesday => ffi::G_DATE_TUESDAY,
            Self::Wednesday => ffi::G_DATE_WEDNESDAY,
            Self::Thursday => ffi::G_DATE_THURSDAY,
            Self::Friday => ffi::G_DATE_FRIDAY,
            Self::Saturday => ffi::G_DATE_SATURDAY,
            Self::Sunday => ffi::G_DATE_SUNDAY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDateWeekday> for DateWeekday {
    #[inline]
    unsafe fn from_glib(value: ffi::GDateWeekday) -> Self {
        match value {
            ffi::G_DATE_BAD_WEEKDAY => Self::BadWeekday,
            ffi::G_DATE_MONDAY => Self::Monday,
            ffi::G_DATE_TUESDAY => Self::Tuesday,
            ffi::G_DATE_WEDNESDAY => Self::Wednesday,
            ffi::G_DATE_THURSDAY => Self::Thursday,
            ffi::G_DATE_FRIDAY => Self::Friday,
            ffi::G_DATE_SATURDAY => Self::Saturday,
            ffi::G_DATE_SUNDAY => Self::Sunday,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GFileError")]
pub enum FileError {
    #[doc(alias = "G_FILE_ERROR_EXIST")]
    Exist,
    #[doc(alias = "G_FILE_ERROR_ISDIR")]
    Isdir,
    #[doc(alias = "G_FILE_ERROR_ACCES")]
    Acces,
    #[doc(alias = "G_FILE_ERROR_NAMETOOLONG")]
    Nametoolong,
    #[doc(alias = "G_FILE_ERROR_NOENT")]
    Noent,
    #[doc(alias = "G_FILE_ERROR_NOTDIR")]
    Notdir,
    #[doc(alias = "G_FILE_ERROR_NXIO")]
    Nxio,
    #[doc(alias = "G_FILE_ERROR_NODEV")]
    Nodev,
    #[doc(alias = "G_FILE_ERROR_ROFS")]
    Rofs,
    #[doc(alias = "G_FILE_ERROR_TXTBSY")]
    Txtbsy,
    #[doc(alias = "G_FILE_ERROR_FAULT")]
    Fault,
    #[doc(alias = "G_FILE_ERROR_LOOP")]
    Loop,
    #[doc(alias = "G_FILE_ERROR_NOSPC")]
    Nospc,
    #[doc(alias = "G_FILE_ERROR_NOMEM")]
    Nomem,
    #[doc(alias = "G_FILE_ERROR_MFILE")]
    Mfile,
    #[doc(alias = "G_FILE_ERROR_NFILE")]
    Nfile,
    #[doc(alias = "G_FILE_ERROR_BADF")]
    Badf,
    #[doc(alias = "G_FILE_ERROR_INVAL")]
    Inval,
    #[doc(alias = "G_FILE_ERROR_PIPE")]
    Pipe,
    #[doc(alias = "G_FILE_ERROR_AGAIN")]
    Again,
    #[doc(alias = "G_FILE_ERROR_INTR")]
    Intr,
    #[doc(alias = "G_FILE_ERROR_IO")]
    Io,
    #[doc(alias = "G_FILE_ERROR_PERM")]
    Perm,
    #[doc(alias = "G_FILE_ERROR_NOSYS")]
    Nosys,
    #[doc(alias = "G_FILE_ERROR_FAILED")]
    Failed,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for FileError {
    type GlibType = ffi::GFileError;

    fn into_glib(self) -> ffi::GFileError {
        match self {
            Self::Exist => ffi::G_FILE_ERROR_EXIST,
            Self::Isdir => ffi::G_FILE_ERROR_ISDIR,
            Self::Acces => ffi::G_FILE_ERROR_ACCES,
            Self::Nametoolong => ffi::G_FILE_ERROR_NAMETOOLONG,
            Self::Noent => ffi::G_FILE_ERROR_NOENT,
            Self::Notdir => ffi::G_FILE_ERROR_NOTDIR,
            Self::Nxio => ffi::G_FILE_ERROR_NXIO,
            Self::Nodev => ffi::G_FILE_ERROR_NODEV,
            Self::Rofs => ffi::G_FILE_ERROR_ROFS,
            Self::Txtbsy => ffi::G_FILE_ERROR_TXTBSY,
            Self::Fault => ffi::G_FILE_ERROR_FAULT,
            Self::Loop => ffi::G_FILE_ERROR_LOOP,
            Self::Nospc => ffi::G_FILE_ERROR_NOSPC,
            Self::Nomem => ffi::G_FILE_ERROR_NOMEM,
            Self::Mfile => ffi::G_FILE_ERROR_MFILE,
            Self::Nfile => ffi::G_FILE_ERROR_NFILE,
            Self::Badf => ffi::G_FILE_ERROR_BADF,
            Self::Inval => ffi::G_FILE_ERROR_INVAL,
            Self::Pipe => ffi::G_FILE_ERROR_PIPE,
            Self::Again => ffi::G_FILE_ERROR_AGAIN,
            Self::Intr => ffi::G_FILE_ERROR_INTR,
            Self::Io => ffi::G_FILE_ERROR_IO,
            Self::Perm => ffi::G_FILE_ERROR_PERM,
            Self::Nosys => ffi::G_FILE_ERROR_NOSYS,
            Self::Failed => ffi::G_FILE_ERROR_FAILED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GFileError> for FileError {
    unsafe fn from_glib(value: ffi::GFileError) -> Self {
        match value {
            ffi::G_FILE_ERROR_EXIST => Self::Exist,
            ffi::G_FILE_ERROR_ISDIR => Self::Isdir,
            ffi::G_FILE_ERROR_ACCES => Self::Acces,
            ffi::G_FILE_ERROR_NAMETOOLONG => Self::Nametoolong,
            ffi::G_FILE_ERROR_NOENT => Self::Noent,
            ffi::G_FILE_ERROR_NOTDIR => Self::Notdir,
            ffi::G_FILE_ERROR_NXIO => Self::Nxio,
            ffi::G_FILE_ERROR_NODEV => Self::Nodev,
            ffi::G_FILE_ERROR_ROFS => Self::Rofs,
            ffi::G_FILE_ERROR_TXTBSY => Self::Txtbsy,
            ffi::G_FILE_ERROR_FAULT => Self::Fault,
            ffi::G_FILE_ERROR_LOOP => Self::Loop,
            ffi::G_FILE_ERROR_NOSPC => Self::Nospc,
            ffi::G_FILE_ERROR_NOMEM => Self::Nomem,
            ffi::G_FILE_ERROR_MFILE => Self::Mfile,
            ffi::G_FILE_ERROR_NFILE => Self::Nfile,
            ffi::G_FILE_ERROR_BADF => Self::Badf,
            ffi::G_FILE_ERROR_INVAL => Self::Inval,
            ffi::G_FILE_ERROR_PIPE => Self::Pipe,
            ffi::G_FILE_ERROR_AGAIN => Self::Again,
            ffi::G_FILE_ERROR_INTR => Self::Intr,
            ffi::G_FILE_ERROR_IO => Self::Io,
            ffi::G_FILE_ERROR_PERM => Self::Perm,
            ffi::G_FILE_ERROR_NOSYS => Self::Nosys,
            ffi::G_FILE_ERROR_FAILED => Self::Failed,
            value => Self::__Unknown(value),
        }
    }
}

impl crate::error::ErrorDomain for FileError {
    #[inline]
    fn domain() -> crate::Quark {
        unsafe { from_glib(ffi::g_file_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            Self::__Unknown(_) => Some(Self::Failed),
            value => Some(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GKeyFileError")]
pub enum KeyFileError {
    #[doc(alias = "G_KEY_FILE_ERROR_UNKNOWN_ENCODING")]
    UnknownEncoding,
    #[doc(alias = "G_KEY_FILE_ERROR_PARSE")]
    Parse,
    #[doc(alias = "G_KEY_FILE_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "G_KEY_FILE_ERROR_KEY_NOT_FOUND")]
    KeyNotFound,
    #[doc(alias = "G_KEY_FILE_ERROR_GROUP_NOT_FOUND")]
    GroupNotFound,
    #[doc(alias = "G_KEY_FILE_ERROR_INVALID_VALUE")]
    InvalidValue,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for KeyFileError {
    type GlibType = ffi::GKeyFileError;

    #[inline]
    fn into_glib(self) -> ffi::GKeyFileError {
        match self {
            Self::UnknownEncoding => ffi::G_KEY_FILE_ERROR_UNKNOWN_ENCODING,
            Self::Parse => ffi::G_KEY_FILE_ERROR_PARSE,
            Self::NotFound => ffi::G_KEY_FILE_ERROR_NOT_FOUND,
            Self::KeyNotFound => ffi::G_KEY_FILE_ERROR_KEY_NOT_FOUND,
            Self::GroupNotFound => ffi::G_KEY_FILE_ERROR_GROUP_NOT_FOUND,
            Self::InvalidValue => ffi::G_KEY_FILE_ERROR_INVALID_VALUE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GKeyFileError> for KeyFileError {
    #[inline]
    unsafe fn from_glib(value: ffi::GKeyFileError) -> Self {
        match value {
            ffi::G_KEY_FILE_ERROR_UNKNOWN_ENCODING => Self::UnknownEncoding,
            ffi::G_KEY_FILE_ERROR_PARSE => Self::Parse,
            ffi::G_KEY_FILE_ERROR_NOT_FOUND => Self::NotFound,
            ffi::G_KEY_FILE_ERROR_KEY_NOT_FOUND => Self::KeyNotFound,
            ffi::G_KEY_FILE_ERROR_GROUP_NOT_FOUND => Self::GroupNotFound,
            ffi::G_KEY_FILE_ERROR_INVALID_VALUE => Self::InvalidValue,
            value => Self::__Unknown(value),
        }
    }
}

impl crate::error::ErrorDomain for KeyFileError {
    #[inline]
    fn domain() -> crate::Quark {
        unsafe { from_glib(ffi::g_key_file_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GLogWriterOutput")]
pub enum LogWriterOutput {
    #[doc(alias = "G_LOG_WRITER_HANDLED")]
    Handled,
    #[doc(alias = "G_LOG_WRITER_UNHANDLED")]
    Unhandled,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for LogWriterOutput {
    type GlibType = ffi::GLogWriterOutput;

    #[inline]
    fn into_glib(self) -> ffi::GLogWriterOutput {
        match self {
            Self::Handled => ffi::G_LOG_WRITER_HANDLED,
            Self::Unhandled => ffi::G_LOG_WRITER_UNHANDLED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GLogWriterOutput> for LogWriterOutput {
    #[inline]
    unsafe fn from_glib(value: ffi::GLogWriterOutput) -> Self {
        match value {
            ffi::G_LOG_WRITER_HANDLED => Self::Handled,
            ffi::G_LOG_WRITER_UNHANDLED => Self::Unhandled,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMarkupError")]
pub enum MarkupError {
    #[doc(alias = "G_MARKUP_ERROR_BAD_UTF8")]
    BadUtf8,
    #[doc(alias = "G_MARKUP_ERROR_EMPTY")]
    Empty,
    #[doc(alias = "G_MARKUP_ERROR_PARSE")]
    Parse,
    #[doc(alias = "G_MARKUP_ERROR_UNKNOWN_ELEMENT")]
    UnknownElement,
    #[doc(alias = "G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE")]
    UnknownAttribute,
    #[doc(alias = "G_MARKUP_ERROR_INVALID_CONTENT")]
    InvalidContent,
    #[doc(alias = "G_MARKUP_ERROR_MISSING_ATTRIBUTE")]
    MissingAttribute,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for MarkupError {
    type GlibType = ffi::GMarkupError;

    #[inline]
    fn into_glib(self) -> ffi::GMarkupError {
        match self {
            Self::BadUtf8 => ffi::G_MARKUP_ERROR_BAD_UTF8,
            Self::Empty => ffi::G_MARKUP_ERROR_EMPTY,
            Self::Parse => ffi::G_MARKUP_ERROR_PARSE,
            Self::UnknownElement => ffi::G_MARKUP_ERROR_UNKNOWN_ELEMENT,
            Self::UnknownAttribute => ffi::G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE,
            Self::InvalidContent => ffi::G_MARKUP_ERROR_INVALID_CONTENT,
            Self::MissingAttribute => ffi::G_MARKUP_ERROR_MISSING_ATTRIBUTE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMarkupError> for MarkupError {
    #[inline]
    unsafe fn from_glib(value: ffi::GMarkupError) -> Self {
        match value {
            ffi::G_MARKUP_ERROR_BAD_UTF8 => Self::BadUtf8,
            ffi::G_MARKUP_ERROR_EMPTY => Self::Empty,
            ffi::G_MARKUP_ERROR_PARSE => Self::Parse,
            ffi::G_MARKUP_ERROR_UNKNOWN_ELEMENT => Self::UnknownElement,
            ffi::G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE => Self::UnknownAttribute,
            ffi::G_MARKUP_ERROR_INVALID_CONTENT => Self::InvalidContent,
            ffi::G_MARKUP_ERROR_MISSING_ATTRIBUTE => Self::MissingAttribute,
            value => Self::__Unknown(value),
        }
    }
}

impl crate::error::ErrorDomain for MarkupError {
    #[inline]
    fn domain() -> crate::Quark {
        unsafe { from_glib(ffi::g_markup_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GNormalizeMode")]
pub enum NormalizeMode {
    #[doc(alias = "G_NORMALIZE_DEFAULT")]
    Default,
    #[doc(alias = "G_NORMALIZE_DEFAULT_COMPOSE")]
    DefaultCompose,
    #[doc(alias = "G_NORMALIZE_ALL")]
    All,
    #[doc(alias = "G_NORMALIZE_ALL_COMPOSE")]
    AllCompose,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for NormalizeMode {
    type GlibType = ffi::GNormalizeMode;

    #[inline]
    fn into_glib(self) -> ffi::GNormalizeMode {
        match self {
            Self::Default => ffi::G_NORMALIZE_DEFAULT,
            Self::DefaultCompose => ffi::G_NORMALIZE_DEFAULT_COMPOSE,
            Self::All => ffi::G_NORMALIZE_ALL,
            Self::AllCompose => ffi::G_NORMALIZE_ALL_COMPOSE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GNormalizeMode> for NormalizeMode {
    #[inline]
    unsafe fn from_glib(value: ffi::GNormalizeMode) -> Self {
        match value {
            ffi::G_NORMALIZE_DEFAULT => Self::Default,
            ffi::G_NORMALIZE_DEFAULT_COMPOSE => Self::DefaultCompose,
            ffi::G_NORMALIZE_ALL => Self::All,
            ffi::G_NORMALIZE_ALL_COMPOSE => Self::AllCompose,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NormalizeMode {
    #[inline]
    #[doc(alias = "g_normalize_mode_get_type")]
    fn static_type() -> crate::Type {
        unsafe { from_glib(ffi::g_normalize_mode_get_type()) }
    }
}

impl crate::HasParamSpec for NormalizeMode {
    type ParamSpec = crate::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> crate::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl crate::value::ValueType for NormalizeMode {
    type Type = Self;
}

unsafe impl<'a> crate::value::FromValue<'a> for NormalizeMode {
    type Checker = crate::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a crate::Value) -> Self {
        from_glib(crate::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NormalizeMode {
    #[inline]
    fn to_value(&self) -> crate::Value {
        let mut value = crate::Value::for_value_type::<Self>();
        unsafe {
            crate::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> crate::Type {
        Self::static_type()
    }
}

impl From<NormalizeMode> for crate::Value {
    #[inline]
    fn from(v: NormalizeMode) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GOptionArg")]
pub enum OptionArg {
    #[doc(alias = "G_OPTION_ARG_NONE")]
    None,
    #[doc(alias = "G_OPTION_ARG_STRING")]
    String,
    #[doc(alias = "G_OPTION_ARG_INT")]
    Int,
    #[doc(alias = "G_OPTION_ARG_CALLBACK")]
    Callback,
    #[doc(alias = "G_OPTION_ARG_FILENAME")]
    Filename,
    #[doc(alias = "G_OPTION_ARG_STRING_ARRAY")]
    StringArray,
    #[doc(alias = "G_OPTION_ARG_FILENAME_ARRAY")]
    FilenameArray,
    #[doc(alias = "G_OPTION_ARG_DOUBLE")]
    Double,
    #[doc(alias = "G_OPTION_ARG_INT64")]
    Int64,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for OptionArg {
    type GlibType = ffi::GOptionArg;

    #[inline]
    fn into_glib(self) -> ffi::GOptionArg {
        match self {
            Self::None => ffi::G_OPTION_ARG_NONE,
            Self::String => ffi::G_OPTION_ARG_STRING,
            Self::Int => ffi::G_OPTION_ARG_INT,
            Self::Callback => ffi::G_OPTION_ARG_CALLBACK,
            Self::Filename => ffi::G_OPTION_ARG_FILENAME,
            Self::StringArray => ffi::G_OPTION_ARG_STRING_ARRAY,
            Self::FilenameArray => ffi::G_OPTION_ARG_FILENAME_ARRAY,
            Self::Double => ffi::G_OPTION_ARG_DOUBLE,
            Self::Int64 => ffi::G_OPTION_ARG_INT64,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GOptionArg> for OptionArg {
    #[inline]
    unsafe fn from_glib(value: ffi::GOptionArg) -> Self {
        match value {
            ffi::G_OPTION_ARG_NONE => Self::None,
            ffi::G_OPTION_ARG_STRING => Self::String,
            ffi::G_OPTION_ARG_INT => Self::Int,
            ffi::G_OPTION_ARG_CALLBACK => Self::Callback,
            ffi::G_OPTION_ARG_FILENAME => Self::Filename,
            ffi::G_OPTION_ARG_STRING_ARRAY => Self::StringArray,
            ffi::G_OPTION_ARG_FILENAME_ARRAY => Self::FilenameArray,
            ffi::G_OPTION_ARG_DOUBLE => Self::Double,
            ffi::G_OPTION_ARG_INT64 => Self::Int64,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GSeekType")]
pub enum SeekType {
    #[doc(alias = "G_SEEK_CUR")]
    Cur,
    #[doc(alias = "G_SEEK_SET")]
    Set,
    #[doc(alias = "G_SEEK_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SeekType {
    type GlibType = ffi::GSeekType;

    #[inline]
    fn into_glib(self) -> ffi::GSeekType {
        match self {
            Self::Cur => ffi::G_SEEK_CUR,
            Self::Set => ffi::G_SEEK_SET,
            Self::End => ffi::G_SEEK_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GSeekType> for SeekType {
    #[inline]
    unsafe fn from_glib(value: ffi::GSeekType) -> Self {
        match value {
            ffi::G_SEEK_CUR => Self::Cur,
            ffi::G_SEEK_SET => Self::Set,
            ffi::G_SEEK_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTimeType")]
pub enum TimeType {
    #[doc(alias = "G_TIME_TYPE_STANDARD")]
    Standard,
    #[doc(alias = "G_TIME_TYPE_DAYLIGHT")]
    Daylight,
    #[doc(alias = "G_TIME_TYPE_UNIVERSAL")]
    Universal,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TimeType {
    type GlibType = ffi::GTimeType;

    #[inline]
    fn into_glib(self) -> ffi::GTimeType {
        match self {
            Self::Standard => ffi::G_TIME_TYPE_STANDARD,
            Self::Daylight => ffi::G_TIME_TYPE_DAYLIGHT,
            Self::Universal => ffi::G_TIME_TYPE_UNIVERSAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GTimeType> for TimeType {
    #[inline]
    unsafe fn from_glib(value: ffi::GTimeType) -> Self {
        match value {
            ffi::G_TIME_TYPE_STANDARD => Self::Standard,
            ffi::G_TIME_TYPE_DAYLIGHT => Self::Daylight,
            ffi::G_TIME_TYPE_UNIVERSAL => Self::Universal,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GUnicodeBreakType")]
pub enum UnicodeBreakType {
    #[doc(alias = "G_UNICODE_BREAK_MANDATORY")]
    Mandatory,
    #[doc(alias = "G_UNICODE_BREAK_CARRIAGE_RETURN")]
    CarriageReturn,
    #[doc(alias = "G_UNICODE_BREAK_LINE_FEED")]
    LineFeed,
    #[doc(alias = "G_UNICODE_BREAK_COMBINING_MARK")]
    CombiningMark,
    #[doc(alias = "G_UNICODE_BREAK_SURROGATE")]
    Surrogate,
    #[doc(alias = "G_UNICODE_BREAK_ZERO_WIDTH_SPACE")]
    ZeroWidthSpace,
    #[doc(alias = "G_UNICODE_BREAK_INSEPARABLE")]
    Inseparable,
    #[doc(alias = "G_UNICODE_BREAK_NON_BREAKING_GLUE")]
    NonBreakingGlue,
    #[doc(alias = "G_UNICODE_BREAK_CONTINGENT")]
    Contingent,
    #[doc(alias = "G_UNICODE_BREAK_SPACE")]
    Space,
    #[doc(alias = "G_UNICODE_BREAK_AFTER")]
    After,
    #[doc(alias = "G_UNICODE_BREAK_BEFORE")]
    Before,
    #[doc(alias = "G_UNICODE_BREAK_BEFORE_AND_AFTER")]
    BeforeAndAfter,
    #[doc(alias = "G_UNICODE_BREAK_HYPHEN")]
    Hyphen,
    #[doc(alias = "G_UNICODE_BREAK_NON_STARTER")]
    NonStarter,
    #[doc(alias = "G_UNICODE_BREAK_OPEN_PUNCTUATION")]
    OpenPunctuation,
    #[doc(alias = "G_UNICODE_BREAK_CLOSE_PUNCTUATION")]
    ClosePunctuation,
    #[doc(alias = "G_UNICODE_BREAK_QUOTATION")]
    Quotation,
    #[doc(alias = "G_UNICODE_BREAK_EXCLAMATION")]
    Exclamation,
    #[doc(alias = "G_UNICODE_BREAK_IDEOGRAPHIC")]
    Ideographic,
    #[doc(alias = "G_UNICODE_BREAK_NUMERIC")]
    Numeric,
    #[doc(alias = "G_UNICODE_BREAK_INFIX_SEPARATOR")]
    InfixSeparator,
    #[doc(alias = "G_UNICODE_BREAK_SYMBOL")]
    Symbol,
    #[doc(alias = "G_UNICODE_BREAK_ALPHABETIC")]
    Alphabetic,
    #[doc(alias = "G_UNICODE_BREAK_PREFIX")]
    Prefix,
    #[doc(alias = "G_UNICODE_BREAK_POSTFIX")]
    Postfix,
    #[doc(alias = "G_UNICODE_BREAK_COMPLEX_CONTEXT")]
    ComplexContext,
    #[doc(alias = "G_UNICODE_BREAK_AMBIGUOUS")]
    Ambiguous,
    #[doc(alias = "G_UNICODE_BREAK_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_UNICODE_BREAK_NEXT_LINE")]
    NextLine,
    #[doc(alias = "G_UNICODE_BREAK_WORD_JOINER")]
    WordJoiner,
    #[doc(alias = "G_UNICODE_BREAK_HANGUL_L_JAMO")]
    HangulLJamo,
    #[doc(alias = "G_UNICODE_BREAK_HANGUL_V_JAMO")]
    HangulVJamo,
    #[doc(alias = "G_UNICODE_BREAK_HANGUL_T_JAMO")]
    HangulTJamo,
    #[doc(alias = "G_UNICODE_BREAK_HANGUL_LV_SYLLABLE")]
    HangulLvSyllable,
    #[doc(alias = "G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE")]
    HangulLvtSyllable,
    #[doc(alias = "G_UNICODE_BREAK_CLOSE_PARENTHESIS")]
    CloseParenthesis,
    #[doc(alias = "G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER")]
    ConditionalJapaneseStarter,
    #[doc(alias = "G_UNICODE_BREAK_HEBREW_LETTER")]
    HebrewLetter,
    #[doc(alias = "G_UNICODE_BREAK_REGIONAL_INDICATOR")]
    RegionalIndicator,
    #[doc(alias = "G_UNICODE_BREAK_EMOJI_BASE")]
    EmojiBase,
    #[doc(alias = "G_UNICODE_BREAK_EMOJI_MODIFIER")]
    EmojiModifier,
    #[doc(alias = "G_UNICODE_BREAK_ZERO_WIDTH_JOINER")]
    ZeroWidthJoiner,
    #[cfg(feature = "v2_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_80")))]
    #[doc(alias = "G_UNICODE_BREAK_AKSARA")]
    Aksara,
    #[cfg(feature = "v2_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_80")))]
    #[doc(alias = "G_UNICODE_BREAK_AKSARA_PRE_BASE")]
    AksaraPreBase,
    #[cfg(feature = "v2_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_80")))]
    #[doc(alias = "G_UNICODE_BREAK_AKSARA_START")]
    AksaraStart,
    #[cfg(feature = "v2_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_80")))]
    #[doc(alias = "G_UNICODE_BREAK_VIRAMA_FINAL")]
    ViramaFinal,
    #[cfg(feature = "v2_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_80")))]
    #[doc(alias = "G_UNICODE_BREAK_VIRAMA")]
    Virama,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for UnicodeBreakType {
    type GlibType = ffi::GUnicodeBreakType;

    fn into_glib(self) -> ffi::GUnicodeBreakType {
        match self {
            Self::Mandatory => ffi::G_UNICODE_BREAK_MANDATORY,
            Self::CarriageReturn => ffi::G_UNICODE_BREAK_CARRIAGE_RETURN,
            Self::LineFeed => ffi::G_UNICODE_BREAK_LINE_FEED,
            Self::CombiningMark => ffi::G_UNICODE_BREAK_COMBINING_MARK,
            Self::Surrogate => ffi::G_UNICODE_BREAK_SURROGATE,
            Self::ZeroWidthSpace => ffi::G_UNICODE_BREAK_ZERO_WIDTH_SPACE,
            Self::Inseparable => ffi::G_UNICODE_BREAK_INSEPARABLE,
            Self::NonBreakingGlue => ffi::G_UNICODE_BREAK_NON_BREAKING_GLUE,
            Self::Contingent => ffi::G_UNICODE_BREAK_CONTINGENT,
            Self::Space => ffi::G_UNICODE_BREAK_SPACE,
            Self::After => ffi::G_UNICODE_BREAK_AFTER,
            Self::Before => ffi::G_UNICODE_BREAK_BEFORE,
            Self::BeforeAndAfter => ffi::G_UNICODE_BREAK_BEFORE_AND_AFTER,
            Self::Hyphen => ffi::G_UNICODE_BREAK_HYPHEN,
            Self::NonStarter => ffi::G_UNICODE_BREAK_NON_STARTER,
            Self::OpenPunctuation => ffi::G_UNICODE_BREAK_OPEN_PUNCTUATION,
            Self::ClosePunctuation => ffi::G_UNICODE_BREAK_CLOSE_PUNCTUATION,
            Self::Quotation => ffi::G_UNICODE_BREAK_QUOTATION,
            Self::Exclamation => ffi::G_UNICODE_BREAK_EXCLAMATION,
            Self::Ideographic => ffi::G_UNICODE_BREAK_IDEOGRAPHIC,
            Self::Numeric => ffi::G_UNICODE_BREAK_NUMERIC,
            Self::InfixSeparator => ffi::G_UNICODE_BREAK_INFIX_SEPARATOR,
            Self::Symbol => ffi::G_UNICODE_BREAK_SYMBOL,
            Self::Alphabetic => ffi::G_UNICODE_BREAK_ALPHABETIC,
            Self::Prefix => ffi::G_UNICODE_BREAK_PREFIX,
            Self::Postfix => ffi::G_UNICODE_BREAK_POSTFIX,
            Self::ComplexContext => ffi::G_UNICODE_BREAK_COMPLEX_CONTEXT,
            Self::Ambiguous => ffi::G_UNICODE_BREAK_AMBIGUOUS,
            Self::Unknown => ffi::G_UNICODE_BREAK_UNKNOWN,
            Self::NextLine => ffi::G_UNICODE_BREAK_NEXT_LINE,
            Self::WordJoiner => ffi::G_UNICODE_BREAK_WORD_JOINER,
            Self::HangulLJamo => ffi::G_UNICODE_BREAK_HANGUL_L_JAMO,
            Self::HangulVJamo => ffi::G_UNICODE_BREAK_HANGUL_V_JAMO,
            Self::HangulTJamo => ffi::G_UNICODE_BREAK_HANGUL_T_JAMO,
            Self::HangulLvSyllable => ffi::G_UNICODE_BREAK_HANGUL_LV_SYLLABLE,
            Self::HangulLvtSyllable => ffi::G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE,
            Self::CloseParenthesis => ffi::G_UNICODE_BREAK_CLOSE_PARENTHESIS,
            Self::ConditionalJapaneseStarter => ffi::G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER,
            Self::HebrewLetter => ffi::G_UNICODE_BREAK_HEBREW_LETTER,
            Self::RegionalIndicator => ffi::G_UNICODE_BREAK_REGIONAL_INDICATOR,
            Self::EmojiBase => ffi::G_UNICODE_BREAK_EMOJI_BASE,
            Self::EmojiModifier => ffi::G_UNICODE_BREAK_EMOJI_MODIFIER,
            Self::ZeroWidthJoiner => ffi::G_UNICODE_BREAK_ZERO_WIDTH_JOINER,
            #[cfg(feature = "v2_80")]
            Self::Aksara => ffi::G_UNICODE_BREAK_AKSARA,
            #[cfg(feature = "v2_80")]
            Self::AksaraPreBase => ffi::G_UNICODE_BREAK_AKSARA_PRE_BASE,
            #[cfg(feature = "v2_80")]
            Self::AksaraStart => ffi::G_UNICODE_BREAK_AKSARA_START,
            #[cfg(feature = "v2_80")]
            Self::ViramaFinal => ffi::G_UNICODE_BREAK_VIRAMA_FINAL,
            #[cfg(feature = "v2_80")]
            Self::Virama => ffi::G_UNICODE_BREAK_VIRAMA,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GUnicodeBreakType> for UnicodeBreakType {
    unsafe fn from_glib(value: ffi::GUnicodeBreakType) -> Self {
        match value {
            ffi::G_UNICODE_BREAK_MANDATORY => Self::Mandatory,
            ffi::G_UNICODE_BREAK_CARRIAGE_RETURN => Self::CarriageReturn,
            ffi::G_UNICODE_BREAK_LINE_FEED => Self::LineFeed,
            ffi::G_UNICODE_BREAK_COMBINING_MARK => Self::CombiningMark,
            ffi::G_UNICODE_BREAK_SURROGATE => Self::Surrogate,
            ffi::G_UNICODE_BREAK_ZERO_WIDTH_SPACE => Self::ZeroWidthSpace,
            ffi::G_UNICODE_BREAK_INSEPARABLE => Self::Inseparable,
            ffi::G_UNICODE_BREAK_NON_BREAKING_GLUE => Self::NonBreakingGlue,
            ffi::G_UNICODE_BREAK_CONTINGENT => Self::Contingent,
            ffi::G_UNICODE_BREAK_SPACE => Self::Space,
            ffi::G_UNICODE_BREAK_AFTER => Self::After,
            ffi::G_UNICODE_BREAK_BEFORE => Self::Before,
            ffi::G_UNICODE_BREAK_BEFORE_AND_AFTER => Self::BeforeAndAfter,
            ffi::G_UNICODE_BREAK_HYPHEN => Self::Hyphen,
            ffi::G_UNICODE_BREAK_NON_STARTER => Self::NonStarter,
            ffi::G_UNICODE_BREAK_OPEN_PUNCTUATION => Self::OpenPunctuation,
            ffi::G_UNICODE_BREAK_CLOSE_PUNCTUATION => Self::ClosePunctuation,
            ffi::G_UNICODE_BREAK_QUOTATION => Self::Quotation,
            ffi::G_UNICODE_BREAK_EXCLAMATION => Self::Exclamation,
            ffi::G_UNICODE_BREAK_IDEOGRAPHIC => Self::Ideographic,
            ffi::G_UNICODE_BREAK_NUMERIC => Self::Numeric,
            ffi::G_UNICODE_BREAK_INFIX_SEPARATOR => Self::InfixSeparator,
            ffi::G_UNICODE_BREAK_SYMBOL => Self::Symbol,
            ffi::G_UNICODE_BREAK_ALPHABETIC => Self::Alphabetic,
            ffi::G_UNICODE_BREAK_PREFIX => Self::Prefix,
            ffi::G_UNICODE_BREAK_POSTFIX => Self::Postfix,
            ffi::G_UNICODE_BREAK_COMPLEX_CONTEXT => Self::ComplexContext,
            ffi::G_UNICODE_BREAK_AMBIGUOUS => Self::Ambiguous,
            ffi::G_UNICODE_BREAK_UNKNOWN => Self::Unknown,
            ffi::G_UNICODE_BREAK_NEXT_LINE => Self::NextLine,
            ffi::G_UNICODE_BREAK_WORD_JOINER => Self::WordJoiner,
            ffi::G_UNICODE_BREAK_HANGUL_L_JAMO => Self::HangulLJamo,
            ffi::G_UNICODE_BREAK_HANGUL_V_JAMO => Self::HangulVJamo,
            ffi::G_UNICODE_BREAK_HANGUL_T_JAMO => Self::HangulTJamo,
            ffi::G_UNICODE_BREAK_HANGUL_LV_SYLLABLE => Self::HangulLvSyllable,
            ffi::G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE => Self::HangulLvtSyllable,
            ffi::G_UNICODE_BREAK_CLOSE_PARENTHESIS => Self::CloseParenthesis,
            ffi::G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER => Self::ConditionalJapaneseStarter,
            ffi::G_UNICODE_BREAK_HEBREW_LETTER => Self::HebrewLetter,
            ffi::G_UNICODE_BREAK_REGIONAL_INDICATOR => Self::RegionalIndicator,
            ffi::G_UNICODE_BREAK_EMOJI_BASE => Self::EmojiBase,
            ffi::G_UNICODE_BREAK_EMOJI_MODIFIER => Self::EmojiModifier,
            ffi::G_UNICODE_BREAK_ZERO_WIDTH_JOINER => Self::ZeroWidthJoiner,
            #[cfg(feature = "v2_80")]
            ffi::G_UNICODE_BREAK_AKSARA => Self::Aksara,
            #[cfg(feature = "v2_80")]
            ffi::G_UNICODE_BREAK_AKSARA_PRE_BASE => Self::AksaraPreBase,
            #[cfg(feature = "v2_80")]
            ffi::G_UNICODE_BREAK_AKSARA_START => Self::AksaraStart,
            #[cfg(feature = "v2_80")]
            ffi::G_UNICODE_BREAK_VIRAMA_FINAL => Self::ViramaFinal,
            #[cfg(feature = "v2_80")]
            ffi::G_UNICODE_BREAK_VIRAMA => Self::Virama,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for UnicodeBreakType {
    #[inline]
    #[doc(alias = "g_unicode_break_type_get_type")]
    fn static_type() -> crate::Type {
        unsafe { from_glib(ffi::g_unicode_break_type_get_type()) }
    }
}

impl crate::HasParamSpec for UnicodeBreakType {
    type ParamSpec = crate::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> crate::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl crate::value::ValueType for UnicodeBreakType {
    type Type = Self;
}

unsafe impl<'a> crate::value::FromValue<'a> for UnicodeBreakType {
    type Checker = crate::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a crate::Value) -> Self {
        from_glib(crate::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UnicodeBreakType {
    #[inline]
    fn to_value(&self) -> crate::Value {
        let mut value = crate::Value::for_value_type::<Self>();
        unsafe {
            crate::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> crate::Type {
        Self::static_type()
    }
}

impl From<UnicodeBreakType> for crate::Value {
    #[inline]
    fn from(v: UnicodeBreakType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GUnicodeScript")]
pub enum UnicodeScript {
    #[doc(alias = "G_UNICODE_SCRIPT_INVALID_CODE")]
    InvalidCode,
    #[doc(alias = "G_UNICODE_SCRIPT_COMMON")]
    Common,
    #[doc(alias = "G_UNICODE_SCRIPT_INHERITED")]
    Inherited,
    #[doc(alias = "G_UNICODE_SCRIPT_ARABIC")]
    Arabic,
    #[doc(alias = "G_UNICODE_SCRIPT_ARMENIAN")]
    Armenian,
    #[doc(alias = "G_UNICODE_SCRIPT_BENGALI")]
    Bengali,
    #[doc(alias = "G_UNICODE_SCRIPT_BOPOMOFO")]
    Bopomofo,
    #[doc(alias = "G_UNICODE_SCRIPT_CHEROKEE")]
    Cherokee,
    #[doc(alias = "G_UNICODE_SCRIPT_COPTIC")]
    Coptic,
    #[doc(alias = "G_UNICODE_SCRIPT_CYRILLIC")]
    Cyrillic,
    #[doc(alias = "G_UNICODE_SCRIPT_DESERET")]
    Deseret,
    #[doc(alias = "G_UNICODE_SCRIPT_DEVANAGARI")]
    Devanagari,
    #[doc(alias = "G_UNICODE_SCRIPT_ETHIOPIC")]
    Ethiopic,
    #[doc(alias = "G_UNICODE_SCRIPT_GEORGIAN")]
    Georgian,
    #[doc(alias = "G_UNICODE_SCRIPT_GOTHIC")]
    Gothic,
    #[doc(alias = "G_UNICODE_SCRIPT_GREEK")]
    Greek,
    #[doc(alias = "G_UNICODE_SCRIPT_GUJARATI")]
    Gujarati,
    #[doc(alias = "G_UNICODE_SCRIPT_GURMUKHI")]
    Gurmukhi,
    #[doc(alias = "G_UNICODE_SCRIPT_HAN")]
    Han,
    #[doc(alias = "G_UNICODE_SCRIPT_HANGUL")]
    Hangul,
    #[doc(alias = "G_UNICODE_SCRIPT_HEBREW")]
    Hebrew,
    #[doc(alias = "G_UNICODE_SCRIPT_HIRAGANA")]
    Hiragana,
    #[doc(alias = "G_UNICODE_SCRIPT_KANNADA")]
    Kannada,
    #[doc(alias = "G_UNICODE_SCRIPT_KATAKANA")]
    Katakana,
    #[doc(alias = "G_UNICODE_SCRIPT_KHMER")]
    Khmer,
    #[doc(alias = "G_UNICODE_SCRIPT_LAO")]
    Lao,
    #[doc(alias = "G_UNICODE_SCRIPT_LATIN")]
    Latin,
    #[doc(alias = "G_UNICODE_SCRIPT_MALAYALAM")]
    Malayalam,
    #[doc(alias = "G_UNICODE_SCRIPT_MONGOLIAN")]
    Mongolian,
    #[doc(alias = "G_UNICODE_SCRIPT_MYANMAR")]
    Myanmar,
    #[doc(alias = "G_UNICODE_SCRIPT_OGHAM")]
    Ogham,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_ITALIC")]
    OldItalic,
    #[doc(alias = "G_UNICODE_SCRIPT_ORIYA")]
    Oriya,
    #[doc(alias = "G_UNICODE_SCRIPT_RUNIC")]
    Runic,
    #[doc(alias = "G_UNICODE_SCRIPT_SINHALA")]
    Sinhala,
    #[doc(alias = "G_UNICODE_SCRIPT_SYRIAC")]
    Syriac,
    #[doc(alias = "G_UNICODE_SCRIPT_TAMIL")]
    Tamil,
    #[doc(alias = "G_UNICODE_SCRIPT_TELUGU")]
    Telugu,
    #[doc(alias = "G_UNICODE_SCRIPT_THAANA")]
    Thaana,
    #[doc(alias = "G_UNICODE_SCRIPT_THAI")]
    Thai,
    #[doc(alias = "G_UNICODE_SCRIPT_TIBETAN")]
    Tibetan,
    #[doc(alias = "G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL")]
    CanadianAboriginal,
    #[doc(alias = "G_UNICODE_SCRIPT_YI")]
    Yi,
    #[doc(alias = "G_UNICODE_SCRIPT_TAGALOG")]
    Tagalog,
    #[doc(alias = "G_UNICODE_SCRIPT_HANUNOO")]
    Hanunoo,
    #[doc(alias = "G_UNICODE_SCRIPT_BUHID")]
    Buhid,
    #[doc(alias = "G_UNICODE_SCRIPT_TAGBANWA")]
    Tagbanwa,
    #[doc(alias = "G_UNICODE_SCRIPT_BRAILLE")]
    Braille,
    #[doc(alias = "G_UNICODE_SCRIPT_CYPRIOT")]
    Cypriot,
    #[doc(alias = "G_UNICODE_SCRIPT_LIMBU")]
    Limbu,
    #[doc(alias = "G_UNICODE_SCRIPT_OSMANYA")]
    Osmanya,
    #[doc(alias = "G_UNICODE_SCRIPT_SHAVIAN")]
    Shavian,
    #[doc(alias = "G_UNICODE_SCRIPT_LINEAR_B")]
    LinearB,
    #[doc(alias = "G_UNICODE_SCRIPT_TAI_LE")]
    TaiLe,
    #[doc(alias = "G_UNICODE_SCRIPT_UGARITIC")]
    Ugaritic,
    #[doc(alias = "G_UNICODE_SCRIPT_NEW_TAI_LUE")]
    NewTaiLue,
    #[doc(alias = "G_UNICODE_SCRIPT_BUGINESE")]
    Buginese,
    #[doc(alias = "G_UNICODE_SCRIPT_GLAGOLITIC")]
    Glagolitic,
    #[doc(alias = "G_UNICODE_SCRIPT_TIFINAGH")]
    Tifinagh,
    #[doc(alias = "G_UNICODE_SCRIPT_SYLOTI_NAGRI")]
    SylotiNagri,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_PERSIAN")]
    OldPersian,
    #[doc(alias = "G_UNICODE_SCRIPT_KHAROSHTHI")]
    Kharoshthi,
    #[doc(alias = "G_UNICODE_SCRIPT_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_UNICODE_SCRIPT_BALINESE")]
    Balinese,
    #[doc(alias = "G_UNICODE_SCRIPT_CUNEIFORM")]
    Cuneiform,
    #[doc(alias = "G_UNICODE_SCRIPT_PHOENICIAN")]
    Phoenician,
    #[doc(alias = "G_UNICODE_SCRIPT_PHAGS_PA")]
    PhagsPa,
    #[doc(alias = "G_UNICODE_SCRIPT_NKO")]
    Nko,
    #[doc(alias = "G_UNICODE_SCRIPT_KAYAH_LI")]
    KayahLi,
    #[doc(alias = "G_UNICODE_SCRIPT_LEPCHA")]
    Lepcha,
    #[doc(alias = "G_UNICODE_SCRIPT_REJANG")]
    Rejang,
    #[doc(alias = "G_UNICODE_SCRIPT_SUNDANESE")]
    Sundanese,
    #[doc(alias = "G_UNICODE_SCRIPT_SAURASHTRA")]
    Saurashtra,
    #[doc(alias = "G_UNICODE_SCRIPT_CHAM")]
    Cham,
    #[doc(alias = "G_UNICODE_SCRIPT_OL_CHIKI")]
    OlChiki,
    #[doc(alias = "G_UNICODE_SCRIPT_VAI")]
    Vai,
    #[doc(alias = "G_UNICODE_SCRIPT_CARIAN")]
    Carian,
    #[doc(alias = "G_UNICODE_SCRIPT_LYCIAN")]
    Lycian,
    #[doc(alias = "G_UNICODE_SCRIPT_LYDIAN")]
    Lydian,
    #[doc(alias = "G_UNICODE_SCRIPT_AVESTAN")]
    Avestan,
    #[doc(alias = "G_UNICODE_SCRIPT_BAMUM")]
    Bamum,
    #[doc(alias = "G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS")]
    EgyptianHieroglyphs,
    #[doc(alias = "G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC")]
    ImperialAramaic,
    #[doc(alias = "G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI")]
    InscriptionalPahlavi,
    #[doc(alias = "G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN")]
    InscriptionalParthian,
    #[doc(alias = "G_UNICODE_SCRIPT_JAVANESE")]
    Javanese,
    #[doc(alias = "G_UNICODE_SCRIPT_KAITHI")]
    Kaithi,
    #[doc(alias = "G_UNICODE_SCRIPT_LISU")]
    Lisu,
    #[doc(alias = "G_UNICODE_SCRIPT_MEETEI_MAYEK")]
    MeeteiMayek,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN")]
    OldSouthArabian,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_TURKIC")]
    OldTurkic,
    #[doc(alias = "G_UNICODE_SCRIPT_SAMARITAN")]
    Samaritan,
    #[doc(alias = "G_UNICODE_SCRIPT_TAI_THAM")]
    TaiTham,
    #[doc(alias = "G_UNICODE_SCRIPT_TAI_VIET")]
    TaiViet,
    #[doc(alias = "G_UNICODE_SCRIPT_BATAK")]
    Batak,
    #[doc(alias = "G_UNICODE_SCRIPT_BRAHMI")]
    Brahmi,
    #[doc(alias = "G_UNICODE_SCRIPT_MANDAIC")]
    Mandaic,
    #[doc(alias = "G_UNICODE_SCRIPT_CHAKMA")]
    Chakma,
    #[doc(alias = "G_UNICODE_SCRIPT_MEROITIC_CURSIVE")]
    MeroiticCursive,
    #[doc(alias = "G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS")]
    MeroiticHieroglyphs,
    #[doc(alias = "G_UNICODE_SCRIPT_MIAO")]
    Miao,
    #[doc(alias = "G_UNICODE_SCRIPT_SHARADA")]
    Sharada,
    #[doc(alias = "G_UNICODE_SCRIPT_SORA_SOMPENG")]
    SoraSompeng,
    #[doc(alias = "G_UNICODE_SCRIPT_TAKRI")]
    Takri,
    #[doc(alias = "G_UNICODE_SCRIPT_BASSA_VAH")]
    BassaVah,
    #[doc(alias = "G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN")]
    CaucasianAlbanian,
    #[doc(alias = "G_UNICODE_SCRIPT_DUPLOYAN")]
    Duployan,
    #[doc(alias = "G_UNICODE_SCRIPT_ELBASAN")]
    Elbasan,
    #[doc(alias = "G_UNICODE_SCRIPT_GRANTHA")]
    Grantha,
    #[doc(alias = "G_UNICODE_SCRIPT_KHOJKI")]
    Khojki,
    #[doc(alias = "G_UNICODE_SCRIPT_KHUDAWADI")]
    Khudawadi,
    #[doc(alias = "G_UNICODE_SCRIPT_LINEAR_A")]
    LinearA,
    #[doc(alias = "G_UNICODE_SCRIPT_MAHAJANI")]
    Mahajani,
    #[doc(alias = "G_UNICODE_SCRIPT_MANICHAEAN")]
    Manichaean,
    #[doc(alias = "G_UNICODE_SCRIPT_MENDE_KIKAKUI")]
    MendeKikakui,
    #[doc(alias = "G_UNICODE_SCRIPT_MODI")]
    Modi,
    #[doc(alias = "G_UNICODE_SCRIPT_MRO")]
    Mro,
    #[doc(alias = "G_UNICODE_SCRIPT_NABATAEAN")]
    Nabataean,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN")]
    OldNorthArabian,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_PERMIC")]
    OldPermic,
    #[doc(alias = "G_UNICODE_SCRIPT_PAHAWH_HMONG")]
    PahawhHmong,
    #[doc(alias = "G_UNICODE_SCRIPT_PALMYRENE")]
    Palmyrene,
    #[doc(alias = "G_UNICODE_SCRIPT_PAU_CIN_HAU")]
    PauCinHau,
    #[doc(alias = "G_UNICODE_SCRIPT_PSALTER_PAHLAVI")]
    PsalterPahlavi,
    #[doc(alias = "G_UNICODE_SCRIPT_SIDDHAM")]
    Siddham,
    #[doc(alias = "G_UNICODE_SCRIPT_TIRHUTA")]
    Tirhuta,
    #[doc(alias = "G_UNICODE_SCRIPT_WARANG_CITI")]
    WarangCiti,
    #[doc(alias = "G_UNICODE_SCRIPT_AHOM")]
    Ahom,
    #[doc(alias = "G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS")]
    AnatolianHieroglyphs,
    #[doc(alias = "G_UNICODE_SCRIPT_HATRAN")]
    Hatran,
    #[doc(alias = "G_UNICODE_SCRIPT_MULTANI")]
    Multani,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_HUNGARIAN")]
    OldHungarian,
    #[doc(alias = "G_UNICODE_SCRIPT_SIGNWRITING")]
    Signwriting,
    #[doc(alias = "G_UNICODE_SCRIPT_ADLAM")]
    Adlam,
    #[doc(alias = "G_UNICODE_SCRIPT_BHAIKSUKI")]
    Bhaiksuki,
    #[doc(alias = "G_UNICODE_SCRIPT_MARCHEN")]
    Marchen,
    #[doc(alias = "G_UNICODE_SCRIPT_NEWA")]
    Newa,
    #[doc(alias = "G_UNICODE_SCRIPT_OSAGE")]
    Osage,
    #[doc(alias = "G_UNICODE_SCRIPT_TANGUT")]
    Tangut,
    #[doc(alias = "G_UNICODE_SCRIPT_MASARAM_GONDI")]
    MasaramGondi,
    #[doc(alias = "G_UNICODE_SCRIPT_NUSHU")]
    Nushu,
    #[doc(alias = "G_UNICODE_SCRIPT_SOYOMBO")]
    Soyombo,
    #[doc(alias = "G_UNICODE_SCRIPT_ZANABAZAR_SQUARE")]
    ZanabazarSquare,
    #[doc(alias = "G_UNICODE_SCRIPT_DOGRA")]
    Dogra,
    #[doc(alias = "G_UNICODE_SCRIPT_GUNJALA_GONDI")]
    GunjalaGondi,
    #[doc(alias = "G_UNICODE_SCRIPT_HANIFI_ROHINGYA")]
    HanifiRohingya,
    #[doc(alias = "G_UNICODE_SCRIPT_MAKASAR")]
    Makasar,
    #[doc(alias = "G_UNICODE_SCRIPT_MEDEFAIDRIN")]
    Medefaidrin,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_SOGDIAN")]
    OldSogdian,
    #[doc(alias = "G_UNICODE_SCRIPT_SOGDIAN")]
    Sogdian,
    #[doc(alias = "G_UNICODE_SCRIPT_ELYMAIC")]
    Elymaic,
    #[doc(alias = "G_UNICODE_SCRIPT_NANDINAGARI")]
    Nandinagari,
    #[doc(alias = "G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG")]
    NyiakengPuachueHmong,
    #[doc(alias = "G_UNICODE_SCRIPT_WANCHO")]
    Wancho,
    #[doc(alias = "G_UNICODE_SCRIPT_CHORASMIAN")]
    Chorasmian,
    #[doc(alias = "G_UNICODE_SCRIPT_DIVES_AKURU")]
    DivesAkuru,
    #[doc(alias = "G_UNICODE_SCRIPT_KHITAN_SMALL_SCRIPT")]
    KhitanSmallScript,
    #[doc(alias = "G_UNICODE_SCRIPT_YEZIDI")]
    Yezidi,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_CYPRO_MINOAN")]
    CyproMinoan,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_UYGHUR")]
    OldUyghur,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_TANGSA")]
    Tangsa,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_TOTO")]
    Toto,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_VITHKUQI")]
    Vithkuqi,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_MATH")]
    Math,
    #[cfg(feature = "v2_74")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_74")))]
    #[doc(alias = "G_UNICODE_SCRIPT_KAWI")]
    Kawi,
    #[cfg(feature = "v2_74")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_74")))]
    #[doc(alias = "G_UNICODE_SCRIPT_NAG_MUNDARI")]
    NagMundari,
    #[doc(hidden)]
    __Unknown(i32),
}

impl UnicodeScript {
    #[doc(alias = "g_unicode_script_from_iso15924")]
    pub fn from_iso15924(iso15924: u32) -> UnicodeScript {
        unsafe { from_glib(ffi::g_unicode_script_from_iso15924(iso15924)) }
    }

    #[doc(alias = "g_unicode_script_to_iso15924")]
    pub fn to_iso15924(self) -> u32 {
        unsafe { ffi::g_unicode_script_to_iso15924(self.into_glib()) }
    }
}

#[doc(hidden)]
impl IntoGlib for UnicodeScript {
    type GlibType = ffi::GUnicodeScript;

    fn into_glib(self) -> ffi::GUnicodeScript {
        match self {
            Self::InvalidCode => ffi::G_UNICODE_SCRIPT_INVALID_CODE,
            Self::Common => ffi::G_UNICODE_SCRIPT_COMMON,
            Self::Inherited => ffi::G_UNICODE_SCRIPT_INHERITED,
            Self::Arabic => ffi::G_UNICODE_SCRIPT_ARABIC,
            Self::Armenian => ffi::G_UNICODE_SCRIPT_ARMENIAN,
            Self::Bengali => ffi::G_UNICODE_SCRIPT_BENGALI,
            Self::Bopomofo => ffi::G_UNICODE_SCRIPT_BOPOMOFO,
            Self::Cherokee => ffi::G_UNICODE_SCRIPT_CHEROKEE,
            Self::Coptic => ffi::G_UNICODE_SCRIPT_COPTIC,
            Self::Cyrillic => ffi::G_UNICODE_SCRIPT_CYRILLIC,
            Self::Deseret => ffi::G_UNICODE_SCRIPT_DESERET,
            Self::Devanagari => ffi::G_UNICODE_SCRIPT_DEVANAGARI,
            Self::Ethiopic => ffi::G_UNICODE_SCRIPT_ETHIOPIC,
            Self::Georgian => ffi::G_UNICODE_SCRIPT_GEORGIAN,
            Self::Gothic => ffi::G_UNICODE_SCRIPT_GOTHIC,
            Self::Greek => ffi::G_UNICODE_SCRIPT_GREEK,
            Self::Gujarati => ffi::G_UNICODE_SCRIPT_GUJARATI,
            Self::Gurmukhi => ffi::G_UNICODE_SCRIPT_GURMUKHI,
            Self::Han => ffi::G_UNICODE_SCRIPT_HAN,
            Self::Hangul => ffi::G_UNICODE_SCRIPT_HANGUL,
            Self::Hebrew => ffi::G_UNICODE_SCRIPT_HEBREW,
            Self::Hiragana => ffi::G_UNICODE_SCRIPT_HIRAGANA,
            Self::Kannada => ffi::G_UNICODE_SCRIPT_KANNADA,
            Self::Katakana => ffi::G_UNICODE_SCRIPT_KATAKANA,
            Self::Khmer => ffi::G_UNICODE_SCRIPT_KHMER,
            Self::Lao => ffi::G_UNICODE_SCRIPT_LAO,
            Self::Latin => ffi::G_UNICODE_SCRIPT_LATIN,
            Self::Malayalam => ffi::G_UNICODE_SCRIPT_MALAYALAM,
            Self::Mongolian => ffi::G_UNICODE_SCRIPT_MONGOLIAN,
            Self::Myanmar => ffi::G_UNICODE_SCRIPT_MYANMAR,
            Self::Ogham => ffi::G_UNICODE_SCRIPT_OGHAM,
            Self::OldItalic => ffi::G_UNICODE_SCRIPT_OLD_ITALIC,
            Self::Oriya => ffi::G_UNICODE_SCRIPT_ORIYA,
            Self::Runic => ffi::G_UNICODE_SCRIPT_RUNIC,
            Self::Sinhala => ffi::G_UNICODE_SCRIPT_SINHALA,
            Self::Syriac => ffi::G_UNICODE_SCRIPT_SYRIAC,
            Self::Tamil => ffi::G_UNICODE_SCRIPT_TAMIL,
            Self::Telugu => ffi::G_UNICODE_SCRIPT_TELUGU,
            Self::Thaana => ffi::G_UNICODE_SCRIPT_THAANA,
            Self::Thai => ffi::G_UNICODE_SCRIPT_THAI,
            Self::Tibetan => ffi::G_UNICODE_SCRIPT_TIBETAN,
            Self::CanadianAboriginal => ffi::G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL,
            Self::Yi => ffi::G_UNICODE_SCRIPT_YI,
            Self::Tagalog => ffi::G_UNICODE_SCRIPT_TAGALOG,
            Self::Hanunoo => ffi::G_UNICODE_SCRIPT_HANUNOO,
            Self::Buhid => ffi::G_UNICODE_SCRIPT_BUHID,
            Self::Tagbanwa => ffi::G_UNICODE_SCRIPT_TAGBANWA,
            Self::Braille => ffi::G_UNICODE_SCRIPT_BRAILLE,
            Self::Cypriot => ffi::G_UNICODE_SCRIPT_CYPRIOT,
            Self::Limbu => ffi::G_UNICODE_SCRIPT_LIMBU,
            Self::Osmanya => ffi::G_UNICODE_SCRIPT_OSMANYA,
            Self::Shavian => ffi::G_UNICODE_SCRIPT_SHAVIAN,
            Self::LinearB => ffi::G_UNICODE_SCRIPT_LINEAR_B,
            Self::TaiLe => ffi::G_UNICODE_SCRIPT_TAI_LE,
            Self::Ugaritic => ffi::G_UNICODE_SCRIPT_UGARITIC,
            Self::NewTaiLue => ffi::G_UNICODE_SCRIPT_NEW_TAI_LUE,
            Self::Buginese => ffi::G_UNICODE_SCRIPT_BUGINESE,
            Self::Glagolitic => ffi::G_UNICODE_SCRIPT_GLAGOLITIC,
            Self::Tifinagh => ffi::G_UNICODE_SCRIPT_TIFINAGH,
            Self::SylotiNagri => ffi::G_UNICODE_SCRIPT_SYLOTI_NAGRI,
            Self::OldPersian => ffi::G_UNICODE_SCRIPT_OLD_PERSIAN,
            Self::Kharoshthi => ffi::G_UNICODE_SCRIPT_KHAROSHTHI,
            Self::Unknown => ffi::G_UNICODE_SCRIPT_UNKNOWN,
            Self::Balinese => ffi::G_UNICODE_SCRIPT_BALINESE,
            Self::Cuneiform => ffi::G_UNICODE_SCRIPT_CUNEIFORM,
            Self::Phoenician => ffi::G_UNICODE_SCRIPT_PHOENICIAN,
            Self::PhagsPa => ffi::G_UNICODE_SCRIPT_PHAGS_PA,
            Self::Nko => ffi::G_UNICODE_SCRIPT_NKO,
            Self::KayahLi => ffi::G_UNICODE_SCRIPT_KAYAH_LI,
            Self::Lepcha => ffi::G_UNICODE_SCRIPT_LEPCHA,
            Self::Rejang => ffi::G_UNICODE_SCRIPT_REJANG,
            Self::Sundanese => ffi::G_UNICODE_SCRIPT_SUNDANESE,
            Self::Saurashtra => ffi::G_UNICODE_SCRIPT_SAURASHTRA,
            Self::Cham => ffi::G_UNICODE_SCRIPT_CHAM,
            Self::OlChiki => ffi::G_UNICODE_SCRIPT_OL_CHIKI,
            Self::Vai => ffi::G_UNICODE_SCRIPT_VAI,
            Self::Carian => ffi::G_UNICODE_SCRIPT_CARIAN,
            Self::Lycian => ffi::G_UNICODE_SCRIPT_LYCIAN,
            Self::Lydian => ffi::G_UNICODE_SCRIPT_LYDIAN,
            Self::Avestan => ffi::G_UNICODE_SCRIPT_AVESTAN,
            Self::Bamum => ffi::G_UNICODE_SCRIPT_BAMUM,
            Self::EgyptianHieroglyphs => ffi::G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS,
            Self::ImperialAramaic => ffi::G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC,
            Self::InscriptionalPahlavi => ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI,
            Self::InscriptionalParthian => ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN,
            Self::Javanese => ffi::G_UNICODE_SCRIPT_JAVANESE,
            Self::Kaithi => ffi::G_UNICODE_SCRIPT_KAITHI,
            Self::Lisu => ffi::G_UNICODE_SCRIPT_LISU,
            Self::MeeteiMayek => ffi::G_UNICODE_SCRIPT_MEETEI_MAYEK,
            Self::OldSouthArabian => ffi::G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN,
            Self::OldTurkic => ffi::G_UNICODE_SCRIPT_OLD_TURKIC,
            Self::Samaritan => ffi::G_UNICODE_SCRIPT_SAMARITAN,
            Self::TaiTham => ffi::G_UNICODE_SCRIPT_TAI_THAM,
            Self::TaiViet => ffi::G_UNICODE_SCRIPT_TAI_VIET,
            Self::Batak => ffi::G_UNICODE_SCRIPT_BATAK,
            Self::Brahmi => ffi::G_UNICODE_SCRIPT_BRAHMI,
            Self::Mandaic => ffi::G_UNICODE_SCRIPT_MANDAIC,
            Self::Chakma => ffi::G_UNICODE_SCRIPT_CHAKMA,
            Self::MeroiticCursive => ffi::G_UNICODE_SCRIPT_MEROITIC_CURSIVE,
            Self::MeroiticHieroglyphs => ffi::G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS,
            Self::Miao => ffi::G_UNICODE_SCRIPT_MIAO,
            Self::Sharada => ffi::G_UNICODE_SCRIPT_SHARADA,
            Self::SoraSompeng => ffi::G_UNICODE_SCRIPT_SORA_SOMPENG,
            Self::Takri => ffi::G_UNICODE_SCRIPT_TAKRI,
            Self::BassaVah => ffi::G_UNICODE_SCRIPT_BASSA_VAH,
            Self::CaucasianAlbanian => ffi::G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN,
            Self::Duployan => ffi::G_UNICODE_SCRIPT_DUPLOYAN,
            Self::Elbasan => ffi::G_UNICODE_SCRIPT_ELBASAN,
            Self::Grantha => ffi::G_UNICODE_SCRIPT_GRANTHA,
            Self::Khojki => ffi::G_UNICODE_SCRIPT_KHOJKI,
            Self::Khudawadi => ffi::G_UNICODE_SCRIPT_KHUDAWADI,
            Self::LinearA => ffi::G_UNICODE_SCRIPT_LINEAR_A,
            Self::Mahajani => ffi::G_UNICODE_SCRIPT_MAHAJANI,
            Self::Manichaean => ffi::G_UNICODE_SCRIPT_MANICHAEAN,
            Self::MendeKikakui => ffi::G_UNICODE_SCRIPT_MENDE_KIKAKUI,
            Self::Modi => ffi::G_UNICODE_SCRIPT_MODI,
            Self::Mro => ffi::G_UNICODE_SCRIPT_MRO,
            Self::Nabataean => ffi::G_UNICODE_SCRIPT_NABATAEAN,
            Self::OldNorthArabian => ffi::G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN,
            Self::OldPermic => ffi::G_UNICODE_SCRIPT_OLD_PERMIC,
            Self::PahawhHmong => ffi::G_UNICODE_SCRIPT_PAHAWH_HMONG,
            Self::Palmyrene => ffi::G_UNICODE_SCRIPT_PALMYRENE,
            Self::PauCinHau => ffi::G_UNICODE_SCRIPT_PAU_CIN_HAU,
            Self::PsalterPahlavi => ffi::G_UNICODE_SCRIPT_PSALTER_PAHLAVI,
            Self::Siddham => ffi::G_UNICODE_SCRIPT_SIDDHAM,
            Self::Tirhuta => ffi::G_UNICODE_SCRIPT_TIRHUTA,
            Self::WarangCiti => ffi::G_UNICODE_SCRIPT_WARANG_CITI,
            Self::Ahom => ffi::G_UNICODE_SCRIPT_AHOM,
            Self::AnatolianHieroglyphs => ffi::G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS,
            Self::Hatran => ffi::G_UNICODE_SCRIPT_HATRAN,
            Self::Multani => ffi::G_UNICODE_SCRIPT_MULTANI,
            Self::OldHungarian => ffi::G_UNICODE_SCRIPT_OLD_HUNGARIAN,
            Self::Signwriting => ffi::G_UNICODE_SCRIPT_SIGNWRITING,
            Self::Adlam => ffi::G_UNICODE_SCRIPT_ADLAM,
            Self::Bhaiksuki => ffi::G_UNICODE_SCRIPT_BHAIKSUKI,
            Self::Marchen => ffi::G_UNICODE_SCRIPT_MARCHEN,
            Self::Newa => ffi::G_UNICODE_SCRIPT_NEWA,
            Self::Osage => ffi::G_UNICODE_SCRIPT_OSAGE,
            Self::Tangut => ffi::G_UNICODE_SCRIPT_TANGUT,
            Self::MasaramGondi => ffi::G_UNICODE_SCRIPT_MASARAM_GONDI,
            Self::Nushu => ffi::G_UNICODE_SCRIPT_NUSHU,
            Self::Soyombo => ffi::G_UNICODE_SCRIPT_SOYOMBO,
            Self::ZanabazarSquare => ffi::G_UNICODE_SCRIPT_ZANABAZAR_SQUARE,
            Self::Dogra => ffi::G_UNICODE_SCRIPT_DOGRA,
            Self::GunjalaGondi => ffi::G_UNICODE_SCRIPT_GUNJALA_GONDI,
            Self::HanifiRohingya => ffi::G_UNICODE_SCRIPT_HANIFI_ROHINGYA,
            Self::Makasar => ffi::G_UNICODE_SCRIPT_MAKASAR,
            Self::Medefaidrin => ffi::G_UNICODE_SCRIPT_MEDEFAIDRIN,
            Self::OldSogdian => ffi::G_UNICODE_SCRIPT_OLD_SOGDIAN,
            Self::Sogdian => ffi::G_UNICODE_SCRIPT_SOGDIAN,
            Self::Elymaic => ffi::G_UNICODE_SCRIPT_ELYMAIC,
            Self::Nandinagari => ffi::G_UNICODE_SCRIPT_NANDINAGARI,
            Self::NyiakengPuachueHmong => ffi::G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG,
            Self::Wancho => ffi::G_UNICODE_SCRIPT_WANCHO,
            Self::Chorasmian => ffi::G_UNICODE_SCRIPT_CHORASMIAN,
            Self::DivesAkuru => ffi::G_UNICODE_SCRIPT_DIVES_AKURU,
            Self::KhitanSmallScript => ffi::G_UNICODE_SCRIPT_KHITAN_SMALL_SCRIPT,
            Self::Yezidi => ffi::G_UNICODE_SCRIPT_YEZIDI,
            #[cfg(feature = "v2_72")]
            Self::CyproMinoan => ffi::G_UNICODE_SCRIPT_CYPRO_MINOAN,
            #[cfg(feature = "v2_72")]
            Self::OldUyghur => ffi::G_UNICODE_SCRIPT_OLD_UYGHUR,
            #[cfg(feature = "v2_72")]
            Self::Tangsa => ffi::G_UNICODE_SCRIPT_TANGSA,
            #[cfg(feature = "v2_72")]
            Self::Toto => ffi::G_UNICODE_SCRIPT_TOTO,
            #[cfg(feature = "v2_72")]
            Self::Vithkuqi => ffi::G_UNICODE_SCRIPT_VITHKUQI,
            #[cfg(feature = "v2_72")]
            Self::Math => ffi::G_UNICODE_SCRIPT_MATH,
            #[cfg(feature = "v2_74")]
            Self::Kawi => ffi::G_UNICODE_SCRIPT_KAWI,
            #[cfg(feature = "v2_74")]
            Self::NagMundari => ffi::G_UNICODE_SCRIPT_NAG_MUNDARI,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GUnicodeScript> for UnicodeScript {
    unsafe fn from_glib(value: ffi::GUnicodeScript) -> Self {
        match value {
            ffi::G_UNICODE_SCRIPT_INVALID_CODE => Self::InvalidCode,
            ffi::G_UNICODE_SCRIPT_COMMON => Self::Common,
            ffi::G_UNICODE_SCRIPT_INHERITED => Self::Inherited,
            ffi::G_UNICODE_SCRIPT_ARABIC => Self::Arabic,
            ffi::G_UNICODE_SCRIPT_ARMENIAN => Self::Armenian,
            ffi::G_UNICODE_SCRIPT_BENGALI => Self::Bengali,
            ffi::G_UNICODE_SCRIPT_BOPOMOFO => Self::Bopomofo,
            ffi::G_UNICODE_SCRIPT_CHEROKEE => Self::Cherokee,
            ffi::G_UNICODE_SCRIPT_COPTIC => Self::Coptic,
            ffi::G_UNICODE_SCRIPT_CYRILLIC => Self::Cyrillic,
            ffi::G_UNICODE_SCRIPT_DESERET => Self::Deseret,
            ffi::G_UNICODE_SCRIPT_DEVANAGARI => Self::Devanagari,
            ffi::G_UNICODE_SCRIPT_ETHIOPIC => Self::Ethiopic,
            ffi::G_UNICODE_SCRIPT_GEORGIAN => Self::Georgian,
            ffi::G_UNICODE_SCRIPT_GOTHIC => Self::Gothic,
            ffi::G_UNICODE_SCRIPT_GREEK => Self::Greek,
            ffi::G_UNICODE_SCRIPT_GUJARATI => Self::Gujarati,
            ffi::G_UNICODE_SCRIPT_GURMUKHI => Self::Gurmukhi,
            ffi::G_UNICODE_SCRIPT_HAN => Self::Han,
            ffi::G_UNICODE_SCRIPT_HANGUL => Self::Hangul,
            ffi::G_UNICODE_SCRIPT_HEBREW => Self::Hebrew,
            ffi::G_UNICODE_SCRIPT_HIRAGANA => Self::Hiragana,
            ffi::G_UNICODE_SCRIPT_KANNADA => Self::Kannada,
            ffi::G_UNICODE_SCRIPT_KATAKANA => Self::Katakana,
            ffi::G_UNICODE_SCRIPT_KHMER => Self::Khmer,
            ffi::G_UNICODE_SCRIPT_LAO => Self::Lao,
            ffi::G_UNICODE_SCRIPT_LATIN => Self::Latin,
            ffi::G_UNICODE_SCRIPT_MALAYALAM => Self::Malayalam,
            ffi::G_UNICODE_SCRIPT_MONGOLIAN => Self::Mongolian,
            ffi::G_UNICODE_SCRIPT_MYANMAR => Self::Myanmar,
            ffi::G_UNICODE_SCRIPT_OGHAM => Self::Ogham,
            ffi::G_UNICODE_SCRIPT_OLD_ITALIC => Self::OldItalic,
            ffi::G_UNICODE_SCRIPT_ORIYA => Self::Oriya,
            ffi::G_UNICODE_SCRIPT_RUNIC => Self::Runic,
            ffi::G_UNICODE_SCRIPT_SINHALA => Self::Sinhala,
            ffi::G_UNICODE_SCRIPT_SYRIAC => Self::Syriac,
            ffi::G_UNICODE_SCRIPT_TAMIL => Self::Tamil,
            ffi::G_UNICODE_SCRIPT_TELUGU => Self::Telugu,
            ffi::G_UNICODE_SCRIPT_THAANA => Self::Thaana,
            ffi::G_UNICODE_SCRIPT_THAI => Self::Thai,
            ffi::G_UNICODE_SCRIPT_TIBETAN => Self::Tibetan,
            ffi::G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL => Self::CanadianAboriginal,
            ffi::G_UNICODE_SCRIPT_YI => Self::Yi,
            ffi::G_UNICODE_SCRIPT_TAGALOG => Self::Tagalog,
            ffi::G_UNICODE_SCRIPT_HANUNOO => Self::Hanunoo,
            ffi::G_UNICODE_SCRIPT_BUHID => Self::Buhid,
            ffi::G_UNICODE_SCRIPT_TAGBANWA => Self::Tagbanwa,
            ffi::G_UNICODE_SCRIPT_BRAILLE => Self::Braille,
            ffi::G_UNICODE_SCRIPT_CYPRIOT => Self::Cypriot,
            ffi::G_UNICODE_SCRIPT_LIMBU => Self::Limbu,
            ffi::G_UNICODE_SCRIPT_OSMANYA => Self::Osmanya,
            ffi::G_UNICODE_SCRIPT_SHAVIAN => Self::Shavian,
            ffi::G_UNICODE_SCRIPT_LINEAR_B => Self::LinearB,
            ffi::G_UNICODE_SCRIPT_TAI_LE => Self::TaiLe,
            ffi::G_UNICODE_SCRIPT_UGARITIC => Self::Ugaritic,
            ffi::G_UNICODE_SCRIPT_NEW_TAI_LUE => Self::NewTaiLue,
            ffi::G_UNICODE_SCRIPT_BUGINESE => Self::Buginese,
            ffi::G_UNICODE_SCRIPT_GLAGOLITIC => Self::Glagolitic,
            ffi::G_UNICODE_SCRIPT_TIFINAGH => Self::Tifinagh,
            ffi::G_UNICODE_SCRIPT_SYLOTI_NAGRI => Self::SylotiNagri,
            ffi::G_UNICODE_SCRIPT_OLD_PERSIAN => Self::OldPersian,
            ffi::G_UNICODE_SCRIPT_KHAROSHTHI => Self::Kharoshthi,
            ffi::G_UNICODE_SCRIPT_UNKNOWN => Self::Unknown,
            ffi::G_UNICODE_SCRIPT_BALINESE => Self::Balinese,
            ffi::G_UNICODE_SCRIPT_CUNEIFORM => Self::Cuneiform,
            ffi::G_UNICODE_SCRIPT_PHOENICIAN => Self::Phoenician,
            ffi::G_UNICODE_SCRIPT_PHAGS_PA => Self::PhagsPa,
            ffi::G_UNICODE_SCRIPT_NKO => Self::Nko,
            ffi::G_UNICODE_SCRIPT_KAYAH_LI => Self::KayahLi,
            ffi::G_UNICODE_SCRIPT_LEPCHA => Self::Lepcha,
            ffi::G_UNICODE_SCRIPT_REJANG => Self::Rejang,
            ffi::G_UNICODE_SCRIPT_SUNDANESE => Self::Sundanese,
            ffi::G_UNICODE_SCRIPT_SAURASHTRA => Self::Saurashtra,
            ffi::G_UNICODE_SCRIPT_CHAM => Self::Cham,
            ffi::G_UNICODE_SCRIPT_OL_CHIKI => Self::OlChiki,
            ffi::G_UNICODE_SCRIPT_VAI => Self::Vai,
            ffi::G_UNICODE_SCRIPT_CARIAN => Self::Carian,
            ffi::G_UNICODE_SCRIPT_LYCIAN => Self::Lycian,
            ffi::G_UNICODE_SCRIPT_LYDIAN => Self::Lydian,
            ffi::G_UNICODE_SCRIPT_AVESTAN => Self::Avestan,
            ffi::G_UNICODE_SCRIPT_BAMUM => Self::Bamum,
            ffi::G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS => Self::EgyptianHieroglyphs,
            ffi::G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC => Self::ImperialAramaic,
            ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI => Self::InscriptionalPahlavi,
            ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN => Self::InscriptionalParthian,
            ffi::G_UNICODE_SCRIPT_JAVANESE => Self::Javanese,
            ffi::G_UNICODE_SCRIPT_KAITHI => Self::Kaithi,
            ffi::G_UNICODE_SCRIPT_LISU => Self::Lisu,
            ffi::G_UNICODE_SCRIPT_MEETEI_MAYEK => Self::MeeteiMayek,
            ffi::G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN => Self::OldSouthArabian,
            ffi::G_UNICODE_SCRIPT_OLD_TURKIC => Self::OldTurkic,
            ffi::G_UNICODE_SCRIPT_SAMARITAN => Self::Samaritan,
            ffi::G_UNICODE_SCRIPT_TAI_THAM => Self::TaiTham,
            ffi::G_UNICODE_SCRIPT_TAI_VIET => Self::TaiViet,
            ffi::G_UNICODE_SCRIPT_BATAK => Self::Batak,
            ffi::G_UNICODE_SCRIPT_BRAHMI => Self::Brahmi,
            ffi::G_UNICODE_SCRIPT_MANDAIC => Self::Mandaic,
            ffi::G_UNICODE_SCRIPT_CHAKMA => Self::Chakma,
            ffi::G_UNICODE_SCRIPT_MEROITIC_CURSIVE => Self::MeroiticCursive,
            ffi::G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS => Self::MeroiticHieroglyphs,
            ffi::G_UNICODE_SCRIPT_MIAO => Self::Miao,
            ffi::G_UNICODE_SCRIPT_SHARADA => Self::Sharada,
            ffi::G_UNICODE_SCRIPT_SORA_SOMPENG => Self::SoraSompeng,
            ffi::G_UNICODE_SCRIPT_TAKRI => Self::Takri,
            ffi::G_UNICODE_SCRIPT_BASSA_VAH => Self::BassaVah,
            ffi::G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN => Self::CaucasianAlbanian,
            ffi::G_UNICODE_SCRIPT_DUPLOYAN => Self::Duployan,
            ffi::G_UNICODE_SCRIPT_ELBASAN => Self::Elbasan,
            ffi::G_UNICODE_SCRIPT_GRANTHA => Self::Grantha,
            ffi::G_UNICODE_SCRIPT_KHOJKI => Self::Khojki,
            ffi::G_UNICODE_SCRIPT_KHUDAWADI => Self::Khudawadi,
            ffi::G_UNICODE_SCRIPT_LINEAR_A => Self::LinearA,
            ffi::G_UNICODE_SCRIPT_MAHAJANI => Self::Mahajani,
            ffi::G_UNICODE_SCRIPT_MANICHAEAN => Self::Manichaean,
            ffi::G_UNICODE_SCRIPT_MENDE_KIKAKUI => Self::MendeKikakui,
            ffi::G_UNICODE_SCRIPT_MODI => Self::Modi,
            ffi::G_UNICODE_SCRIPT_MRO => Self::Mro,
            ffi::G_UNICODE_SCRIPT_NABATAEAN => Self::Nabataean,
            ffi::G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN => Self::OldNorthArabian,
            ffi::G_UNICODE_SCRIPT_OLD_PERMIC => Self::OldPermic,
            ffi::G_UNICODE_SCRIPT_PAHAWH_HMONG => Self::PahawhHmong,
            ffi::G_UNICODE_SCRIPT_PALMYRENE => Self::Palmyrene,
            ffi::G_UNICODE_SCRIPT_PAU_CIN_HAU => Self::PauCinHau,
            ffi::G_UNICODE_SCRIPT_PSALTER_PAHLAVI => Self::PsalterPahlavi,
            ffi::G_UNICODE_SCRIPT_SIDDHAM => Self::Siddham,
            ffi::G_UNICODE_SCRIPT_TIRHUTA => Self::Tirhuta,
            ffi::G_UNICODE_SCRIPT_WARANG_CITI => Self::WarangCiti,
            ffi::G_UNICODE_SCRIPT_AHOM => Self::Ahom,
            ffi::G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS => Self::AnatolianHieroglyphs,
            ffi::G_UNICODE_SCRIPT_HATRAN => Self::Hatran,
            ffi::G_UNICODE_SCRIPT_MULTANI => Self::Multani,
            ffi::G_UNICODE_SCRIPT_OLD_HUNGARIAN => Self::OldHungarian,
            ffi::G_UNICODE_SCRIPT_SIGNWRITING => Self::Signwriting,
            ffi::G_UNICODE_SCRIPT_ADLAM => Self::Adlam,
            ffi::G_UNICODE_SCRIPT_BHAIKSUKI => Self::Bhaiksuki,
            ffi::G_UNICODE_SCRIPT_MARCHEN => Self::Marchen,
            ffi::G_UNICODE_SCRIPT_NEWA => Self::Newa,
            ffi::G_UNICODE_SCRIPT_OSAGE => Self::Osage,
            ffi::G_UNICODE_SCRIPT_TANGUT => Self::Tangut,
            ffi::G_UNICODE_SCRIPT_MASARAM_GONDI => Self::MasaramGondi,
            ffi::G_UNICODE_SCRIPT_NUSHU => Self::Nushu,
            ffi::G_UNICODE_SCRIPT_SOYOMBO => Self::Soyombo,
            ffi::G_UNICODE_SCRIPT_ZANABAZAR_SQUARE => Self::ZanabazarSquare,
            ffi::G_UNICODE_SCRIPT_DOGRA => Self::Dogra,
            ffi::G_UNICODE_SCRIPT_GUNJALA_GONDI => Self::GunjalaGondi,
            ffi::G_UNICODE_SCRIPT_HANIFI_ROHINGYA => Self::HanifiRohingya,
            ffi::G_UNICODE_SCRIPT_MAKASAR => Self::Makasar,
            ffi::G_UNICODE_SCRIPT_MEDEFAIDRIN => Self::Medefaidrin,
            ffi::G_UNICODE_SCRIPT_OLD_SOGDIAN => Self::OldSogdian,
            ffi::G_UNICODE_SCRIPT_SOGDIAN => Self::Sogdian,
            ffi::G_UNICODE_SCRIPT_ELYMAIC => Self::Elymaic,
            ffi::G_UNICODE_SCRIPT_NANDINAGARI => Self::Nandinagari,
            ffi::G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG => Self::NyiakengPuachueHmong,
            ffi::G_UNICODE_SCRIPT_WANCHO => Self::Wancho,
            ffi::G_UNICODE_SCRIPT_CHORASMIAN => Self::Chorasmian,
            ffi::G_UNICODE_SCRIPT_DIVES_AKURU => Self::DivesAkuru,
            ffi::G_UNICODE_SCRIPT_KHITAN_SMALL_SCRIPT => Self::KhitanSmallScript,
            ffi::G_UNICODE_SCRIPT_YEZIDI => Self::Yezidi,
            #[cfg(feature = "v2_72")]
            ffi::G_UNICODE_SCRIPT_CYPRO_MINOAN => Self::CyproMinoan,
            #[cfg(feature = "v2_72")]
            ffi::G_UNICODE_SCRIPT_OLD_UYGHUR => Self::OldUyghur,
            #[cfg(feature = "v2_72")]
            ffi::G_UNICODE_SCRIPT_TANGSA => Self::Tangsa,
            #[cfg(feature = "v2_72")]
            ffi::G_UNICODE_SCRIPT_TOTO => Self::Toto,
            #[cfg(feature = "v2_72")]
            ffi::G_UNICODE_SCRIPT_VITHKUQI => Self::Vithkuqi,
            #[cfg(feature = "v2_72")]
            ffi::G_UNICODE_SCRIPT_MATH => Self::Math,
            #[cfg(feature = "v2_74")]
            ffi::G_UNICODE_SCRIPT_KAWI => Self::Kawi,
            #[cfg(feature = "v2_74")]
            ffi::G_UNICODE_SCRIPT_NAG_MUNDARI => Self::NagMundari,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for UnicodeScript {
    #[inline]
    #[doc(alias = "g_unicode_script_get_type")]
    fn static_type() -> crate::Type {
        unsafe { from_glib(ffi::g_unicode_script_get_type()) }
    }
}

impl crate::HasParamSpec for UnicodeScript {
    type ParamSpec = crate::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> crate::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl crate::value::ValueType for UnicodeScript {
    type Type = Self;
}

unsafe impl<'a> crate::value::FromValue<'a> for UnicodeScript {
    type Checker = crate::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a crate::Value) -> Self {
        from_glib(crate::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UnicodeScript {
    #[inline]
    fn to_value(&self) -> crate::Value {
        let mut value = crate::Value::for_value_type::<Self>();
        unsafe {
            crate::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> crate::Type {
        Self::static_type()
    }
}

impl From<UnicodeScript> for crate::Value {
    #[inline]
    fn from(v: UnicodeScript) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GUnicodeType")]
pub enum UnicodeType {
    #[doc(alias = "G_UNICODE_CONTROL")]
    Control,
    #[doc(alias = "G_UNICODE_FORMAT")]
    Format,
    #[doc(alias = "G_UNICODE_UNASSIGNED")]
    Unassigned,
    #[doc(alias = "G_UNICODE_PRIVATE_USE")]
    PrivateUse,
    #[doc(alias = "G_UNICODE_SURROGATE")]
    Surrogate,
    #[doc(alias = "G_UNICODE_LOWERCASE_LETTER")]
    LowercaseLetter,
    #[doc(alias = "G_UNICODE_MODIFIER_LETTER")]
    ModifierLetter,
    #[doc(alias = "G_UNICODE_OTHER_LETTER")]
    OtherLetter,
    #[doc(alias = "G_UNICODE_TITLECASE_LETTER")]
    TitlecaseLetter,
    #[doc(alias = "G_UNICODE_UPPERCASE_LETTER")]
    UppercaseLetter,
    #[doc(alias = "G_UNICODE_SPACING_MARK")]
    SpacingMark,
    #[doc(alias = "G_UNICODE_ENCLOSING_MARK")]
    EnclosingMark,
    #[doc(alias = "G_UNICODE_NON_SPACING_MARK")]
    NonSpacingMark,
    #[doc(alias = "G_UNICODE_DECIMAL_NUMBER")]
    DecimalNumber,
    #[doc(alias = "G_UNICODE_LETTER_NUMBER")]
    LetterNumber,
    #[doc(alias = "G_UNICODE_OTHER_NUMBER")]
    OtherNumber,
    #[doc(alias = "G_UNICODE_CONNECT_PUNCTUATION")]
    ConnectPunctuation,
    #[doc(alias = "G_UNICODE_DASH_PUNCTUATION")]
    DashPunctuation,
    #[doc(alias = "G_UNICODE_CLOSE_PUNCTUATION")]
    ClosePunctuation,
    #[doc(alias = "G_UNICODE_FINAL_PUNCTUATION")]
    FinalPunctuation,
    #[doc(alias = "G_UNICODE_INITIAL_PUNCTUATION")]
    InitialPunctuation,
    #[doc(alias = "G_UNICODE_OTHER_PUNCTUATION")]
    OtherPunctuation,
    #[doc(alias = "G_UNICODE_OPEN_PUNCTUATION")]
    OpenPunctuation,
    #[doc(alias = "G_UNICODE_CURRENCY_SYMBOL")]
    CurrencySymbol,
    #[doc(alias = "G_UNICODE_MODIFIER_SYMBOL")]
    ModifierSymbol,
    #[doc(alias = "G_UNICODE_MATH_SYMBOL")]
    MathSymbol,
    #[doc(alias = "G_UNICODE_OTHER_SYMBOL")]
    OtherSymbol,
    #[doc(alias = "G_UNICODE_LINE_SEPARATOR")]
    LineSeparator,
    #[doc(alias = "G_UNICODE_PARAGRAPH_SEPARATOR")]
    ParagraphSeparator,
    #[doc(alias = "G_UNICODE_SPACE_SEPARATOR")]
    SpaceSeparator,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for UnicodeType {
    type GlibType = ffi::GUnicodeType;

    fn into_glib(self) -> ffi::GUnicodeType {
        match self {
            Self::Control => ffi::G_UNICODE_CONTROL,
            Self::Format => ffi::G_UNICODE_FORMAT,
            Self::Unassigned => ffi::G_UNICODE_UNASSIGNED,
            Self::PrivateUse => ffi::G_UNICODE_PRIVATE_USE,
            Self::Surrogate => ffi::G_UNICODE_SURROGATE,
            Self::LowercaseLetter => ffi::G_UNICODE_LOWERCASE_LETTER,
            Self::ModifierLetter => ffi::G_UNICODE_MODIFIER_LETTER,
            Self::OtherLetter => ffi::G_UNICODE_OTHER_LETTER,
            Self::TitlecaseLetter => ffi::G_UNICODE_TITLECASE_LETTER,
            Self::UppercaseLetter => ffi::G_UNICODE_UPPERCASE_LETTER,
            Self::SpacingMark => ffi::G_UNICODE_SPACING_MARK,
            Self::EnclosingMark => ffi::G_UNICODE_ENCLOSING_MARK,
            Self::NonSpacingMark => ffi::G_UNICODE_NON_SPACING_MARK,
            Self::DecimalNumber => ffi::G_UNICODE_DECIMAL_NUMBER,
            Self::LetterNumber => ffi::G_UNICODE_LETTER_NUMBER,
            Self::OtherNumber => ffi::G_UNICODE_OTHER_NUMBER,
            Self::ConnectPunctuation => ffi::G_UNICODE_CONNECT_PUNCTUATION,
            Self::DashPunctuation => ffi::G_UNICODE_DASH_PUNCTUATION,
            Self::ClosePunctuation => ffi::G_UNICODE_CLOSE_PUNCTUATION,
            Self::FinalPunctuation => ffi::G_UNICODE_FINAL_PUNCTUATION,
            Self::InitialPunctuation => ffi::G_UNICODE_INITIAL_PUNCTUATION,
            Self::OtherPunctuation => ffi::G_UNICODE_OTHER_PUNCTUATION,
            Self::OpenPunctuation => ffi::G_UNICODE_OPEN_PUNCTUATION,
            Self::CurrencySymbol => ffi::G_UNICODE_CURRENCY_SYMBOL,
            Self::ModifierSymbol => ffi::G_UNICODE_MODIFIER_SYMBOL,
            Self::MathSymbol => ffi::G_UNICODE_MATH_SYMBOL,
            Self::OtherSymbol => ffi::G_UNICODE_OTHER_SYMBOL,
            Self::LineSeparator => ffi::G_UNICODE_LINE_SEPARATOR,
            Self::ParagraphSeparator => ffi::G_UNICODE_PARAGRAPH_SEPARATOR,
            Self::SpaceSeparator => ffi::G_UNICODE_SPACE_SEPARATOR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GUnicodeType> for UnicodeType {
    unsafe fn from_glib(value: ffi::GUnicodeType) -> Self {
        match value {
            ffi::G_UNICODE_CONTROL => Self::Control,
            ffi::G_UNICODE_FORMAT => Self::Format,
            ffi::G_UNICODE_UNASSIGNED => Self::Unassigned,
            ffi::G_UNICODE_PRIVATE_USE => Self::PrivateUse,
            ffi::G_UNICODE_SURROGATE => Self::Surrogate,
            ffi::G_UNICODE_LOWERCASE_LETTER => Self::LowercaseLetter,
            ffi::G_UNICODE_MODIFIER_LETTER => Self::ModifierLetter,
            ffi::G_UNICODE_OTHER_LETTER => Self::OtherLetter,
            ffi::G_UNICODE_TITLECASE_LETTER => Self::TitlecaseLetter,
            ffi::G_UNICODE_UPPERCASE_LETTER => Self::UppercaseLetter,
            ffi::G_UNICODE_SPACING_MARK => Self::SpacingMark,
            ffi::G_UNICODE_ENCLOSING_MARK => Self::EnclosingMark,
            ffi::G_UNICODE_NON_SPACING_MARK => Self::NonSpacingMark,
            ffi::G_UNICODE_DECIMAL_NUMBER => Self::DecimalNumber,
            ffi::G_UNICODE_LETTER_NUMBER => Self::LetterNumber,
            ffi::G_UNICODE_OTHER_NUMBER => Self::OtherNumber,
            ffi::G_UNICODE_CONNECT_PUNCTUATION => Self::ConnectPunctuation,
            ffi::G_UNICODE_DASH_PUNCTUATION => Self::DashPunctuation,
            ffi::G_UNICODE_CLOSE_PUNCTUATION => Self::ClosePunctuation,
            ffi::G_UNICODE_FINAL_PUNCTUATION => Self::FinalPunctuation,
            ffi::G_UNICODE_INITIAL_PUNCTUATION => Self::InitialPunctuation,
            ffi::G_UNICODE_OTHER_PUNCTUATION => Self::OtherPunctuation,
            ffi::G_UNICODE_OPEN_PUNCTUATION => Self::OpenPunctuation,
            ffi::G_UNICODE_CURRENCY_SYMBOL => Self::CurrencySymbol,
            ffi::G_UNICODE_MODIFIER_SYMBOL => Self::ModifierSymbol,
            ffi::G_UNICODE_MATH_SYMBOL => Self::MathSymbol,
            ffi::G_UNICODE_OTHER_SYMBOL => Self::OtherSymbol,
            ffi::G_UNICODE_LINE_SEPARATOR => Self::LineSeparator,
            ffi::G_UNICODE_PARAGRAPH_SEPARATOR => Self::ParagraphSeparator,
            ffi::G_UNICODE_SPACE_SEPARATOR => Self::SpaceSeparator,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for UnicodeType {
    #[inline]
    #[doc(alias = "g_unicode_type_get_type")]
    fn static_type() -> crate::Type {
        unsafe { from_glib(ffi::g_unicode_type_get_type()) }
    }
}

impl crate::HasParamSpec for UnicodeType {
    type ParamSpec = crate::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> crate::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl crate::value::ValueType for UnicodeType {
    type Type = Self;
}

unsafe impl<'a> crate::value::FromValue<'a> for UnicodeType {
    type Checker = crate::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a crate::Value) -> Self {
        from_glib(crate::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UnicodeType {
    #[inline]
    fn to_value(&self) -> crate::Value {
        let mut value = crate::Value::for_value_type::<Self>();
        unsafe {
            crate::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> crate::Type {
        Self::static_type()
    }
}

impl From<UnicodeType> for crate::Value {
    #[inline]
    fn from(v: UnicodeType) -> Self {
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GUriError")]
pub enum UriError {
    #[doc(alias = "G_URI_ERROR_FAILED")]
    Failed,
    #[doc(alias = "G_URI_ERROR_BAD_SCHEME")]
    BadScheme,
    #[doc(alias = "G_URI_ERROR_BAD_USER")]
    BadUser,
    #[doc(alias = "G_URI_ERROR_BAD_PASSWORD")]
    BadPassword,
    #[doc(alias = "G_URI_ERROR_BAD_AUTH_PARAMS")]
    BadAuthParams,
    #[doc(alias = "G_URI_ERROR_BAD_HOST")]
    BadHost,
    #[doc(alias = "G_URI_ERROR_BAD_PORT")]
    BadPort,
    #[doc(alias = "G_URI_ERROR_BAD_PATH")]
    BadPath,
    #[doc(alias = "G_URI_ERROR_BAD_QUERY")]
    BadQuery,
    #[doc(alias = "G_URI_ERROR_BAD_FRAGMENT")]
    BadFragment,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
#[doc(hidden)]
impl IntoGlib for UriError {
    type GlibType = ffi::GUriError;

    #[inline]
    fn into_glib(self) -> ffi::GUriError {
        match self {
            Self::Failed => ffi::G_URI_ERROR_FAILED,
            Self::BadScheme => ffi::G_URI_ERROR_BAD_SCHEME,
            Self::BadUser => ffi::G_URI_ERROR_BAD_USER,
            Self::BadPassword => ffi::G_URI_ERROR_BAD_PASSWORD,
            Self::BadAuthParams => ffi::G_URI_ERROR_BAD_AUTH_PARAMS,
            Self::BadHost => ffi::G_URI_ERROR_BAD_HOST,
            Self::BadPort => ffi::G_URI_ERROR_BAD_PORT,
            Self::BadPath => ffi::G_URI_ERROR_BAD_PATH,
            Self::BadQuery => ffi::G_URI_ERROR_BAD_QUERY,
            Self::BadFragment => ffi::G_URI_ERROR_BAD_FRAGMENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
#[doc(hidden)]
impl FromGlib<ffi::GUriError> for UriError {
    #[inline]
    unsafe fn from_glib(value: ffi::GUriError) -> Self {
        match value {
            ffi::G_URI_ERROR_FAILED => Self::Failed,
            ffi::G_URI_ERROR_BAD_SCHEME => Self::BadScheme,
            ffi::G_URI_ERROR_BAD_USER => Self::BadUser,
            ffi::G_URI_ERROR_BAD_PASSWORD => Self::BadPassword,
            ffi::G_URI_ERROR_BAD_AUTH_PARAMS => Self::BadAuthParams,
            ffi::G_URI_ERROR_BAD_HOST => Self::BadHost,
            ffi::G_URI_ERROR_BAD_PORT => Self::BadPort,
            ffi::G_URI_ERROR_BAD_PATH => Self::BadPath,
            ffi::G_URI_ERROR_BAD_QUERY => Self::BadQuery,
            ffi::G_URI_ERROR_BAD_FRAGMENT => Self::BadFragment,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
impl crate::error::ErrorDomain for UriError {
    #[inline]
    fn domain() -> crate::Quark {
        unsafe { from_glib(ffi::g_uri_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            Self::__Unknown(_) => Some(Self::Failed),
            value => Some(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GVariantClass")]
pub enum VariantClass {
    #[doc(alias = "G_VARIANT_CLASS_BOOLEAN")]
    Boolean,
    #[doc(alias = "G_VARIANT_CLASS_BYTE")]
    Byte,
    #[doc(alias = "G_VARIANT_CLASS_INT16")]
    Int16,
    #[doc(alias = "G_VARIANT_CLASS_UINT16")]
    Uint16,
    #[doc(alias = "G_VARIANT_CLASS_INT32")]
    Int32,
    #[doc(alias = "G_VARIANT_CLASS_UINT32")]
    Uint32,
    #[doc(alias = "G_VARIANT_CLASS_INT64")]
    Int64,
    #[doc(alias = "G_VARIANT_CLASS_UINT64")]
    Uint64,
    #[doc(alias = "G_VARIANT_CLASS_HANDLE")]
    Handle,
    #[doc(alias = "G_VARIANT_CLASS_DOUBLE")]
    Double,
    #[doc(alias = "G_VARIANT_CLASS_STRING")]
    String,
    #[doc(alias = "G_VARIANT_CLASS_OBJECT_PATH")]
    ObjectPath,
    #[doc(alias = "G_VARIANT_CLASS_SIGNATURE")]
    Signature,
    #[doc(alias = "G_VARIANT_CLASS_VARIANT")]
    Variant,
    #[doc(alias = "G_VARIANT_CLASS_MAYBE")]
    Maybe,
    #[doc(alias = "G_VARIANT_CLASS_ARRAY")]
    Array,
    #[doc(alias = "G_VARIANT_CLASS_TUPLE")]
    Tuple,
    #[doc(alias = "G_VARIANT_CLASS_DICT_ENTRY")]
    DictEntry,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VariantClass {
    type GlibType = ffi::GVariantClass;

    fn into_glib(self) -> ffi::GVariantClass {
        match self {
            Self::Boolean => ffi::G_VARIANT_CLASS_BOOLEAN,
            Self::Byte => ffi::G_VARIANT_CLASS_BYTE,
            Self::Int16 => ffi::G_VARIANT_CLASS_INT16,
            Self::Uint16 => ffi::G_VARIANT_CLASS_UINT16,
            Self::Int32 => ffi::G_VARIANT_CLASS_INT32,
            Self::Uint32 => ffi::G_VARIANT_CLASS_UINT32,
            Self::Int64 => ffi::G_VARIANT_CLASS_INT64,
            Self::Uint64 => ffi::G_VARIANT_CLASS_UINT64,
            Self::Handle => ffi::G_VARIANT_CLASS_HANDLE,
            Self::Double => ffi::G_VARIANT_CLASS_DOUBLE,
            Self::String => ffi::G_VARIANT_CLASS_STRING,
            Self::ObjectPath => ffi::G_VARIANT_CLASS_OBJECT_PATH,
            Self::Signature => ffi::G_VARIANT_CLASS_SIGNATURE,
            Self::Variant => ffi::G_VARIANT_CLASS_VARIANT,
            Self::Maybe => ffi::G_VARIANT_CLASS_MAYBE,
            Self::Array => ffi::G_VARIANT_CLASS_ARRAY,
            Self::Tuple => ffi::G_VARIANT_CLASS_TUPLE,
            Self::DictEntry => ffi::G_VARIANT_CLASS_DICT_ENTRY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GVariantClass> for VariantClass {
    unsafe fn from_glib(value: ffi::GVariantClass) -> Self {
        match value {
            ffi::G_VARIANT_CLASS_BOOLEAN => Self::Boolean,
            ffi::G_VARIANT_CLASS_BYTE => Self::Byte,
            ffi::G_VARIANT_CLASS_INT16 => Self::Int16,
            ffi::G_VARIANT_CLASS_UINT16 => Self::Uint16,
            ffi::G_VARIANT_CLASS_INT32 => Self::Int32,
            ffi::G_VARIANT_CLASS_UINT32 => Self::Uint32,
            ffi::G_VARIANT_CLASS_INT64 => Self::Int64,
            ffi::G_VARIANT_CLASS_UINT64 => Self::Uint64,
            ffi::G_VARIANT_CLASS_HANDLE => Self::Handle,
            ffi::G_VARIANT_CLASS_DOUBLE => Self::Double,
            ffi::G_VARIANT_CLASS_STRING => Self::String,
            ffi::G_VARIANT_CLASS_OBJECT_PATH => Self::ObjectPath,
            ffi::G_VARIANT_CLASS_SIGNATURE => Self::Signature,
            ffi::G_VARIANT_CLASS_VARIANT => Self::Variant,
            ffi::G_VARIANT_CLASS_MAYBE => Self::Maybe,
            ffi::G_VARIANT_CLASS_ARRAY => Self::Array,
            ffi::G_VARIANT_CLASS_TUPLE => Self::Tuple,
            ffi::G_VARIANT_CLASS_DICT_ENTRY => Self::DictEntry,
            value => Self::__Unknown(value),
        }
    }
}
