// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The encryption key used to encrypt this object.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct EncryptionKey {
    /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
    pub r#type: crate::types::EncryptionKeyType,
    /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
    pub id: ::std::string::String,
}
impl EncryptionKey {
    /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
    pub fn r#type(&self) -> &crate::types::EncryptionKeyType {
        &self.r#type
    }
    /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
    pub fn id(&self) -> &str {
        use std::ops::Deref;
        self.id.deref()
    }
}
impl EncryptionKey {
    /// Creates a new builder-style object to manufacture [`EncryptionKey`](crate::types::EncryptionKey).
    pub fn builder() -> crate::types::builders::EncryptionKeyBuilder {
        crate::types::builders::EncryptionKeyBuilder::default()
    }
}

/// A builder for [`EncryptionKey`](crate::types::EncryptionKey).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct EncryptionKeyBuilder {
    pub(crate) r#type: ::std::option::Option<crate::types::EncryptionKeyType>,
    pub(crate) id: ::std::option::Option<::std::string::String>,
}
impl EncryptionKeyBuilder {
    /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
    /// This field is required.
    pub fn r#type(mut self, input: crate::types::EncryptionKeyType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::EncryptionKeyType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::EncryptionKeyType> {
        &self.r#type
    }
    /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
    /// This field is required.
    pub fn id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
    pub fn set_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.id = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
    pub fn get_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.id
    }
    /// Consumes the builder and constructs a [`EncryptionKey`](crate::types::EncryptionKey).
    /// This method will fail if any of the following fields are not set:
    /// - [`r#type`](crate::types::builders::EncryptionKeyBuilder::r#type)
    /// - [`id`](crate::types::builders::EncryptionKeyBuilder::id)
    pub fn build(self) -> ::std::result::Result<crate::types::EncryptionKey, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::EncryptionKey {
            r#type: self.r#type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#type",
                    "r#type was not specified but it is required when building EncryptionKey",
                )
            })?,
            id: self.id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "id",
                    "id was not specified but it is required when building EncryptionKey",
                )
            })?,
        })
    }
}
