// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The content and content type of a document.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct Document {
    /// <p>The <code>Content</code>field type is Binary large object (blob). This object contains the document content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the Base64-encoding on this field before sending the request.</p>
    pub content: ::aws_smithy_types::Blob,
    /// <p>Describes the format of the document. You can specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text in the HTML element.</p></li>
    /// <li>
    /// <p><code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every character in the content.</p></li>
    /// <li>
    /// <p><code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data consists of a Word document (.docx).</p></li>
    /// </ul>
    pub content_type: ::std::string::String,
}
impl Document {
    /// <p>The <code>Content</code>field type is Binary large object (blob). This object contains the document content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the Base64-encoding on this field before sending the request.</p>
    pub fn content(&self) -> &::aws_smithy_types::Blob {
        &self.content
    }
    /// <p>Describes the format of the document. You can specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text in the HTML element.</p></li>
    /// <li>
    /// <p><code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every character in the content.</p></li>
    /// <li>
    /// <p><code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data consists of a Word document (.docx).</p></li>
    /// </ul>
    pub fn content_type(&self) -> &str {
        use std::ops::Deref;
        self.content_type.deref()
    }
}
impl ::std::fmt::Debug for Document {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("Document");
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
impl Document {
    /// Creates a new builder-style object to manufacture [`Document`](crate::types::Document).
    pub fn builder() -> crate::types::builders::DocumentBuilder {
        crate::types::builders::DocumentBuilder::default()
    }
}

/// A builder for [`Document`](crate::types::Document).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct DocumentBuilder {
    pub(crate) content: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) content_type: ::std::option::Option<::std::string::String>,
}
impl DocumentBuilder {
    /// <p>The <code>Content</code>field type is Binary large object (blob). This object contains the document content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the Base64-encoding on this field before sending the request.</p>
    /// This field is required.
    pub fn content(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.content = ::std::option::Option::Some(input);
        self
    }
    /// <p>The <code>Content</code>field type is Binary large object (blob). This object contains the document content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the Base64-encoding on this field before sending the request.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.content = input;
        self
    }
    /// <p>The <code>Content</code>field type is Binary large object (blob). This object contains the document content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the Base64-encoding on this field before sending the request.</p>
    pub fn get_content(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.content
    }
    /// <p>Describes the format of the document. You can specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text in the HTML element.</p></li>
    /// <li>
    /// <p><code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every character in the content.</p></li>
    /// <li>
    /// <p><code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data consists of a Word document (.docx).</p></li>
    /// </ul>
    /// This field is required.
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Describes the format of the document. You can specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text in the HTML element.</p></li>
    /// <li>
    /// <p><code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every character in the content.</p></li>
    /// <li>
    /// <p><code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data consists of a Word document (.docx).</p></li>
    /// </ul>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_type = input;
        self
    }
    /// <p>Describes the format of the document. You can specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text in the HTML element.</p></li>
    /// <li>
    /// <p><code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every character in the content.</p></li>
    /// <li>
    /// <p><code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data consists of a Word document (.docx).</p></li>
    /// </ul>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_type
    }
    /// Consumes the builder and constructs a [`Document`](crate::types::Document).
    /// This method will fail if any of the following fields are not set:
    /// - [`content`](crate::types::builders::DocumentBuilder::content)
    /// - [`content_type`](crate::types::builders::DocumentBuilder::content_type)
    pub fn build(self) -> ::std::result::Result<crate::types::Document, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Document {
            content: self.content.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "content",
                    "content was not specified but it is required when building Document",
                )
            })?,
            content_type: self.content_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "content_type",
                    "content_type was not specified but it is required when building Document",
                )
            })?,
        })
    }
}
impl ::std::fmt::Debug for DocumentBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentBuilder");
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
