// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::translate_document::_translate_document_output::TranslateDocumentOutputBuilder;

pub use crate::operation::translate_document::_translate_document_input::TranslateDocumentInputBuilder;

impl TranslateDocumentInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::translate_document::TranslateDocumentOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::translate_document::TranslateDocumentError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.translate_document();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `TranslateDocument`.
///
/// <p>Translates the input document from the source language to the target language. This synchronous operation supports text, HTML, or Word documents as the input document. <code>TranslateDocument</code> supports translations from English to any supported language, and from any supported language to English. Therefore, specify either the source language code or the target language code as “en” (English).</p>
/// <p>If you set the <code>Formality</code> parameter, the request will fail if the target language does not support formality. For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html">Setting formality</a>.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct TranslateDocumentFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::translate_document::builders::TranslateDocumentInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::translate_document::TranslateDocumentOutput,
        crate::operation::translate_document::TranslateDocumentError,
    > for TranslateDocumentFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::translate_document::TranslateDocumentOutput,
            crate::operation::translate_document::TranslateDocumentError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl TranslateDocumentFluentBuilder {
    /// Creates a new `TranslateDocument`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the TranslateDocument as a reference.
    pub fn as_input(&self) -> &crate::operation::translate_document::builders::TranslateDocumentInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::translate_document::TranslateDocumentOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::translate_document::TranslateDocumentError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::translate_document::TranslateDocument::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::translate_document::TranslateDocument::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::translate_document::TranslateDocumentOutput,
        crate::operation::translate_document::TranslateDocumentError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The content and content type for the document to be translated. The document size must not exceed 100 KB.</p>
    pub fn document(mut self, input: crate::types::Document) -> Self {
        self.inner = self.inner.document(input);
        self
    }
    /// <p>The content and content type for the document to be translated. The document size must not exceed 100 KB.</p>
    pub fn set_document(mut self, input: ::std::option::Option<crate::types::Document>) -> Self {
        self.inner = self.inner.set_document(input);
        self
    }
    /// <p>The content and content type for the document to be translated. The document size must not exceed 100 KB.</p>
    pub fn get_document(&self) -> &::std::option::Option<crate::types::Document> {
        self.inner.get_document()
    }
    /// Appends an item to `TerminologyNames`.
    ///
    /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
    ///
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn terminology_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.terminology_names(input.into());
        self
    }
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn set_terminology_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_terminology_names(input);
        self
    }
    /// <p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p>
    /// <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p>
    /// <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p>
    pub fn get_terminology_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_terminology_names()
    }
    /// <p>The language code for the language of the source text. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateDocument</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    pub fn source_language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.source_language_code(input.into());
        self
    }
    /// <p>The language code for the language of the source text. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateDocument</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    pub fn set_source_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_source_language_code(input);
        self
    }
    /// <p>The language code for the language of the source text. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>
    /// <p>If you specify <code>auto</code>, you must send the <code>TranslateDocument</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p>
    /// </note>
    pub fn get_source_language_code(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_source_language_code()
    }
    /// <p>The language code requested for the translated document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn target_language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.target_language_code(input.into());
        self
    }
    /// <p>The language code requested for the translated document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn set_target_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_target_language_code(input);
        self
    }
    /// <p>The language code requested for the translated document. For a list of supported language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    pub fn get_target_language_code(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_target_language_code()
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: not supported.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn settings(mut self, input: crate::types::TranslationSettings) -> Self {
        self.inner = self.inner.settings(input);
        self
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: not supported.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn set_settings(mut self, input: ::std::option::Option<crate::types::TranslationSettings>) -> Self {
        self.inner = self.inner.set_settings(input);
        self
    }
    /// <p>Settings to configure your translation output. You can configure the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Brevity: not supported.</p></li>
    /// <li>
    /// <p>Formality: sets the formality level of the output text.</p></li>
    /// <li>
    /// <p>Profanity: masks profane words and phrases in your translation output.</p></li>
    /// </ul>
    pub fn get_settings(&self) -> &::std::option::Option<crate::types::TranslationSettings> {
        self.inner.get_settings()
    }
}
