// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies when an object transitions to a specified storage class. For more information about Amazon S3 lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html">Transitioning Objects Using Amazon S3 Lifecycle</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Transition {
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub date: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub days: ::std::option::Option<i32>,
    /// <p>The storage class to which you want the object to transition.</p>
    pub storage_class: ::std::option::Option<crate::types::TransitionStorageClass>,
}
impl Transition {
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub fn date(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub fn days(&self) -> ::std::option::Option<i32> {
        self.days
    }
    /// <p>The storage class to which you want the object to transition.</p>
    pub fn storage_class(&self) -> ::std::option::Option<&crate::types::TransitionStorageClass> {
        self.storage_class.as_ref()
    }
}
impl Transition {
    /// Creates a new builder-style object to manufacture [`Transition`](crate::types::Transition).
    pub fn builder() -> crate::types::builders::TransitionBuilder {
        crate::types::builders::TransitionBuilder::default()
    }
}

/// A builder for [`Transition`](crate::types::Transition).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct TransitionBuilder {
    pub(crate) date: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) days: ::std::option::Option<i32>,
    pub(crate) storage_class: ::std::option::Option<crate::types::TransitionStorageClass>,
}
impl TransitionBuilder {
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub fn date(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.date = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub fn set_date(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.date = input;
        self
    }
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub fn get_date(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.date
    }
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub fn days(mut self, input: i32) -> Self {
        self.days = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub fn set_days(mut self, input: ::std::option::Option<i32>) -> Self {
        self.days = input;
        self
    }
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub fn get_days(&self) -> &::std::option::Option<i32> {
        &self.days
    }
    /// <p>The storage class to which you want the object to transition.</p>
    pub fn storage_class(mut self, input: crate::types::TransitionStorageClass) -> Self {
        self.storage_class = ::std::option::Option::Some(input);
        self
    }
    /// <p>The storage class to which you want the object to transition.</p>
    pub fn set_storage_class(mut self, input: ::std::option::Option<crate::types::TransitionStorageClass>) -> Self {
        self.storage_class = input;
        self
    }
    /// <p>The storage class to which you want the object to transition.</p>
    pub fn get_storage_class(&self) -> &::std::option::Option<crate::types::TransitionStorageClass> {
        &self.storage_class
    }
    /// Consumes the builder and constructs a [`Transition`](crate::types::Transition).
    pub fn build(self) -> crate::types::Transition {
        crate::types::Transition {
            date: self.date,
            days: self.days,
            storage_class: self.storage_class,
        }
    }
}
