// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct Ssekms {
    /// <p>Specifies the ID of the Key Management Service (KMS) symmetric encryption customer managed key to use for encrypting inventory reports.</p>
    pub key_id: ::std::string::String,
}
impl Ssekms {
    /// <p>Specifies the ID of the Key Management Service (KMS) symmetric encryption customer managed key to use for encrypting inventory reports.</p>
    pub fn key_id(&self) -> &str {
        use std::ops::Deref;
        self.key_id.deref()
    }
}
impl ::std::fmt::Debug for Ssekms {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("Ssekms");
        formatter.field("key_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl Ssekms {
    /// Creates a new builder-style object to manufacture [`Ssekms`](crate::types::Ssekms).
    pub fn builder() -> crate::types::builders::SsekmsBuilder {
        crate::types::builders::SsekmsBuilder::default()
    }
}

/// A builder for [`Ssekms`](crate::types::Ssekms).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct SsekmsBuilder {
    pub(crate) key_id: ::std::option::Option<::std::string::String>,
}
impl SsekmsBuilder {
    /// <p>Specifies the ID of the Key Management Service (KMS) symmetric encryption customer managed key to use for encrypting inventory reports.</p>
    /// This field is required.
    pub fn key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the ID of the Key Management Service (KMS) symmetric encryption customer managed key to use for encrypting inventory reports.</p>
    pub fn set_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_id = input;
        self
    }
    /// <p>Specifies the ID of the Key Management Service (KMS) symmetric encryption customer managed key to use for encrypting inventory reports.</p>
    pub fn get_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_id
    }
    /// Consumes the builder and constructs a [`Ssekms`](crate::types::Ssekms).
    /// This method will fail if any of the following fields are not set:
    /// - [`key_id`](crate::types::builders::SsekmsBuilder::key_id)
    pub fn build(self) -> ::std::result::Result<crate::types::Ssekms, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Ssekms {
            key_id: self.key_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "key_id",
                    "key_id was not specified but it is required when building Ssekms",
                )
            })?,
        })
    }
}
impl ::std::fmt::Debug for SsekmsBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("SsekmsBuilder");
        formatter.field("key_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
