// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ScanRange {
    /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only <code>start</code> is supplied, it means scan from that point to the end of the file. For example, <code><scanrange>
    /// <start>
    /// 50
    /// </start>
    /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
    pub start: ::std::option::Option<i64>,
    /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code><scanrange>
    /// <end>
    /// 50
    /// </end>
    /// </scanrange></code> means scan the last 50 bytes.</p>
    pub end: ::std::option::Option<i64>,
}
impl ScanRange {
    /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only <code>start</code> is supplied, it means scan from that point to the end of the file. For example, <code><scanrange>
    /// <start>
    /// 50
    /// </start>
    /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
    pub fn start(&self) -> ::std::option::Option<i64> {
        self.start
    }
    /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code><scanrange>
    /// <end>
    /// 50
    /// </end>
    /// </scanrange></code> means scan the last 50 bytes.</p>
    pub fn end(&self) -> ::std::option::Option<i64> {
        self.end
    }
}
impl ScanRange {
    /// Creates a new builder-style object to manufacture [`ScanRange`](crate::types::ScanRange).
    pub fn builder() -> crate::types::builders::ScanRangeBuilder {
        crate::types::builders::ScanRangeBuilder::default()
    }
}

/// A builder for [`ScanRange`](crate::types::ScanRange).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ScanRangeBuilder {
    pub(crate) start: ::std::option::Option<i64>,
    pub(crate) end: ::std::option::Option<i64>,
}
impl ScanRangeBuilder {
    /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only <code>start</code> is supplied, it means scan from that point to the end of the file. For example, <code><scanrange>
    /// <start>
    /// 50
    /// </start>
    /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
    pub fn start(mut self, input: i64) -> Self {
        self.start = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only <code>start</code> is supplied, it means scan from that point to the end of the file. For example, <code><scanrange>
    /// <start>
    /// 50
    /// </start>
    /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
    pub fn set_start(mut self, input: ::std::option::Option<i64>) -> Self {
        self.start = input;
        self
    }
    /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only <code>start</code> is supplied, it means scan from that point to the end of the file. For example, <code><scanrange>
    /// <start>
    /// 50
    /// </start>
    /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
    pub fn get_start(&self) -> &::std::option::Option<i64> {
        &self.start
    }
    /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code><scanrange>
    /// <end>
    /// 50
    /// </end>
    /// </scanrange></code> means scan the last 50 bytes.</p>
    pub fn end(mut self, input: i64) -> Self {
        self.end = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code><scanrange>
    /// <end>
    /// 50
    /// </end>
    /// </scanrange></code> means scan the last 50 bytes.</p>
    pub fn set_end(mut self, input: ::std::option::Option<i64>) -> Self {
        self.end = input;
        self
    }
    /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code><scanrange>
    /// <end>
    /// 50
    /// </end>
    /// </scanrange></code> means scan the last 50 bytes.</p>
    pub fn get_end(&self) -> &::std::option::Option<i64> {
        &self.end
    }
    /// Consumes the builder and constructs a [`ScanRange`](crate::types::ScanRange).
    pub fn build(self) -> crate::types::ScanRange {
        crate::types::ScanRange {
            start: self.start,
            end: self.end,
        }
    }
}
