// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object consists of data and its descriptive metadata.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Object {
    /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
    pub key: ::std::option::Option<::std::string::String>,
    /// <p>Creation date of the object.</p>
    pub last_modified: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
    /// <ul>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption. If an object is larger than 16 MB, the Amazon Web Services Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest.</p></li>
    /// </ul><note>
    /// <p><b>Directory buckets</b> - MD5 is not supported by directory buckets.</p>
    /// </note>
    pub e_tag: ::std::option::Option<::std::string::String>,
    /// <p>The algorithm that was used to create a checksum of the object.</p>
    pub checksum_algorithm: ::std::option::Option<::std::vec::Vec<crate::types::ChecksumAlgorithm>>,
    /// <p>Size in bytes of the object</p>
    pub size: ::std::option::Option<i64>,
    /// <p>The class of storage used to store the object.</p><note>
    /// <p><b>Directory buckets</b> - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub storage_class: ::std::option::Option<crate::types::ObjectStorageClass>,
    /// <p>The owner of the object</p><note>
    /// <p><b>Directory buckets</b> - The bucket owner is returned as the object owner.</p>
    /// </note>
    pub owner: ::std::option::Option<crate::types::Owner>,
    /// <p>Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html"> Working with archived objects</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub restore_status: ::std::option::Option<crate::types::RestoreStatus>,
}
impl Object {
    /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
    pub fn key(&self) -> ::std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Creation date of the object.</p>
    pub fn last_modified(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
    /// <ul>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption. If an object is larger than 16 MB, the Amazon Web Services Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest.</p></li>
    /// </ul><note>
    /// <p><b>Directory buckets</b> - MD5 is not supported by directory buckets.</p>
    /// </note>
    pub fn e_tag(&self) -> ::std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>The algorithm that was used to create a checksum of the object.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.checksum_algorithm.is_none()`.
    pub fn checksum_algorithm(&self) -> &[crate::types::ChecksumAlgorithm] {
        self.checksum_algorithm.as_deref().unwrap_or_default()
    }
    /// <p>Size in bytes of the object</p>
    pub fn size(&self) -> ::std::option::Option<i64> {
        self.size
    }
    /// <p>The class of storage used to store the object.</p><note>
    /// <p><b>Directory buckets</b> - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn storage_class(&self) -> ::std::option::Option<&crate::types::ObjectStorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>The owner of the object</p><note>
    /// <p><b>Directory buckets</b> - The bucket owner is returned as the object owner.</p>
    /// </note>
    pub fn owner(&self) -> ::std::option::Option<&crate::types::Owner> {
        self.owner.as_ref()
    }
    /// <p>Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html"> Working with archived objects</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn restore_status(&self) -> ::std::option::Option<&crate::types::RestoreStatus> {
        self.restore_status.as_ref()
    }
}
impl Object {
    /// Creates a new builder-style object to manufacture [`Object`](crate::types::Object).
    pub fn builder() -> crate::types::builders::ObjectBuilder {
        crate::types::builders::ObjectBuilder::default()
    }
}

/// A builder for [`Object`](crate::types::Object).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ObjectBuilder {
    pub(crate) key: ::std::option::Option<::std::string::String>,
    pub(crate) last_modified: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) e_tag: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_algorithm: ::std::option::Option<::std::vec::Vec<crate::types::ChecksumAlgorithm>>,
    pub(crate) size: ::std::option::Option<i64>,
    pub(crate) storage_class: ::std::option::Option<crate::types::ObjectStorageClass>,
    pub(crate) owner: ::std::option::Option<crate::types::Owner>,
    pub(crate) restore_status: ::std::option::Option<crate::types::RestoreStatus>,
}
impl ObjectBuilder {
    /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
    pub fn key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
    pub fn set_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key = input;
        self
    }
    /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
    pub fn get_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.key
    }
    /// <p>Creation date of the object.</p>
    pub fn last_modified(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_modified = ::std::option::Option::Some(input);
        self
    }
    /// <p>Creation date of the object.</p>
    pub fn set_last_modified(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_modified = input;
        self
    }
    /// <p>Creation date of the object.</p>
    pub fn get_last_modified(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_modified
    }
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
    /// <ul>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption. If an object is larger than 16 MB, the Amazon Web Services Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest.</p></li>
    /// </ul><note>
    /// <p><b>Directory buckets</b> - MD5 is not supported by directory buckets.</p>
    /// </note>
    pub fn e_tag(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.e_tag = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
    /// <ul>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption. If an object is larger than 16 MB, the Amazon Web Services Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest.</p></li>
    /// </ul><note>
    /// <p><b>Directory buckets</b> - MD5 is not supported by directory buckets.</p>
    /// </note>
    pub fn set_e_tag(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.e_tag = input;
        self
    }
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
    /// <ul>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p></li>
    /// <li>
    /// <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption. If an object is larger than 16 MB, the Amazon Web Services Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest.</p></li>
    /// </ul><note>
    /// <p><b>Directory buckets</b> - MD5 is not supported by directory buckets.</p>
    /// </note>
    pub fn get_e_tag(&self) -> &::std::option::Option<::std::string::String> {
        &self.e_tag
    }
    /// Appends an item to `checksum_algorithm`.
    ///
    /// To override the contents of this collection use [`set_checksum_algorithm`](Self::set_checksum_algorithm).
    ///
    /// <p>The algorithm that was used to create a checksum of the object.</p>
    pub fn checksum_algorithm(mut self, input: crate::types::ChecksumAlgorithm) -> Self {
        let mut v = self.checksum_algorithm.unwrap_or_default();
        v.push(input);
        self.checksum_algorithm = ::std::option::Option::Some(v);
        self
    }
    /// <p>The algorithm that was used to create a checksum of the object.</p>
    pub fn set_checksum_algorithm(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::ChecksumAlgorithm>>) -> Self {
        self.checksum_algorithm = input;
        self
    }
    /// <p>The algorithm that was used to create a checksum of the object.</p>
    pub fn get_checksum_algorithm(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ChecksumAlgorithm>> {
        &self.checksum_algorithm
    }
    /// <p>Size in bytes of the object</p>
    pub fn size(mut self, input: i64) -> Self {
        self.size = ::std::option::Option::Some(input);
        self
    }
    /// <p>Size in bytes of the object</p>
    pub fn set_size(mut self, input: ::std::option::Option<i64>) -> Self {
        self.size = input;
        self
    }
    /// <p>Size in bytes of the object</p>
    pub fn get_size(&self) -> &::std::option::Option<i64> {
        &self.size
    }
    /// <p>The class of storage used to store the object.</p><note>
    /// <p><b>Directory buckets</b> - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn storage_class(mut self, input: crate::types::ObjectStorageClass) -> Self {
        self.storage_class = ::std::option::Option::Some(input);
        self
    }
    /// <p>The class of storage used to store the object.</p><note>
    /// <p><b>Directory buckets</b> - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn set_storage_class(mut self, input: ::std::option::Option<crate::types::ObjectStorageClass>) -> Self {
        self.storage_class = input;
        self
    }
    /// <p>The class of storage used to store the object.</p><note>
    /// <p><b>Directory buckets</b> - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn get_storage_class(&self) -> &::std::option::Option<crate::types::ObjectStorageClass> {
        &self.storage_class
    }
    /// <p>The owner of the object</p><note>
    /// <p><b>Directory buckets</b> - The bucket owner is returned as the object owner.</p>
    /// </note>
    pub fn owner(mut self, input: crate::types::Owner) -> Self {
        self.owner = ::std::option::Option::Some(input);
        self
    }
    /// <p>The owner of the object</p><note>
    /// <p><b>Directory buckets</b> - The bucket owner is returned as the object owner.</p>
    /// </note>
    pub fn set_owner(mut self, input: ::std::option::Option<crate::types::Owner>) -> Self {
        self.owner = input;
        self
    }
    /// <p>The owner of the object</p><note>
    /// <p><b>Directory buckets</b> - The bucket owner is returned as the object owner.</p>
    /// </note>
    pub fn get_owner(&self) -> &::std::option::Option<crate::types::Owner> {
        &self.owner
    }
    /// <p>Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html"> Working with archived objects</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn restore_status(mut self, input: crate::types::RestoreStatus) -> Self {
        self.restore_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html"> Working with archived objects</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn set_restore_status(mut self, input: ::std::option::Option<crate::types::RestoreStatus>) -> Self {
        self.restore_status = input;
        self
    }
    /// <p>Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html"> Working with archived objects</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p>
    /// </note>
    pub fn get_restore_status(&self) -> &::std::option::Option<crate::types::RestoreStatus> {
        &self.restore_status
    }
    /// Consumes the builder and constructs a [`Object`](crate::types::Object).
    pub fn build(self) -> crate::types::Object {
        crate::types::Object {
            key: self.key,
            last_modified: self.last_modified,
            e_tag: self.e_tag,
            checksum_algorithm: self.checksum_algorithm,
            size: self.size,
            storage_class: self.storage_class,
            owner: self.owner,
            restore_status: self.restore_status,
        }
    }
}
