// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the Amazon S3 object key name to filter on. An object key name is the name assigned to an object in your Amazon S3 bucket. You specify whether to filter on the suffix or prefix of the object key name. A prefix is a specific string of characters at the beginning of an object key name, which you can use to organize objects. For example, you can start the key names of related objects with a prefix, such as <code>2023-</code> or <code>engineering/</code>. Then, you can use <code>FilterRule</code> to find objects in a bucket with key names that have the same prefix. A suffix is similar to a prefix, but it is at the end of the object key name instead of at the beginning.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct FilterRule {
    /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub name: ::std::option::Option<crate::types::FilterRuleName>,
    /// <p>The value that the filter searches for in object key names.</p>
    pub value: ::std::option::Option<::std::string::String>,
}
impl FilterRule {
    /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn name(&self) -> ::std::option::Option<&crate::types::FilterRuleName> {
        self.name.as_ref()
    }
    /// <p>The value that the filter searches for in object key names.</p>
    pub fn value(&self) -> ::std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl FilterRule {
    /// Creates a new builder-style object to manufacture [`FilterRule`](crate::types::FilterRule).
    pub fn builder() -> crate::types::builders::FilterRuleBuilder {
        crate::types::builders::FilterRuleBuilder::default()
    }
}

/// A builder for [`FilterRule`](crate::types::FilterRule).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct FilterRuleBuilder {
    pub(crate) name: ::std::option::Option<crate::types::FilterRuleName>,
    pub(crate) value: ::std::option::Option<::std::string::String>,
}
impl FilterRuleBuilder {
    /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn name(mut self, input: crate::types::FilterRuleName) -> Self {
        self.name = ::std::option::Option::Some(input);
        self
    }
    /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_name(mut self, input: ::std::option::Option<crate::types::FilterRuleName>) -> Self {
        self.name = input;
        self
    }
    /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_name(&self) -> &::std::option::Option<crate::types::FilterRuleName> {
        &self.name
    }
    /// <p>The value that the filter searches for in object key names.</p>
    pub fn value(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.value = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The value that the filter searches for in object key names.</p>
    pub fn set_value(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.value = input;
        self
    }
    /// <p>The value that the filter searches for in object key names.</p>
    pub fn get_value(&self) -> &::std::option::Option<::std::string::String> {
        &self.value
    }
    /// Consumes the builder and constructs a [`FilterRule`](crate::types::FilterRule).
    pub fn build(self) -> crate::types::FilterRule {
        crate::types::FilterRule {
            name: self.name,
            value: self.value,
        }
    }
}
