// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutBucketReplication`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::set_content_md5):<br>required: **false**<br><p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p> <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p><br>
    ///   - [`replication_configuration(ReplicationConfiguration)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::replication_configuration) / [`set_replication_configuration(Option<ReplicationConfiguration>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::set_replication_configuration):<br>required: **true**<br><p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p><br>
    ///   - [`token(impl Into<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::token) / [`set_token(Option<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::set_token):<br>required: **false**<br><p>A token to allow Object Lock to be enabled for an existing bucket.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`PutBucketReplicationOutput`](crate::operation::put_bucket_replication::PutBucketReplicationOutput)
    /// - On failure, responds with [`SdkError<PutBucketReplicationError>`](crate::operation::put_bucket_replication::PutBucketReplicationError)
    pub fn put_bucket_replication(&self) -> crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder {
        crate::operation::put_bucket_replication::builders::PutBucketReplicationFluentBuilder::new(self.handle.clone())
    }
}
