// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::update_media_storage_configuration::_update_media_storage_configuration_output::UpdateMediaStorageConfigurationOutputBuilder;

pub use crate::operation::update_media_storage_configuration::_update_media_storage_configuration_input::UpdateMediaStorageConfigurationInputBuilder;

impl UpdateMediaStorageConfigurationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.update_media_storage_configuration();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `UpdateMediaStorageConfiguration`.
///
/// <p>Associates a <code>SignalingChannel</code> to a stream to store the media. There are two signaling modes that you can specify :</p>
/// <ul>
/// <li>
/// <p>If <code>StorageStatus</code> is enabled, the data will be stored in the <code>StreamARN</code> provided. In order for WebRTC Ingestion to work, the stream must have data retention enabled.</p></li>
/// <li>
/// <p>If <code>StorageStatus</code> is disabled, no data will be stored, and the <code>StreamARN</code> parameter will not be needed.</p></li>
/// </ul><important>
/// <p>If <code>StorageStatus</code> is enabled, direct peer-to-peer (master-viewer) connections no longer occur. Peers connect directly to the storage session. You must call the <code>JoinStorageSession</code> API to trigger an SDP offer send and establish a connection between a peer and the storage session.</p>
/// </important>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct UpdateMediaStorageConfigurationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::update_media_storage_configuration::builders::UpdateMediaStorageConfigurationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationOutput,
        crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError,
    > for UpdateMediaStorageConfigurationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationOutput,
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl UpdateMediaStorageConfigurationFluentBuilder {
    /// Creates a new `UpdateMediaStorageConfiguration`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the UpdateMediaStorageConfiguration as a reference.
    pub fn as_input(&self) -> &crate::operation::update_media_storage_configuration::builders::UpdateMediaStorageConfigurationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::update_media_storage_configuration::UpdateMediaStorageConfiguration::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::update_media_storage_configuration::UpdateMediaStorageConfiguration::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationOutput,
        crate::operation::update_media_storage_configuration::UpdateMediaStorageConfigurationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the channel.</p>
    pub fn channel_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.channel_arn(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the channel.</p>
    pub fn set_channel_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_channel_arn(input);
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the channel.</p>
    pub fn get_channel_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_channel_arn()
    }
    /// <p>A structure that encapsulates, or contains, the media storage configuration properties.</p>
    pub fn media_storage_configuration(mut self, input: crate::types::MediaStorageConfiguration) -> Self {
        self.inner = self.inner.media_storage_configuration(input);
        self
    }
    /// <p>A structure that encapsulates, or contains, the media storage configuration properties.</p>
    pub fn set_media_storage_configuration(mut self, input: ::std::option::Option<crate::types::MediaStorageConfiguration>) -> Self {
        self.inner = self.inner.set_media_storage_configuration(input);
        self
    }
    /// <p>A structure that encapsulates, or contains, the media storage configuration properties.</p>
    pub fn get_media_storage_configuration(&self) -> &::std::option::Option<crate::types::MediaStorageConfiguration> {
        self.inner.get_media_storage_configuration()
    }
}
