// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListEdgeAgentConfigurationsInput {
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    pub hub_device_arn: ::std::option::Option<::std::string::String>,
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub max_results: ::std::option::Option<i32>,
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
}
impl ListEdgeAgentConfigurationsInput {
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    pub fn hub_device_arn(&self) -> ::std::option::Option<&str> {
        self.hub_device_arn.as_deref()
    }
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub fn max_results(&self) -> ::std::option::Option<i32> {
        self.max_results
    }
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl ListEdgeAgentConfigurationsInput {
    /// Creates a new builder-style object to manufacture [`ListEdgeAgentConfigurationsInput`](crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsInput).
    pub fn builder() -> crate::operation::list_edge_agent_configurations::builders::ListEdgeAgentConfigurationsInputBuilder {
        crate::operation::list_edge_agent_configurations::builders::ListEdgeAgentConfigurationsInputBuilder::default()
    }
}

/// A builder for [`ListEdgeAgentConfigurationsInput`](crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ListEdgeAgentConfigurationsInputBuilder {
    pub(crate) hub_device_arn: ::std::option::Option<::std::string::String>,
    pub(crate) max_results: ::std::option::Option<i32>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
}
impl ListEdgeAgentConfigurationsInputBuilder {
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    /// This field is required.
    pub fn hub_device_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.hub_device_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    pub fn set_hub_device_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.hub_device_arn = input;
        self
    }
    /// <p>The "Internet of Things (IoT) Thing" Arn of the edge agent.</p>
    pub fn get_hub_device_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.hub_device_arn
    }
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub fn max_results(mut self, input: i32) -> Self {
        self.max_results = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub fn set_max_results(mut self, input: ::std::option::Option<i32>) -> Self {
        self.max_results = input;
        self
    }
    /// <p>The maximum number of edge configurations to return in the response. The default is 5.</p>
    pub fn get_max_results(&self) -> &::std::option::Option<i32> {
        &self.max_results
    }
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge configurations, provide this token in your next request.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    /// Consumes the builder and constructs a [`ListEdgeAgentConfigurationsInput`](crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::list_edge_agent_configurations::ListEdgeAgentConfigurationsInput {
            hub_device_arn: self.hub_device_arn,
            max_results: self.max_results,
            next_token: self.next_token,
        })
    }
}
