/*
 * livepatch_bsc1235769
 *
 * Fix for CVE-2024-57793, bsc#1235769
 *
 *  Upstream commit:
 *  27834971f616 ("virt: tdx-guest: Just leak decrypted memory on unrecoverable errors")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP3 commit:
 *  Not affected
 *
 *  SLE15-SP4 and -SP5 commit:
 *  Not affected
 *
 *  SLE15-SP6 commit:
 *  0fbd2e184ff4d63a526332da09f3b93f3abfd722
 *
 *  SLE MICRO-6-0 commit:
 *  0fbd2e184ff4d63a526332da09f3b93f3abfd722
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Fernando Gonzalez <fernando.gonzalez@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_TDX_GUEST_DRIVER)

#if !IS_MODULE(CONFIG_TDX_GUEST_DRIVER)
#error "Live patch supports only CONFIG=m"
#endif

/* klp-ccp: from drivers/virt/coco/tdx-guest/tdx-guest.c */
#include <linux/kernel.h>
#include <linux/miscdevice.h>

#include <linux/mm.h>

/* klp-ccp: from include/linux/sizes.h */
#define __LINUX_SIZES_H__

#define SZ_8K				0x00002000

/* klp-ccp: from include/linux/mm.h */
#define PAGE_ALIGN(addr) ALIGN(addr, PAGE_SIZE)

/* klp-ccp: from drivers/virt/coco/tdx-guest/tdx-guest.c */
#include <linux/mod_devicetable.h>
#include <linux/string.h>
#include <linux/uaccess.h>
#include <linux/set_memory.h>
#include <linux/tsm.h>
#include <linux/sizes.h>
#include <asm/cpu_device_id.h>

#define GET_QUOTE_BUF_SIZE		SZ_8K

extern void *quote_data;

extern void free_quote_buf(void *buf);

static void *klpp_alloc_quote_buf(void)
{
	size_t len = PAGE_ALIGN(GET_QUOTE_BUF_SIZE);
	unsigned int count = len >> PAGE_SHIFT;
	void *addr;

	addr = alloc_pages_exact(len, GFP_KERNEL | __GFP_ZERO);
	if (!addr)
		return NULL;

	if (set_memory_decrypted((unsigned long)addr, count))
		return NULL;

	return addr;
}

extern struct miscdevice tdx_misc_dev;

extern const struct x86_cpu_id tdx_guest_ids[];

extern const struct tsm_ops tdx_tsm_ops;

int klpp_tdx_guest_init(void)
{
	int ret;

	if (!x86_match_cpu(tdx_guest_ids))
		return -ENODEV;

	ret = misc_register(&tdx_misc_dev);
	if (ret)
		return ret;

	quote_data = klpp_alloc_quote_buf();
	if (!quote_data) {
		pr_err("Failed to allocate Quote buffer\n");
		ret = -ENOMEM;
		goto free_misc;
	}

	ret = tsm_register(&tdx_tsm_ops, NULL, NULL);
	if (ret)
		goto free_quote;

	return 0;

free_quote:
	free_quote_buf(quote_data);
free_misc:
	misc_deregister(&tdx_misc_dev);

	return ret;
}


#include "livepatch_bsc1235769.h"

#include <linux/livepatch.h>

extern typeof(free_quote_buf) free_quote_buf
	 KLP_RELOC_SYMBOL(tdx_guest, tdx_guest, free_quote_buf);
extern typeof(quote_data) quote_data
	 KLP_RELOC_SYMBOL(tdx_guest, tdx_guest, quote_data);
extern typeof(tdx_guest_ids) tdx_guest_ids
	 KLP_RELOC_SYMBOL(tdx_guest, tdx_guest, tdx_guest_ids);
extern typeof(tdx_misc_dev) tdx_misc_dev
	 KLP_RELOC_SYMBOL(tdx_guest, tdx_guest, tdx_misc_dev);
extern typeof(tdx_tsm_ops) tdx_tsm_ops
	 KLP_RELOC_SYMBOL(tdx_guest, tdx_guest, tdx_tsm_ops);
extern typeof(tsm_register) tsm_register
	 KLP_RELOC_SYMBOL(tdx_guest, tsm, tsm_register);


#endif /* IS_ENABLED(CONFIG_TDX_GUEST_DRIVER) */
