/*
 * livepatch_bsc1235129
 *
 * Fix for CVE-2024-56582, bsc#1235129
 *
 *  Upstream commit:
 *  05b36b04d74a ("btrfs: fix use-after-free in btrfs_encoded_read_endio()")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP3 commit:
 *  Not affected
 *
 *  SLE15-SP4 and -SP5 commit:
 *  Not affected
 *
 *  SLE15-SP6 commit:
 *  03199cadc403b1fb952dd888dcc87eac23de7de9
 *
 *  SLE MICRO-6-0 commit:
 *  03199cadc403b1fb952dd888dcc87eac23de7de9
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Marco Crivellari <marco.crivellari@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* klp-ccp: from fs/btrfs/inode.c */
#include <crypto/hash.h>
#include <linux/kernel.h>
#include <linux/bio.h>

#include <linux/fs.h>

/* klp-ccp: from include/linux/pagemap.h */
#define _LINUX_PAGEMAP_H

/* klp-ccp: from fs/btrfs/inode.c */
#include <linux/highmem.h>
#include <linux/time.h>
#include <linux/init.h>
#include <linux/string.h>

/* klp-ccp: from include/linux/backing-dev.h */
#define _LINUX_BACKING_DEV_H

/* klp-ccp: from include/linux/writeback.h */
#define WRITEBACK_H

/* klp-ccp: from fs/btrfs/inode.c */
#include <linux/writeback.h>
#include <linux/compat.h>

/* klp-ccp: from include/linux/xattr.h */
#define _LINUX_XATTR_H

/* klp-ccp: from fs/btrfs/inode.c */
#include <linux/slab.h>
#include <linux/ratelimit.h>
#include <linux/btrfs.h>

/* klp-ccp: from include/linux/blkdev.h */
#define _LINUX_BLKDEV_H

/* klp-ccp: from fs/btrfs/inode.c */
#include <linux/uio.h>
#include <linux/magic.h>

#include <linux/sched/mm.h>

/* klp-ccp: from include/linux/iomap.h */
#define LINUX_IOMAP_H 1

/* klp-ccp: from include/asm-generic/unaligned.h */
#define __ASM_GENERIC_UNALIGNED_H

/* klp-ccp: from fs/btrfs/misc.h */
#include <linux/sched.h>
#include <linux/wait.h>
#include <linux/math64.h>
#include <linux/rbtree.h>

/* klp-ccp: from fs/btrfs/ctree.h */
#include <linux/mm.h>
#include <linux/sched/signal.h>
#include <linux/highmem.h>
#include <linux/fs.h>
#include <linux/rwsem.h>
#include <linux/semaphore.h>
#include <linux/completion.h>
#include <linux/backing-dev.h>
#include <linux/wait.h>
#include <linux/slab.h>

#include <asm/unaligned.h>
#include <linux/pagemap.h>
#include <linux/btrfs.h>
#include <linux/btrfs_tree.h>
#include <linux/workqueue.h>

#include <linux/sizes.h>
#include <linux/dynamic_debug.h>
#include <linux/refcount.h>

#include <linux/iomap.h>

/* klp-ccp: from fs/btrfs/extent_io.h */
#include <linux/rbtree.h>
#include <linux/refcount.h>

#include <linux/btrfs_tree.h>

/* klp-ccp: from fs/btrfs/compression.h */
#include <linux/sizes.h>
/* klp-ccp: from fs/btrfs/bio.h */
#include <linux/bio.h>
#include <linux/workqueue.h>

/* klp-ccp: from fs/btrfs/tree-checker.h */
#include <uapi/linux/btrfs_tree.h>

struct btrfs_tree_parent_check {
	/*
	 * The owner check against the tree block.
	 *
	 * Can be 0 to skip the owner check.
	 */
	u64 owner_root;

	/*
	 * Expected transid, can be 0 to skip the check, but such skip
	 * should only be utlized for backref walk related code.
	 */
	u64 transid;

	/*
	 * The expected first key.
	 *
	 * This check can be skipped if @has_first_key is false, such skip
	 * can happen for case where we don't have the parent node key,
	 * e.g. reading the tree root, doing backref walk.
	 */
	struct btrfs_key first_key;
	bool has_first_key;

	/* The expected level. Should always be set. */
	u8 level;
};

/* klp-ccp: from fs/btrfs/bio.h */
struct btrfs_bio;

#define BTRFS_BIO_INLINE_CSUM_SIZE	64

typedef void (*btrfs_bio_end_io_t)(struct btrfs_bio *bbio);

struct btrfs_bio {
	/*
	 * Inode and offset into it that this I/O operates on.
	 * Only set for data I/O.
	 */
	struct btrfs_inode *inode;
	u64 file_offset;

	union {
		/*
		 * For data reads: checksumming and original I/O information.
		 * (for internal use in the btrfs_submit_bio machinery only)
		 */
		struct {
			u8 *csum;
			u8 csum_inline[BTRFS_BIO_INLINE_CSUM_SIZE];
			struct bvec_iter saved_iter;
		};

		/*
		 * For data writes:
		 * - ordered extent covering the bio
		 * - pointer to the checksums for this bio
		 * - original physical address from the allocator
		 *   (for zone append only)
		 */
		struct {
			struct btrfs_ordered_extent *ordered;
			struct btrfs_ordered_sum *sums;
			u64 orig_physical;
		};

		/* For metadata reads: parentness verification. */
		struct btrfs_tree_parent_check parent_check;
	};

	/* End I/O information supplied to btrfs_bio_alloc */
	btrfs_bio_end_io_t end_io;
	void *private;

	/* For internal use in read end I/O handling */
	unsigned int mirror_num;
	atomic_t pending_ios;
	struct work_struct end_io_work;

	/* File system that this I/O operates on. */
	struct btrfs_fs_info *fs_info;

	/*
	 * This member must come last, bio_alloc_bioset will allocate enough
	 * bytes for entire btrfs_bio but relies on bio being last.
	 */
	struct bio bio;
};

/* klp-ccp: from fs/btrfs/ulist.h */
#include <linux/list.h>
#include <linux/rbtree.h>

/* klp-ccp: from fs/btrfs/extent_map.h */
#include <linux/rbtree.h>
#include <linux/refcount.h>

/* klp-ccp: from fs/btrfs/async-thread.h */
#include <linux/workqueue.h>
/* klp-ccp: from fs/btrfs/locking.h */
#include <linux/atomic.h>
#include <linux/wait.h>
#include <linux/percpu_counter.h>

/* klp-ccp: from fs/btrfs/fs.h */
#include <linux/blkdev.h>
#include <linux/fs.h>
#include <linux/btrfs_tree.h>
#include <linux/sizes.h>

/* klp-ccp: from fs/btrfs/transaction.h */
#include <linux/refcount.h>
/* klp-ccp: from fs/btrfs/btrfs_inode.h */
#include <linux/hash.h>
#include <linux/refcount.h>

/* klp-ccp: from fs/btrfs/delayed-inode.h */
#include <linux/rbtree.h>
#include <linux/spinlock.h>
#include <linux/mutex.h>
#include <linux/list.h>
#include <linux/wait.h>
#include <linux/atomic.h>
#include <linux/refcount.h>

/* klp-ccp: from fs/btrfs/delayed-ref.h */
#include <linux/refcount.h>
/* klp-ccp: from fs/btrfs/xattr.h */
#include <linux/xattr.h>
/* klp-ccp: from fs/btrfs/messages.h */
#include <linux/types.h>
/* klp-ccp: from fs/btrfs/qgroup.h */
#include <linux/spinlock.h>
#include <linux/rbtree.h>
#include <linux/kobject.h>

/* klp-ccp: from fs/btrfs/volumes.h */
#include <linux/btrfs.h>
/* klp-ccp: from fs/btrfs/zoned.h */
#include <linux/types.h>
#include <linux/blkdev.h>

/* klp-ccp: from fs/btrfs/subpage.h */
#include <linux/spinlock.h>
/* klp-ccp: from fs/btrfs/inode-item.h */
#include <linux/types.h>

/* klp-ccp: from fs/btrfs/inode.c */
struct btrfs_encoded_read_private {
	wait_queue_head_t wait;
	atomic_t pending;
	blk_status_t status;
};

void klpp_btrfs_encoded_read_endio(struct btrfs_bio *bbio)
{
	struct btrfs_encoded_read_private *priv = bbio->private;

	if (bbio->bio.bi_status) {
		/*
		 * The memory barrier implied by the atomic_dec_return() here
		 * pairs with the memory barrier implied by the
		 * atomic_dec_return() or io_wait_event() in
		 * btrfs_encoded_read_regular_fill_pages() to ensure that this
		 * write is observed before the load of status in
		 * btrfs_encoded_read_regular_fill_pages().
		 */
		WRITE_ONCE(priv->status, bbio->bio.bi_status);
	}
	if (atomic_dec_and_test(&priv->pending))
		wake_up(&priv->wait);
	bio_put(&bbio->bio);
}


#include "livepatch_bsc1235129.h"

