/* Skip the CVE-2024-4741 fix in case the version being livepatched already have a fix for it.  */

#ifndef _DISABLE_CVE_2024_4741

#define __LEAF
#define __THROW	__attribute__ ((__nothrow__ __LEAF))
#define __NTH(fct)	__attribute__ ((__nothrow__ __LEAF)) fct
#define __bos0(ptr) __builtin_object_size (ptr, 0)
#define __glibc_objsize0(__o) __bos0 (__o)
#define __attribute_const__ __attribute__ ((__const__))
#define __attribute_nonnull__(params) __attribute__ ((__nonnull__ params))
#define __nonnull(params) __attribute_nonnull__ (params)
#define __always_inline __inline __attribute__ ((__always_inline__))
#define __attribute_artificial__ __attribute__ ((__artificial__))
#define __extern_always_inline \
  extern __always_inline __attribute__ ((__gnu_inline__))
#define __fortify_function __extern_always_inline __attribute_artificial__
/** clang-extract: from /usr/lib64/clang/18/include/__stddef_size_t.h:18:1  */
typedef __SIZE_TYPE__ size_t;

/** clang-extract: from /usr/include/bits/types.h:38:1  */
typedef unsigned char __uint8_t;

/** clang-extract: from /usr/include/bits/types.h:40:1  */
typedef unsigned short int __uint16_t;

/** clang-extract: from /usr/include/bits/types.h:42:1  */
typedef unsigned int __uint32_t;

/** clang-extract: from /usr/include/bits/types.h:45:1  */
typedef unsigned long int __uint64_t;

#define __SLONGWORD_TYPE	long int
#define __STD_TYPE		typedef
#define __SYSCALL_SLONG_TYPE	__SLONGWORD_TYPE
#define __TIME_T_TYPE		__SYSCALL_SLONG_TYPE
#define __SUSECONDS_T_TYPE	__SYSCALL_SLONG_TYPE
#undef __STD_TYPE
/** clang-extract: from /usr/include/errno.h:37:1  */
extern int *__errno_location (void) __THROW __attribute_const__;

#define errno (*__errno_location ())
#define OPENSSL_FILE __FILE__
#define OPENSSL_LINE __LINE__
/** clang-extract: from /usr/include/bits/stdint-uintn.h:24:1  */
typedef __uint8_t uint8_t;

/** clang-extract: from /usr/include/bits/stdint-uintn.h:25:1  */
typedef __uint16_t uint16_t;

/** clang-extract: from /usr/include/bits/stdint-uintn.h:26:1  */
typedef __uint32_t uint32_t;

/** clang-extract: from /usr/include/bits/stdint-uintn.h:27:1  */
typedef __uint64_t uint64_t;

#define STACK_OF(type) struct stack_st_##type
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:79:1  */
typedef struct bio_st BIO;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:80:1  */
typedef struct bignum_st BIGNUM;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:87:1  */
typedef struct buf_mem_st BUF_MEM;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:89:1  */
typedef struct evp_cipher_st EVP_CIPHER;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:90:1  */
typedef struct evp_cipher_ctx_st EVP_CIPHER_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:91:1  */
typedef struct evp_md_st EVP_MD;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:92:1  */
typedef struct evp_md_ctx_st EVP_MD_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:93:1  */
typedef struct evp_pkey_st EVP_PKEY;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:104:1  */
typedef struct hmac_ctx_st HMAC_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:106:1  */
typedef struct dh_st DH;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:122:9  */
struct ssl_dane_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:122:1  */
typedef struct ssl_dane_st SSL_DANE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:123:1  */
typedef struct x509_st X509;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:130:1  */
typedef struct x509_store_st X509_STORE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:131:1  */
typedef struct x509_store_ctx_st X509_STORE_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:136:1  */
typedef struct X509_VERIFY_PARAM_st X509_VERIFY_PARAM;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:149:1  */
typedef struct engine_st ENGINE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:150:9  */
struct ssl_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:150:1  */
typedef struct ssl_st SSL;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:151:9  */
struct ssl_ctx_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:151:1  */
typedef struct ssl_ctx_st SSL_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:153:1  */
typedef struct comp_ctx_st COMP_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:166:9  */
struct crypto_ex_data_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:166:1  */
typedef struct crypto_ex_data_st CRYPTO_EX_DATA;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:175:1  */
typedef struct ctlog_store_st CTLOG_STORE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ossl_typ.h:176:1  */
typedef struct ct_policy_eval_ctx_st CT_POLICY_EVAL_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/crypto.h:67:1  */
typedef void CRYPTO_RWLOCK;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/crypto.h:86:1  */
struct crypto_ex_data_st {
    STACK_OF(void) *sk;
};

#define clear_sys_error()       errno=0
/** clang-extract: from /usr/include/string.h:47:1  */
extern void *memmove (void *__dest, const void *__src, size_t __n)
     __THROW __nonnull ((1, 2));

/** clang-extract: from :33:1  */
__fortify_function void *
__NTH (memmove (void *__dest, const void *__src, size_t __len))
{
  return __builtin___memmove_chk (__dest, __src, __len,
				  __glibc_objsize0 (__dest));
}

#define NULL ((void*)0)
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/bio.h:559:1  */
int BIO_read(BIO *b, void *data, int dlen);

#define LHASH_OF(type) struct lhash_st_##type
#define ERR_R_FATAL                             64
#define ERR_R_INTERNAL_ERROR                    (4|ERR_R_FATAL)
#define EVP_MAX_MD_SIZE                 64
#define EVP_MAX_IV_LENGTH               16
#define SHA256_DIGEST_LENGTH    32
/** clang-extract: from :77:1  */
struct stack_st_X509_NAME;

/** clang-extract: from :83:9  */
struct stack_st_X509_EXTENSION;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/x509.h:83:1  */
typedef STACK_OF(X509_EXTENSION) X509_EXTENSIONS;

/** clang-extract: from :99:1  */
struct stack_st_X509;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/pem.h:231:1  */
typedef int pem_password_cb (char *buf, int size, int rwflag, void *userdata);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/async.h:32:1  */
typedef struct async_job_st ASYNC_JOB;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/async.h:33:1  */
typedef struct async_wait_ctx_st ASYNC_WAIT_CTX;

/** clang-extract: from :58:1  */
struct stack_st_SCT;

#define SSL_F_SSL3_READ_N                                149
#define SSL_R_READ_BIO_NOT_SET                           211
#define SSL_MAX_SSL_SESSION_ID_LENGTH           32
#define SSL_MAX_SID_CTX_LENGTH                  32
#define SSL_MAX_PIPELINES  32
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:219:1  */
typedef struct tls_session_ticket_ext_st TLS_SESSION_TICKET_EXT;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:220:9  */
struct ssl_method_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:220:1  */
typedef struct ssl_method_st SSL_METHOD;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:221:1  */
typedef struct ssl_cipher_st SSL_CIPHER;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:222:1  */
typedef struct ssl_session_st SSL_SESSION;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:225:1  */
typedef struct ssl_comp_st SSL_COMP;

/** clang-extract: from :227:1  */
struct stack_st_SSL_CIPHER;

/** clang-extract: from :228:1  */
struct stack_st_SSL_COMP;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:231:1  */
typedef struct srtp_protection_profile_st {
    const char *name;
    unsigned long id;
} SRTP_PROTECTION_PROFILE;

/** clang-extract: from :236:1  */
struct stack_st_SRTP_PROTECTION_PROFILE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:238:1  */
typedef int (*tls_session_ticket_ext_cb_fn)(SSL *s, const unsigned char *data,
                                            int len, void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:240:1  */
typedef int (*tls_session_secret_cb_fn)(SSL *s, void *secret, int *secret_len,
                                        STACK_OF(SSL_CIPHER) *peer_ciphers,
                                        const SSL_CIPHER **cipher, void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:283:1  */
typedef int (*SSL_custom_ext_add_cb_ex)(SSL *s, unsigned int ext_type,
                                        unsigned int context,
                                        const unsigned char **out,
                                        size_t *outlen, X509 *x,
                                        size_t chainidx,
                                        int *al, void *add_arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:290:1  */
typedef void (*SSL_custom_ext_free_cb_ex)(SSL *s, unsigned int ext_type,
                                          unsigned int context,
                                          const unsigned char *out,
                                          void *add_arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:295:1  */
typedef int (*SSL_custom_ext_parse_cb_ex)(SSL *s, unsigned int ext_type,
                                          unsigned int context,
                                          const unsigned char *in,
                                          size_t inlen, X509 *x,
                                          size_t chainidx,
                                          int *al, void *parse_arg);

#define SSL_MODE_RELEASE_BUFFERS 0x00000010U
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:678:1  */
typedef int (*GEN_SESSION_CB) (SSL *ssl, unsigned char *id,
                               unsigned int *id_len);

/** clang-extract: from :692:1  */
struct lhash_st_SSL_SESSION;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:775:1  */
typedef int (*SSL_CTX_npn_advertised_cb_func)(SSL *ssl,
                                              const unsigned char **out,
                                              unsigned int *outlen,
                                              void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:784:1  */
typedef int (*SSL_CTX_npn_select_cb_func)(SSL *s,
                                          unsigned char **out,
                                          unsigned char *outlen,
                                          const unsigned char *in,
                                          unsigned int inlen,
                                          void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:832:1  */
typedef unsigned int (*SSL_psk_client_cb_func)(SSL *ssl,
                                               const char *hint,
                                               char *identity,
                                               unsigned int max_identity_len,
                                               unsigned char *psk,
                                               unsigned int max_psk_len);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:841:1  */
typedef unsigned int (*SSL_psk_server_cb_func)(SSL *ssl,
                                               const char *identity,
                                               unsigned char *psk,
                                               unsigned int max_psk_len);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:854:1  */
typedef int (*SSL_psk_find_session_cb_func)(SSL *ssl,
                                            const unsigned char *identity,
                                            size_t identity_len,
                                            SSL_SESSION **sess);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:858:1  */
typedef int (*SSL_psk_use_session_cb_func)(SSL *ssl, const EVP_MD *md,
                                           const unsigned char **id,
                                           size_t *idlen,
                                           SSL_SESSION **sess);

#define SSL_NOTHING            1
#define SSL_READING            3
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:925:1  */
typedef void (*SSL_CTX_keylog_cb_func)(const SSL *ssl, const char *line);

#define SSL3_RANDOM_SIZE                        32
#define SSL3_RT_HEADER_LENGTH                   5
#define SSL3_ALIGN_PAYLOAD                     8
#define SSL3_RT_APPLICATION_DATA        23
#define TLS1_AD_INTERNAL_ERROR          80
#define DTLS1_COOKIE_LENGTH                     256
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:1000:1  */
typedef enum {
    TLS_ST_BEFORE,
    TLS_ST_OK,
    DTLS_ST_CR_HELLO_VERIFY_REQUEST,
    TLS_ST_CR_SRVR_HELLO,
    TLS_ST_CR_CERT,
    TLS_ST_CR_CERT_STATUS,
    TLS_ST_CR_KEY_EXCH,
    TLS_ST_CR_CERT_REQ,
    TLS_ST_CR_SRVR_DONE,
    TLS_ST_CR_SESSION_TICKET,
    TLS_ST_CR_CHANGE,
    TLS_ST_CR_FINISHED,
    TLS_ST_CW_CLNT_HELLO,
    TLS_ST_CW_CERT,
    TLS_ST_CW_KEY_EXCH,
    TLS_ST_CW_CERT_VRFY,
    TLS_ST_CW_CHANGE,
    TLS_ST_CW_NEXT_PROTO,
    TLS_ST_CW_FINISHED,
    TLS_ST_SW_HELLO_REQ,
    TLS_ST_SR_CLNT_HELLO,
    DTLS_ST_SW_HELLO_VERIFY_REQUEST,
    TLS_ST_SW_SRVR_HELLO,
    TLS_ST_SW_CERT,
    TLS_ST_SW_KEY_EXCH,
    TLS_ST_SW_CERT_REQ,
    TLS_ST_SW_SRVR_DONE,
    TLS_ST_SR_CERT,
    TLS_ST_SR_KEY_EXCH,
    TLS_ST_SR_CERT_VRFY,
    TLS_ST_SR_NEXT_PROTO,
    TLS_ST_SR_CHANGE,
    TLS_ST_SR_FINISHED,
    TLS_ST_SW_SESSION_TICKET,
    TLS_ST_SW_CERT_STATUS,
    TLS_ST_SW_CHANGE,
    TLS_ST_SW_FINISHED,
    TLS_ST_SW_ENCRYPTED_EXTENSIONS,
    TLS_ST_CR_ENCRYPTED_EXTENSIONS,
    TLS_ST_CR_CERT_VRFY,
    TLS_ST_SW_CERT_VRFY,
    TLS_ST_CR_HELLO_REQ,
    TLS_ST_SW_KEY_UPDATE,
    TLS_ST_CW_KEY_UPDATE,
    TLS_ST_SR_KEY_UPDATE,
    TLS_ST_CR_KEY_UPDATE,
    TLS_ST_EARLY_DATA,
    TLS_ST_PENDING_EARLY_DATA_END,
    TLS_ST_CW_END_OF_EARLY_DATA,
    TLS_ST_SR_END_OF_EARLY_DATA
} OSSL_HANDSHAKE_STATE;

#define SSL_AD_INTERNAL_ERROR           TLS1_AD_INTERNAL_ERROR
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:1809:1  */
typedef int (*SSL_client_hello_cb_fn) (SSL *s, int *al, void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:2190:1  */
typedef int (*ssl_ct_validation_cb)(const CT_POLICY_EVAL_CTX *ctx,
                                    const STACK_OF(SCT) *scts, void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:2384:1  */
typedef int SSL_TICKET_STATUS;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:2403:1  */
typedef int SSL_TICKET_RETURN;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:2416:1  */
typedef int (*SSL_CTX_generate_session_ticket_fn)(SSL *s, void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:2417:1  */
typedef SSL_TICKET_RETURN (*SSL_CTX_decrypt_session_ticket_fn)(SSL *s, SSL_SESSION *ss,
                                                               const unsigned char *keyname,
                                                               size_t keyname_length,
                                                               SSL_TICKET_STATUS status,
                                                               void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/openssl/ssl.h:2436:1  */
typedef int (*SSL_allow_early_data_cb_fn)(SSL *s, void *arg);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../record/record.h:17:1  */
typedef struct ssl3_buffer_st {
    /* at least SSL3_RT_MAX_PACKET_SIZE bytes, see ssl3_setup_buffers() */
    unsigned char *buf;
    /* default buffer size (or 0 if no default set) */
    size_t default_len;
    /* buffer size */
    size_t len;
    /* where to 'copy from' */
    size_t offset;
    /* how many bytes left */
    size_t left;
} SSL3_BUFFER;

#define SEQ_NUM_SIZE                            8
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../record/record.h:32:1  */
typedef struct ssl3_record_st {
    /* Record layer version */
    /* r */
    int rec_version;
    /* type of record */
    /* r */
    int type;
    /* How many bytes available */
    /* rw */
    size_t length;
    /*
     * How many bytes were available before padding was removed? This is used
     * to implement the MAC check in constant time for CBC records.
     */
    /* rw */
    size_t orig_len;
    /* read/write offset into 'buf' */
    /* r */
    size_t off;
    /* pointer to the record data */
    /* rw */
    unsigned char *data;
    /* where the decode bytes are */
    /* rw */
    unsigned char *input;
    /* only used with decompression - malloc()ed */
    /* r */
    unsigned char *comp;
    /* Whether the data from this record has already been read or not */
    /* r */
    unsigned int read;
    /* epoch number, needed by DTLS1 */
    /* r */
    unsigned long epoch;
    /* sequence number, needed by DTLS1 */
    /* r */
    unsigned char seq_num[SEQ_NUM_SIZE];
} SSL3_RECORD;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../record/record.h:71:1  */
typedef struct dtls1_bitmap_st {
    /* Track 32 packets on 32-bit systems and 64 - on 64-bit systems */
    unsigned long map;
    /* Max record number seen so far, 64-bit value in big-endian encoding */
    unsigned char max_seq_num[SEQ_NUM_SIZE];
} DTLS1_BITMAP;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../record/record.h:78:1  */
typedef struct record_pqueue_st {
    unsigned short epoch;
    struct pqueue_st *q;
} record_pqueue;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../record/record.h:93:1  */
typedef struct dtls_record_layer_st {
    /*
     * The current data and handshake epoch.  This is initially
     * undefined, and starts at zero once the initial handshake is
     * completed
     */
    unsigned short r_epoch;
    unsigned short w_epoch;
    /* records being received in the current epoch */
    DTLS1_BITMAP bitmap;
    /* renegotiation starts a new set of sequence numbers */
    DTLS1_BITMAP next_bitmap;
    /* Received handshake records (processed and unprocessed) */
    record_pqueue unprocessed_rcds;
    record_pqueue processed_rcds;
    /*
     * Buffered application records. Only for records between CCS and
     * Finished to prevent either protocol violation or unnecessary message
     * loss.
     */
    record_pqueue buffered_app_data;
    /* save last and current sequence numbers for retransmissions */
    unsigned char last_write_sequence[8];
    unsigned char curr_write_sequence[8];
} DTLS_RECORD_LAYER;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../record/record.h:127:1  */
typedef struct record_layer_st {
    /* The parent SSL structure */
    SSL *s;
    /*
     * Read as many input bytes as possible (for
     * non-blocking reads)
     */
    int read_ahead;
    /* where we are when reading */
    int rstate;
    /* How many pipelines can be used to read data */
    size_t numrpipes;
    /* How many pipelines can be used to write data */
    size_t numwpipes;
    /* read IO goes into here */
    SSL3_BUFFER rbuf;
    /* write IO goes into here */
    SSL3_BUFFER wbuf[SSL_MAX_PIPELINES];
    /* each decoded record goes in here */
    SSL3_RECORD rrec[SSL_MAX_PIPELINES];
    /* used internally to point at a raw packet */
    unsigned char *packet;
    size_t packet_length;
    /* number of bytes sent so far */
    size_t wnum;
    unsigned char handshake_fragment[4];
    size_t handshake_fragment_len;
    /* The number of consecutive empty records we have received */
    size_t empty_record_count;
    /* partial write - check the numbers match */
    /* number bytes written */
    size_t wpend_tot;
    int wpend_type;
    /* number of bytes submitted */
    size_t wpend_ret;
    const unsigned char *wpend_buf;
    unsigned char read_sequence[SEQ_NUM_SIZE];
    unsigned char write_sequence[SEQ_NUM_SIZE];
    /* Set to true if this is the first record in a connection */
    unsigned int is_first_record;
    /* Count of the number of consecutive warning alerts received */
    unsigned int alert_count;
    DTLS_RECORD_LAYER *d;
} RECORD_LAYER;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:20:1  */
typedef enum {
    /* Something went wrong */
    WORK_ERROR,
    /* We're done working and there shouldn't be anything else to do after */
    WORK_FINISHED_STOP,
    /* We're done working move onto the next thing */
    WORK_FINISHED_CONTINUE,
    /* We're working on phase A */
    WORK_MORE_A,
    /* We're working on phase B */
    WORK_MORE_B,
    /* We're working on phase C */
    WORK_MORE_C
} WORK_STATE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:46:1  */
typedef enum {
    /* No handshake in progress */
    MSG_FLOW_UNINITED,
    /* A permanent error with this connection */
    MSG_FLOW_ERROR,
    /* We are reading messages */
    MSG_FLOW_READING,
    /* We are writing messages */
    MSG_FLOW_WRITING,
    /* Handshake has finished */
    MSG_FLOW_FINISHED
} MSG_FLOW_STATE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:60:1  */
typedef enum {
    READ_STATE_HEADER,
    READ_STATE_BODY,
    READ_STATE_POST_PROCESS
} READ_STATE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:67:1  */
typedef enum {
    WRITE_STATE_TRANSITION,
    WRITE_STATE_PRE_WORK,
    WRITE_STATE_SEND,
    WRITE_STATE_POST_WORK
} WRITE_STATE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:74:1  */
typedef enum {
    /* The enc_write_ctx can be used normally */
    ENC_WRITE_STATE_VALID,
    /* The enc_write_ctx cannot be used */
    ENC_WRITE_STATE_INVALID,
    /* Write alerts in plaintext, but otherwise use the enc_write_ctx */
    ENC_WRITE_STATE_WRITE_PLAIN_ALERTS
} ENC_WRITE_STATES;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:83:1  */
typedef enum {
    /* The enc_read_ctx can be used normally */
    ENC_READ_STATE_VALID,
    /* We may receive encrypted or plaintext alerts */
    ENC_READ_STATE_ALLOW_PLAIN_ALERTS
} ENC_READ_STATES;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:98:1  */
struct ossl_statem_st {
    MSG_FLOW_STATE state;
    WRITE_STATE write_state;
    WORK_STATE write_state_work;
    READ_STATE read_state;
    WORK_STATE read_state_work;
    OSSL_HANDSHAKE_STATE hand_state;
    /* The handshake state requested by an API call (e.g. HelloRequest) */
    OSSL_HANDSHAKE_STATE request_state;
    int in_init;
    int read_state_first_init;
    /* true when we are actually in SSL_accept() or SSL_connect() */
    int in_handshake;
    /*
     * True when are processing a "real" handshake that needs cleaning up (not
     * just a HelloRequest or similar).
     */
    int cleanuphand;
    /* Should we skip the CertificateVerify message? */
    unsigned int no_cert_verify;
    int use_timer;
    ENC_WRITE_STATES enc_write_state;
    ENC_READ_STATES enc_read_state;
};

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:122:1  */
typedef struct ossl_statem_st OSSL_STATEM;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../statem/statem.h:135:1  */
void (*klpe_ossl_statem_fatal)(SSL *s, int al, int func, int reason, const char *file,
                                 int line);

#define SSLfatal(s, al, f, r)  (*klpe_ossl_statem_fatal)((s), (al), (f), (r), \
                                                   OPENSSL_FILE, OPENSSL_LINE)
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../packet_local.h:21:1  */
typedef struct {
    /* Pointer to where we are currently reading from */
    const unsigned char *curr;
    /* Number of bytes remaining */
    size_t remaining;
} PACKET;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../packet_local.h:598:1  */
typedef struct wpacket_sub WPACKET_SUB;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../packet_local.h:619:9  */
struct wpacket_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../packet_local.h:619:1  */
typedef struct wpacket_st WPACKET;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../packet_local.h:620:1  */
struct wpacket_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/internal/dane.h:42:1  */
typedef struct danetls_record_st {
    uint8_t usage;
    uint8_t selector;
    uint8_t mtype;
    unsigned char *data;
    size_t dlen;
    EVP_PKEY *spki;
} danetls_record;

/** clang-extract: from :51:1  */
struct stack_st_danetls_record;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/internal/dane.h:56:1  */
struct dane_ctx_st {
    const EVP_MD  **mdevp;      /* mtype -> digest */
    uint8_t        *mdord;      /* mtype -> preference */
    uint8_t         mdmax;      /* highest supported mtype */
    unsigned long   flags;      /* feature bitmask */
};

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/internal/dane.h:66:1  */
struct ssl_dane_st {
    struct dane_ctx_st *dctx;
    STACK_OF(danetls_record) *trecs;
    STACK_OF(X509) *certs;      /* DANE-TA(2) Cert(0) Full(0) certs */
    danetls_record *mtlsa;      /* Matching TLSA record */
    X509           *mcert;      /* DANE matched cert */
    uint32_t        umask;      /* Usages present */
    int             mdpth;      /* Depth of matched cert */
    int             pdpth;      /* Depth of PKIX trust */
    unsigned long   flags;      /* feature bitmask */
};

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/include/internal/refcount.h:30:1  */
typedef _Atomic int CRYPTO_REF_COUNT;

#define TSAN_QUALIFIER _Atomic
#define SSL_IS_DTLS(s)  (s->method->ssl3_enc->enc_flags & SSL_ENC_FLAG_DTLS)
#define SSL_PKEY_NUM            9
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:403:1  */
typedef enum {
    SSL_PHA_NONE = 0,
    SSL_PHA_EXT_SENT,        /* client-side only: extension sent */
    SSL_PHA_EXT_RECEIVED,    /* server-side only: extension received */
    SSL_PHA_REQUEST_PENDING, /* server-side only: request pending */
    SSL_PHA_REQUESTED        /* request received by client, or sent by server */
} SSL_PHA_STATE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:438:1  */
struct ssl_method_st {
    int version;
    unsigned flags;
    unsigned long mask;
    int (*ssl_new) (SSL *s);
    int (*ssl_clear) (SSL *s);
    void (*ssl_free) (SSL *s);
    int (*ssl_accept) (SSL *s);
    int (*ssl_connect) (SSL *s);
    int (*ssl_read) (SSL *s, void *buf, size_t len, size_t *readbytes);
    int (*ssl_peek) (SSL *s, void *buf, size_t len, size_t *readbytes);
    int (*ssl_write) (SSL *s, const void *buf, size_t len, size_t *written);
    int (*ssl_shutdown) (SSL *s);
    int (*ssl_renegotiate) (SSL *s);
    int (*ssl_renegotiate_check) (SSL *s, int);
    int (*ssl_read_bytes) (SSL *s, int type, int *recvd_type,
                           unsigned char *buf, size_t len, int peek,
                           size_t *readbytes);
    int (*ssl_write_bytes) (SSL *s, int type, const void *buf_, size_t len,
                            size_t *written);
    int (*ssl_dispatch_alert) (SSL *s);
    long (*ssl_ctrl) (SSL *s, int cmd, long larg, void *parg);
    long (*ssl_ctx_ctrl) (SSL_CTX *ctx, int cmd, long larg, void *parg);
    const SSL_CIPHER *(*get_cipher_by_char) (const unsigned char *ptr);
    int (*put_cipher_by_char) (const SSL_CIPHER *cipher, WPACKET *pkt,
                               size_t *len);
    size_t (*ssl_pending) (const SSL *s);
    int (*num_ciphers) (void);
    const SSL_CIPHER *(*get_cipher) (unsigned ncipher);
    long (*get_timeout) (void);
    const struct ssl3_enc_method *ssl3_enc; /* Extra SSLv3/TLS stuff */
    int (*ssl_version) (void);
    long (*ssl_callback_ctrl) (SSL *s, int cb_id, void (*fp) (void));
    long (*ssl_ctx_callback_ctrl) (SSL_CTX *s, int cb_id, void (*fp) (void));
};

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:596:1  */
typedef struct srp_ctx_st {
    /* param for all the callbacks */
    void *SRP_cb_arg;
    /* set client Hello login callback */
    int (*TLS_ext_srp_username_callback) (SSL *, int *, void *);
    /* set SRP N/g param callback for verification */
    int (*SRP_verify_param_callback) (SSL *, void *);
    /* set SRP client passwd callback */
    char *(*SRP_give_srp_client_pwd_callback) (SSL *, void *);
    char *login;
    BIGNUM *N, *g, *s, *B, *A;
    BIGNUM *a, *b, *v;
    char *info;
    int strength;
    unsigned long srp_Mask;
} SRP_CTX;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:615:1  */
typedef enum {
    SSL_EARLY_DATA_NONE = 0,
    SSL_EARLY_DATA_CONNECT_RETRY,
    SSL_EARLY_DATA_CONNECTING,
    SSL_EARLY_DATA_WRITE_RETRY,
    SSL_EARLY_DATA_WRITING,
    SSL_EARLY_DATA_WRITE_FLUSH,
    SSL_EARLY_DATA_UNAUTH_WRITING,
    SSL_EARLY_DATA_FINISHED_WRITING,
    SSL_EARLY_DATA_ACCEPT_RETRY,
    SSL_EARLY_DATA_ACCEPTING,
    SSL_EARLY_DATA_READ_RETRY,
    SSL_EARLY_DATA_READING,
    SSL_EARLY_DATA_FINISHED_READING
} SSL_EARLY_DATA_STATE;

#define MAX_COMPRESSIONS_SIZE   255
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:659:1  */
typedef struct raw_extension_st {
    /* Raw packet data for the extension */
    PACKET data;
    /* Set to 1 if the extension is present or 0 otherwise */
    int present;
    /* Set to 1 if we have already parsed the extension or 0 otherwise */
    int parsed;
    /* The type of this extension, i.e. a TLSEXT_TYPE_* value */
    unsigned int type;
    /* Track what order extensions are received in (0-based). */
    size_t received_order;
} RAW_EXTENSION;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:672:1  */
typedef struct {
    unsigned int isv2;
    unsigned int legacy_version;
    unsigned char random[SSL3_RANDOM_SIZE];
    size_t session_id_len;
    unsigned char session_id[SSL_MAX_SSL_SESSION_ID_LENGTH];
    size_t dtls_cookie_len;
    unsigned char dtls_cookie[DTLS1_COOKIE_LENGTH];
    PACKET ciphersuites;
    size_t compressions_len;
    unsigned char compressions[MAX_COMPRESSIONS_SIZE];
    PACKET extensions;
    size_t pre_proc_exts_len;
    RAW_EXTENSION *pre_proc_exts;
} CLIENTHELLO_MSG;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:692:9  */
enum tlsext_index_en {
    TLSEXT_IDX_renegotiate,
    TLSEXT_IDX_server_name,
    TLSEXT_IDX_max_fragment_length,
    TLSEXT_IDX_srp,
    TLSEXT_IDX_ec_point_formats,
    TLSEXT_IDX_supported_groups,
    TLSEXT_IDX_session_ticket,
    TLSEXT_IDX_status_request,
    TLSEXT_IDX_next_proto_neg,
    TLSEXT_IDX_application_layer_protocol_negotiation,
    TLSEXT_IDX_use_srtp,
    TLSEXT_IDX_encrypt_then_mac,
    TLSEXT_IDX_signed_certificate_timestamp,
    TLSEXT_IDX_extended_master_secret,
    TLSEXT_IDX_signature_algorithms_cert,
    TLSEXT_IDX_post_handshake_auth,
    TLSEXT_IDX_signature_algorithms,
    TLSEXT_IDX_supported_versions,
    TLSEXT_IDX_psk_kex_modes,
    TLSEXT_IDX_key_share,
    TLSEXT_IDX_cookie,
    TLSEXT_IDX_cryptopro_bug,
    TLSEXT_IDX_early_data,
    TLSEXT_IDX_certificate_authorities,
    TLSEXT_IDX_padding,
    TLSEXT_IDX_psk,
    TLSEXT_IDX_num_builtins
};

#define TLSEXT_KEYNAME_LENGTH  16
#define TLSEXT_TICK_KEY_LENGTH 32
/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:730:1  */
typedef struct ssl_ctx_ext_secure_st {
    unsigned char tick_hmac_key[TLSEXT_TICK_KEY_LENGTH];
    unsigned char tick_aes_key[TLSEXT_TICK_KEY_LENGTH];
} SSL_CTX_EXT_SECURE;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:735:1  */
struct ssl_ctx_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1068:1  */
struct ssl_st {
    /*
     * protocol version (one of SSL2_VERSION, SSL3_VERSION, TLS1_VERSION,
     * DTLS1_VERSION)
     */
    int version;
    /* SSLv3 */
    const SSL_METHOD *method;
    /*
     * There are 2 BIO's even though they are normally both the same.  This
     * is so data can be read and written to different handlers
     */
    /* used by SSL_read */
    BIO *rbio;
    /* used by SSL_write */
    BIO *wbio;
    /* used during session-id reuse to concatenate messages */
    BIO *bbio;
    /*
     * This holds a variable that indicates what we were doing when a 0 or -1
     * is returned.  This is needed for non-blocking IO so we know what
     * request needs re-doing when in SSL_accept or SSL_connect
     */
    int rwstate;
    int (*handshake_func) (SSL *);
    /*
     * Imagine that here's a boolean member "init" that is switched as soon
     * as SSL_set_{accept/connect}_state is called for the first time, so
     * that "state" and "handshake_func" are properly initialized.  But as
     * handshake_func is == 0 until then, we use this test instead of an
     * "init" member.
     */
    /* are we the server side? */
    int server;
    /*
     * Generate a new session or reuse an old one.
     * NB: For servers, the 'new' session may actually be a previously
     * cached session or even the previous session unless
     * SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION is set
     */
    int new_session;
    /* don't send shutdown packets */
    int quiet_shutdown;
    /* we have shut things down, 0x01 sent, 0x02 for received */
    int shutdown;
    /* where we are */
    OSSL_STATEM statem;
    SSL_EARLY_DATA_STATE early_data_state;
    BUF_MEM *init_buf;          /* buffer used during init */
    void *init_msg;             /* pointer to handshake message body, set by
                                 * ssl3_get_message() */
    size_t init_num;               /* amount read/written */
    size_t init_off;               /* amount read/written */
    struct ssl3_state_st *s3;   /* SSLv3 variables */
    struct dtls1_state_st *d1;  /* DTLSv1 variables */
    /* callback that allows applications to peek at protocol messages */
    void (*msg_callback) (int write_p, int version, int content_type,
                          const void *buf, size_t len, SSL *ssl, void *arg);
    void *msg_callback_arg;
    int hit;                    /* reusing a previous session */
    X509_VERIFY_PARAM *param;
    /* Per connection DANE state */
    SSL_DANE dane;
    /* crypto */
    STACK_OF(SSL_CIPHER) *peer_ciphers;
    STACK_OF(SSL_CIPHER) *cipher_list;
    STACK_OF(SSL_CIPHER) *cipher_list_by_id;
    /* TLSv1.3 specific ciphersuites */
    STACK_OF(SSL_CIPHER) *tls13_ciphersuites;
    /*
     * These are the ones being used, the ones in SSL_SESSION are the ones to
     * be 'copied' into these ones
     */
    uint32_t mac_flags;
    /*
     * The TLS1.3 secrets.
     */
    unsigned char early_secret[EVP_MAX_MD_SIZE];
    unsigned char handshake_secret[EVP_MAX_MD_SIZE];
    unsigned char master_secret[EVP_MAX_MD_SIZE];
    unsigned char resumption_master_secret[EVP_MAX_MD_SIZE];
    unsigned char client_finished_secret[EVP_MAX_MD_SIZE];
    unsigned char server_finished_secret[EVP_MAX_MD_SIZE];
    unsigned char server_finished_hash[EVP_MAX_MD_SIZE];
    unsigned char handshake_traffic_hash[EVP_MAX_MD_SIZE];
    unsigned char client_app_traffic_secret[EVP_MAX_MD_SIZE];
    unsigned char server_app_traffic_secret[EVP_MAX_MD_SIZE];
    unsigned char exporter_master_secret[EVP_MAX_MD_SIZE];
    unsigned char early_exporter_master_secret[EVP_MAX_MD_SIZE];
    EVP_CIPHER_CTX *enc_read_ctx; /* cryptographic state */
    unsigned char read_iv[EVP_MAX_IV_LENGTH]; /* TLSv1.3 static read IV */
    EVP_MD_CTX *read_hash;      /* used for mac generation */
    COMP_CTX *compress;         /* compression */
    COMP_CTX *expand;           /* uncompress */
    EVP_CIPHER_CTX *enc_write_ctx; /* cryptographic state */
    unsigned char write_iv[EVP_MAX_IV_LENGTH]; /* TLSv1.3 static write IV */
    EVP_MD_CTX *write_hash;     /* used for mac generation */
    /* session info */
    /* client cert? */
    /* This is used to hold the server certificate used */
    struct cert_st /* CERT */ *cert;

    /*
     * The hash of all messages prior to the CertificateVerify, and the length
     * of that hash.
     */
    unsigned char cert_verify_hash[EVP_MAX_MD_SIZE];
    size_t cert_verify_hash_len;

    /* Flag to indicate whether we should send a HelloRetryRequest or not */
    enum {SSL_HRR_NONE = 0, SSL_HRR_PENDING, SSL_HRR_COMPLETE}
        hello_retry_request;

    /*
     * the session_id_context is used to ensure sessions are only reused in
     * the appropriate context
     */
    size_t sid_ctx_length;
    unsigned char sid_ctx[SSL_MAX_SID_CTX_LENGTH];
    /* This can also be in the session once a session is established */
    SSL_SESSION *session;
    /* TLSv1.3 PSK session */
    SSL_SESSION *psksession;
    unsigned char *psksession_id;
    size_t psksession_id_len;
    /* Default generate session ID callback. */
    GEN_SESSION_CB generate_session_id;
    /*
     * The temporary TLSv1.3 session id. This isn't really a session id at all
     * but is a random value sent in the legacy session id field.
     */
    unsigned char tmp_session_id[SSL_MAX_SSL_SESSION_ID_LENGTH];
    size_t tmp_session_id_len;
    /* Used in SSL3 */
    /*
     * 0 don't care about verify failure.
     * 1 fail if verify fails
     */
    uint32_t verify_mode;
    /* fail if callback returns 0 */
    int (*verify_callback) (int ok, X509_STORE_CTX *ctx);
    /* optional informational callback */
    void (*info_callback) (const SSL *ssl, int type, int val);
    /* error bytes to be written */
    int error;
    /* actual code */
    int error_code;
# ifndef OPENSSL_NO_PSK
    SSL_psk_client_cb_func psk_client_callback;
    SSL_psk_server_cb_func psk_server_callback;
# endif
    SSL_psk_find_session_cb_func psk_find_session_cb;
    SSL_psk_use_session_cb_func psk_use_session_cb;

    SSL_CTX *ctx;
    /* Verified chain of peer */
    STACK_OF(X509) *verified_chain;
    long verify_result;
    /* extra application data */
    CRYPTO_EX_DATA ex_data;
    /*
     * What we put in certificate_authorities extension for TLS 1.3
     * (ClientHello and CertificateRequest) or just client cert requests for
     * earlier versions. If client_ca_names is populated then it is only used
     * for client cert requests, and in preference to ca_names.
     */
    STACK_OF(X509_NAME) *ca_names;
    STACK_OF(X509_NAME) *client_ca_names;
    CRYPTO_REF_COUNT references;
    /* protocol behaviour */
    uint32_t options;
    /* API behaviour */
    uint32_t mode;
    int min_proto_version;
    int max_proto_version;
    size_t max_cert_list;
    int first_packet;
    /*
     * What was passed in ClientHello.legacy_version. Used for RSA pre-master
     * secret and SSLv3/TLS (<=1.2) rollback check
     */
    int client_version;
    /*
     * If we're using more than one pipeline how should we divide the data
     * up between the pipes?
     */
    size_t split_send_fragment;
    /*
     * Maximum amount of data to send in one fragment. actual record size can
     * be more than this due to padding and MAC overheads.
     */
    size_t max_send_fragment;
    /* Up to how many pipelines should we use? If 0 then 1 is assumed */
    size_t max_pipelines;

    struct {
        /* Built-in extension flags */
        uint8_t extflags[TLSEXT_IDX_num_builtins];
        /* TLS extension debug callback */
        void (*debug_cb)(SSL *s, int client_server, int type,
                         const unsigned char *data, int len, void *arg);
        void *debug_arg;
        char *hostname;
        /* certificate status request info */
        /* Status type or -1 if no status type */
        int status_type;
        /* Raw extension data, if seen */
        unsigned char *scts;
        /* Length of raw extension data, if seen */
        uint16_t scts_len;
        /* Expect OCSP CertificateStatus message */
        int status_expected;

        struct {
            /* OCSP status request only */
            STACK_OF(OCSP_RESPID) *ids;
            X509_EXTENSIONS *exts;
            /* OCSP response received or to be sent */
            unsigned char *resp;
            size_t resp_len;
        } ocsp;

        /* RFC4507 session ticket expected to be received or sent */
        int ticket_expected;
# ifndef OPENSSL_NO_EC
        size_t ecpointformats_len;
        /* our list */
        unsigned char *ecpointformats;

        size_t peer_ecpointformats_len;
        /* peer's list */
        unsigned char *peer_ecpointformats;
# endif                         /* OPENSSL_NO_EC */
        size_t supportedgroups_len;
        /* our list */
        uint16_t *supportedgroups;

        size_t peer_supportedgroups_len;
         /* peer's list */
        uint16_t *peer_supportedgroups;

        /* TLS Session Ticket extension override */
        TLS_SESSION_TICKET_EXT *session_ticket;
        /* TLS Session Ticket extension callback */
        tls_session_ticket_ext_cb_fn session_ticket_cb;
        void *session_ticket_cb_arg;
        /* TLS pre-shared secret session resumption */
        tls_session_secret_cb_fn session_secret_cb;
        void *session_secret_cb_arg;
        /*
         * For a client, this contains the list of supported protocols in wire
         * format.
         */
        unsigned char *alpn;
        size_t alpn_len;
        /*
         * Next protocol negotiation. For the client, this is the protocol that
         * we sent in NextProtocol and is set when handling ServerHello
         * extensions. For a server, this is the client's selected_protocol from
         * NextProtocol and is set when handling the NextProtocol message, before
         * the Finished message.
         */
        unsigned char *npn;
        size_t npn_len;

        /* The available PSK key exchange modes */
        int psk_kex_mode;

        /* Set to one if we have negotiated ETM */
        int use_etm;

        /* Are we expecting to receive early data? */
        int early_data;
        /* Is the session suitable for early data? */
        int early_data_ok;

        /* May be sent by a server in HRR. Must be echoed back in ClientHello */
        unsigned char *tls13_cookie;
        size_t tls13_cookie_len;
        /* Have we received a cookie from the client? */
        int cookieok;

        /*
         * Maximum Fragment Length as per RFC 4366.
         * If this member contains one of the allowed values (1-4)
         * then we should include Maximum Fragment Length Negotiation
         * extension in Client Hello.
         * Please note that value of this member does not have direct
         * effect. The actual (binding) value is stored in SSL_SESSION,
         * as this extension is optional on server side.
         */
        uint8_t max_fragment_len_mode;

        /*
         * On the client side the number of ticket identities we sent in the
         * ClientHello. On the server side the identity of the ticket we
         * selected.
         */
        int tick_identity;
    } ext;

    /*
     * Parsed form of the ClientHello, kept around across client_hello_cb
     * calls.
     */
    CLIENTHELLO_MSG *clienthello;

    /*-
     * no further mod of servername
     * 0 : call the servername extension callback.
     * 1 : prepare 2, allow last ack just after in server callback.
     * 2 : don't call servername callback, no ack in server hello
     */
    int servername_done;
# ifndef OPENSSL_NO_CT
    /*
     * Validates that the SCTs (Signed Certificate Timestamps) are sufficient.
     * If they are not, the connection should be aborted.
     */
    ssl_ct_validation_cb ct_validation_callback;
    /* User-supplied argument that is passed to the ct_validation_callback */
    void *ct_validation_callback_arg;
    /*
     * Consolidated stack of SCTs from all sources.
     * Lazily populated by CT_get_peer_scts(SSL*)
     */
    STACK_OF(SCT) *scts;
    /* Have we attempted to find/parse SCTs yet? */
    int scts_parsed;
# endif
    SSL_CTX *session_ctx;       /* initial ctx, used to store sessions */
# ifndef OPENSSL_NO_SRTP
    /* What we'll do */
    STACK_OF(SRTP_PROTECTION_PROFILE) *srtp_profiles;
    /* What's been chosen */
    SRTP_PROTECTION_PROFILE *srtp_profile;
# endif
    /*-
     * 1 if we are renegotiating.
     * 2 if we are a server and are inside a handshake
     * (i.e. not just sending a HelloRequest)
     */
    int renegotiate;
    /* If sending a KeyUpdate is pending */
    int key_update;
    /* Post-handshake authentication state */
    SSL_PHA_STATE post_handshake_auth;
    int pha_enabled;
    uint8_t* pha_context;
    size_t pha_context_len;
    int certreqs_sent;
    EVP_MD_CTX *pha_dgst; /* this is just the digest through ClientFinished */

# ifndef OPENSSL_NO_SRP
    /* ctx for SRP authentication */
    SRP_CTX srp_ctx;
# endif
    /*
     * Callback for disabling session caching and ticket support on a session
     * basis, depending on the chosen cipher.
     */
    int (*not_resumable_session_cb) (SSL *ssl, int is_forward_secure);
    RECORD_LAYER rlayer;
    /* Default password callback. */
    pem_password_cb *default_passwd_callback;
    /* Default password callback user data. */
    void *default_passwd_callback_userdata;
    /* Async Job info */
    ASYNC_JOB *job;
    ASYNC_WAIT_CTX *waitctx;
    size_t asyncrw;

    /*
     * The maximum number of bytes advertised in session tickets that can be
     * sent as early data.
     */
    uint32_t max_early_data;
    /*
     * The maximum number of bytes of early data that a server will tolerate
     * (which should be at least as much as max_early_data).
     */
    uint32_t recv_max_early_data;

    /*
     * The number of bytes of early data received so far. If we accepted early
     * data then this is a count of the plaintext bytes. If we rejected it then
     * this is a count of the ciphertext bytes.
     */
    uint32_t early_data_count;

    /* TLS1.3 padding callback */
    size_t (*record_padding_cb)(SSL *s, int type, size_t len, void *arg);
    void *record_padding_arg;
    size_t block_padding;

    CRYPTO_RWLOCK *lock;

    /* The number of TLS1.3 tickets to automatically send */
    size_t num_tickets;
    /* The number of TLS1.3 tickets actually sent so far */
    size_t sent_tickets;
    /* The next nonce value to use when we send a ticket on this connection */
    uint64_t next_ticket_nonce;

    /* Callback to determine if early_data is acceptable or not */
    SSL_allow_early_data_cb_fn allow_early_data_cb;
    void *allow_early_data_cb_data;

    /*
     * Signature algorithms shared by client and server: cached because these
     * are used most often.
     */
    const struct sigalg_lookup_st **shared_sigalgs;
    size_t shared_sigalgslen;
};

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1505:1  */
struct sigalg_lookup_st;

/** clang-extract: from ssl/record/rec_layer_s3.c:2508:1  */
struct sigalg_lookup_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1488:1  */
typedef struct sigalg_lookup_st {
    /* TLS 1.3 signature scheme name */
    const char *name;
    /* Raw value used in extension */
    uint16_t sigalg;
    /* NID of hash algorithm or NID_undef if no hash */
    int hash;
    /* Index of hash algorithm or -1 if no hash algorithm */
    int hash_idx;
    /* NID of signature algorithm */
    int sig;
    /* Index of signature algorithm */
    int sig_idx;
    /* Combined hash and signature NID, if any */
    int sigandhash;
    /* Required public key curve (ECDSA only) */
    int curve;
} SIGALG_LOOKUP;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1520:9  */
struct cert_pkey_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1520:1  */
typedef struct cert_pkey_st CERT_PKEY;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1531:9  */
struct ssl3_state_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1816:1  */
struct cert_pkey_st {
    X509 *x509;
    EVP_PKEY *privatekey;
    /* Chain for this certificate */
    STACK_OF(X509) *chain;
    /*-
     * serverinfo data for this certificate.  The data is in TLS Extension
     * wire format, specifically it's a series of records like:
     *   uint16_t extension_type; // (RFC 5246, 7.4.1.4, Extension)
     *   uint16_t length;
     *   uint8_t data[length];
     */
    unsigned char *serverinfo;
    size_t serverinfo_length;
};

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1837:1  */
typedef enum {
    ENDPOINT_CLIENT = 0,
    ENDPOINT_SERVER,
    ENDPOINT_BOTH
} ENDPOINT;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1844:1  */
typedef struct {
    unsigned short ext_type;
    ENDPOINT role;
    /* The context which this extension applies to */
    unsigned int context;
    /*
     * Per-connection flags relating to this extension type: not used if
     * part of an SSL_CTX structure.
     */
    uint32_t ext_flags;
    SSL_custom_ext_add_cb_ex add_cb;
    SSL_custom_ext_free_cb_ex free_cb;
    void *add_arg;
    SSL_custom_ext_parse_cb_ex parse_cb;
    void *parse_arg;
} custom_ext_method;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1874:1  */
typedef struct {
    custom_ext_method *meths;
    size_t meths_count;
} custom_ext_methods;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1879:9  */
struct cert_st;

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/../ssl_local.h:1953:9  */
struct ssl3_enc_method {
    int (*enc) (SSL *, SSL3_RECORD *, size_t, int);
    int (*mac) (SSL *, SSL3_RECORD *, unsigned char *, int);
    int (*setup_key_block) (SSL *);
    int (*generate_master_secret) (SSL *, unsigned char *, unsigned char *,
                                   size_t, size_t *);
    int (*change_cipher_state) (SSL *, int);
    size_t (*final_finish_mac) (SSL *, const char *, size_t, unsigned char *);
    const char *client_finished_label;
    size_t client_finished_label_len;
    const char *server_finished_label;
    size_t server_finished_label_len;
    int (*alert_value) (int);
    int (*export_keying_material) (SSL *, unsigned char *, size_t,
                                   const char *, size_t,
                                   const unsigned char *, size_t,
                                   int use_context);
    /* Various flags indicating protocol version requirements */
    uint32_t enc_flags;
    /* Set the handshake header */
    int (*set_handshake_header) (SSL *s, WPACKET *pkt, int type);
    /* Close construction of the handshake message */
    int (*close_construct_packet) (SSL *s, WPACKET *pkt, int htype);
    /* Write out handshake message */
    int (*do_write) (SSL *s);
};

#define SSL_ENC_FLAG_DTLS               0x8

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/record_local.h:72:8  */
int (*klpe_ssl3_setup_read_buffer)(SSL *s);

/** clang-extract: from /var/tmp/build-root/standard-x86_64/home/abuild/rpmbuild/BUILD/openssl-1.1.1l/ssl/record/record_local.h:74:1  */
int (*klpe_ssl3_release_read_buffer)(SSL *s);

#define ossl_assert(x) ((x) != 0)
/** clang-extract: from ssl/record/rec_layer_s3.c:170:1  */
int ssl3_read_n_lp(SSL *s, size_t n, size_t max, int extend, int clearold,
                size_t *readbytes)
{
    /*
     * If extend == 0, obtain new n-byte packet; if extend == 1, increase
     * packet by another n bytes. The packet will be in the sub-array of
     * s->rlayer.rbuf.buf specified by s->rlayer.packet and
     * s->rlayer.packet_length. (If s->rlayer.read_ahead is set, 'max' bytes may
     * be stored in rbuf [plus s->rlayer.packet_length bytes if extend == 1].)
     * if clearold == 1, move the packet to the start of the buffer; if
     * clearold == 0 then leave any old packets where they were
     */
    size_t len, left, align = 0;
    unsigned char *pkt;
    SSL3_BUFFER *rb;

    if (n == 0)
        return 0;

    rb = &s->rlayer.rbuf;
    if (rb->buf == NULL)
        if (!(*klpe_ssl3_setup_read_buffer)(s)) {
            /* SSLfatal() already called */
            return -1;
        }

    left = rb->left;
#if defined(SSL3_ALIGN_PAYLOAD) && SSL3_ALIGN_PAYLOAD!=0
    align = (size_t)rb->buf + SSL3_RT_HEADER_LENGTH;
    align = SSL3_ALIGN_PAYLOAD - 1 - ((align - 1) % SSL3_ALIGN_PAYLOAD);
#endif

    if (!extend) {
        /* start with empty packet ... */
        if (left == 0)
            rb->offset = align;
        else if (align != 0 && left >= SSL3_RT_HEADER_LENGTH) {
            /*
             * check if next packet length is large enough to justify payload
             * alignment...
             */
            pkt = rb->buf + rb->offset;
            if (pkt[0] == SSL3_RT_APPLICATION_DATA
                && (pkt[3] << 8 | pkt[4]) >= 128) {
                /*
                 * Note that even if packet is corrupted and its length field
                 * is insane, we can only be led to wrong decision about
                 * whether memmove will occur or not. Header values has no
                 * effect on memmove arguments and therefore no buffer
                 * overrun can be triggered.
                 */
                memmove(rb->buf + align, pkt, left);
                rb->offset = align;
            }
        }
        s->rlayer.packet = rb->buf + rb->offset;
        s->rlayer.packet_length = 0;
        /* ... now we can act as if 'extend' was set */
    }
    if (!ossl_assert(s->rlayer.packet != NULL)) {
        /* does not happen */
        SSLfatal(s, SSL_AD_INTERNAL_ERROR, SSL_F_SSL3_READ_N,
                 ERR_R_INTERNAL_ERROR);
        return -1;
    }

    len = s->rlayer.packet_length;
    pkt = rb->buf + align;
    /*
     * Move any available bytes to front of buffer: 'len' bytes already
     * pointed to by 'packet', 'left' extra ones at the end
     */
    if (s->rlayer.packet != pkt && clearold == 1) {
        memmove(pkt, s->rlayer.packet, len + left);
        s->rlayer.packet = pkt;
        rb->offset = len + align;
    }

    /*
     * For DTLS/UDP reads should not span multiple packets because the read
     * operation returns the whole packet at once (as long as it fits into
     * the buffer).
     */
    if (SSL_IS_DTLS(s)) {
        if (left == 0 && extend)
            return 0;
        if (left > 0 && n > left)
            n = left;
    }

    /* if there is enough in the buffer from a previous read, take some */
    if (left >= n) {
        s->rlayer.packet_length += n;
        rb->left = left - n;
        rb->offset += n;
        *readbytes = n;
        return 1;
    }

    /* else we need to read more data */

    if (n > rb->len - rb->offset) {
        /* does not happen */
        SSLfatal(s, SSL_AD_INTERNAL_ERROR, SSL_F_SSL3_READ_N,
                 ERR_R_INTERNAL_ERROR);
        return -1;
    }

    /* We always act like read_ahead is set for DTLS */
    if (!s->rlayer.read_ahead && !SSL_IS_DTLS(s))
        /* ignore max parameter */
        max = n;
    else {
        if (max < n)
            max = n;
        if (max > rb->len - rb->offset)
            max = rb->len - rb->offset;
    }

    while (left < n) {
        size_t bioread = 0;
        int ret;

        /*
         * Now we have len+left bytes at the front of s->s3->rbuf.buf and
         * need to read in more until we have len+n (up to len+max if
         * possible)
         */

        clear_sys_error();
        if (s->rbio != NULL) {
            s->rwstate = SSL_READING;
            /* TODO(size_t): Convert this function */
            ret = BIO_read(s->rbio, pkt + len + left, max - left);
            if (ret >= 0)
                bioread = ret;
        } else {
            SSLfatal(s, SSL_AD_INTERNAL_ERROR, SSL_F_SSL3_READ_N,
                     SSL_R_READ_BIO_NOT_SET);
            ret = -1;
        }

        if (ret <= 0) {
            rb->left = left;
            if (s->mode & SSL_MODE_RELEASE_BUFFERS && !SSL_IS_DTLS(s))
                if (len + left == 0)
                    (*klpe_ssl3_release_read_buffer)(s);
            return ret;
        }
        left += bioread;
        /*
         * reads should *never* span multiple packets for DTLS because the
         * underlying transport protocol is message oriented as opposed to
         * byte oriented as in the TLS case.
         */
        if (SSL_IS_DTLS(s)) {
            if (n > left)
                n = left;       /* makes the while condition false */
        }
    }

    /* done reading, now the book-keeping */
    rb->offset += n;
    rb->left = left - n;
    s->rlayer.packet_length += n;
    s->rwstate = SSL_NOTHING;
    *readbytes = n;
    return 1;
}
#endif
