/* Skip the CVE-2023-5678 fix in case the version being livepatched already have a fix for it.  */

#ifndef _DISABLE_CVE_2025_9230

#include <string.h>
#include <stdint.h>

#define OPENSSL_FILE __FILE__
#define OPENSSL_LINE __LINE__
#define STACK_OF(type) struct stack_st_##type
/** clang-extract: from include/openssl/ossl_typ.h:40:1 */
typedef struct asn1_string_st ASN1_INTEGER;

/** clang-extract: from include/openssl/ossl_typ.h:41:1 */
typedef struct asn1_string_st ASN1_ENUMERATED;

/** clang-extract: from include/openssl/ossl_typ.h:42:1 */
typedef struct asn1_string_st ASN1_BIT_STRING;

/** clang-extract: from include/openssl/ossl_typ.h:43:1 */
typedef struct asn1_string_st ASN1_OCTET_STRING;

/** clang-extract: from include/openssl/ossl_typ.h:44:1 */
typedef struct asn1_string_st ASN1_PRINTABLESTRING;

/** clang-extract: from include/openssl/ossl_typ.h:45:1 */
typedef struct asn1_string_st ASN1_T61STRING;

/** clang-extract: from include/openssl/ossl_typ.h:46:1 */
typedef struct asn1_string_st ASN1_IA5STRING;

/** clang-extract: from include/openssl/ossl_typ.h:47:1 */
typedef struct asn1_string_st ASN1_GENERALSTRING;

/** clang-extract: from include/openssl/ossl_typ.h:48:1 */
typedef struct asn1_string_st ASN1_UNIVERSALSTRING;

/** clang-extract: from include/openssl/ossl_typ.h:49:1 */
typedef struct asn1_string_st ASN1_BMPSTRING;

/** clang-extract: from include/openssl/ossl_typ.h:50:1 */
typedef struct asn1_string_st ASN1_UTCTIME;

/** clang-extract: from include/openssl/ossl_typ.h:52:1 */
typedef struct asn1_string_st ASN1_GENERALIZEDTIME;

/** clang-extract: from include/openssl/ossl_typ.h:53:1 */
typedef struct asn1_string_st ASN1_VISIBLESTRING;

/** clang-extract: from include/openssl/ossl_typ.h:54:1 */
typedef struct asn1_string_st ASN1_UTF8STRING;

/** clang-extract: from include/openssl/ossl_typ.h:55:1 */
typedef struct asn1_string_st ASN1_STRING;

/** clang-extract: from include/openssl/ossl_typ.h:56:1 */
typedef int ASN1_BOOLEAN;

/** clang-extract: from include/openssl/ossl_typ.h:60:1 */
typedef struct asn1_object_st ASN1_OBJECT;

/** clang-extract: from include/openssl/ossl_typ.h:62:1 */
typedef struct ASN1_ITEM_st ASN1_ITEM;

/** clang-extract: from include/openssl/ossl_typ.h:89:1 */
typedef struct evp_cipher_st EVP_CIPHER;

/** clang-extract: from include/openssl/ossl_typ.h:90:1 */
typedef struct evp_cipher_ctx_st EVP_CIPHER_CTX;

/** clang-extract: from include/openssl/ossl_typ.h:124:1 */
typedef struct X509_algor_st X509_ALGOR;

/** clang-extract: from include/openssl/ossl_typ.h:149:1 */
typedef struct engine_st ENGINE;

#define OPENSSL_malloc(num) \
        CRYPTO_malloc(num, OPENSSL_FILE, OPENSSL_LINE)
#define OPENSSL_clear_free(addr, num) \
        CRYPTO_clear_free(addr, num, OPENSSL_FILE, OPENSSL_LINE)
#define OPENSSL_free(addr) \
        CRYPTO_free(addr, OPENSSL_FILE, OPENSSL_LINE)
/** clang-extract: from include/openssl/crypto.h:266:1 */
void *CRYPTO_malloc(size_t num, const char *file, int line);

/** clang-extract: from include/openssl/crypto.h:271:1 */
void CRYPTO_free(void *ptr, const char *file, int line);

/** clang-extract: from include/openssl/crypto.h:272:1 */
void CRYPTO_clear_free(void *ptr, size_t num, const char *file, int line);

#define ERR_PUT_error(a,b,c,d,e)        ERR_put_error(a,b,c,d,e)
#define ERR_LIB_EVP             6
#define ERR_LIB_CMS             46
#define CMSerr(f,r) ERR_PUT_error(ERR_LIB_CMS,(f),(r),OPENSSL_FILE,OPENSSL_LINE)
#define ERR_R_EVP_LIB   ERR_LIB_EVP
#define ERR_R_FATAL                             64
#define ERR_R_MALLOC_FAILURE                    (1|ERR_R_FATAL)
/** clang-extract: from include/openssl/err.h:220:1 */
void ERR_put_error(int lib, int func, int reason, const char *file, int line);

/** clang-extract: from include/openssl/asn1.h:146:1 */
struct asn1_string_st {
    int length;
    int type;
    unsigned char *data;
    /*
     * The value of the following field depends on the type being held.  It
     * is mostly being used for BIT_STRING so if the input data has a
     * non-zero 'unused bits' value, it will be handled correctly
     */
    long flags;
};

/** clang-extract: from include/openssl/asn1.h:213:1 */
typedef struct ASN1_VALUE_st ASN1_VALUE;

#define ASN1_ITEM_rptr(ref) (&(ref##_it))
/** clang-extract: from include/openssl/asn1.h:444:1 */
typedef struct asn1_type_st {
    int type;
    union {
        char *ptr;
        ASN1_BOOLEAN boolean;
        ASN1_STRING *asn1_string;
        ASN1_OBJECT *object;
        ASN1_INTEGER *integer;
        ASN1_ENUMERATED *enumerated;
        ASN1_BIT_STRING *bit_string;
        ASN1_OCTET_STRING *octet_string;
        ASN1_PRINTABLESTRING *printablestring;
        ASN1_T61STRING *t61string;
        ASN1_IA5STRING *ia5string;
        ASN1_GENERALSTRING *generalstring;
        ASN1_BMPSTRING *bmpstring;
        ASN1_UNIVERSALSTRING *universalstring;
        ASN1_UTCTIME *utctime;
        ASN1_GENERALIZEDTIME *generalizedtime;
        ASN1_VISIBLESTRING *visiblestring;
        ASN1_UTF8STRING *utf8string;
        /*
         * set and sequence are left complete and still contain the set or
         * sequence bytes
         */
        ASN1_STRING *set;
        ASN1_STRING *sequence;
        ASN1_VALUE *asn1_value;
    } value;
} ASN1_TYPE;

/** clang-extract: from include/openssl/asn1.h:526:1 */
void *ASN1_TYPE_unpack_sequence(const ASN1_ITEM *it, const ASN1_TYPE *t);

#define NID_id_alg_PWRI_KEK             893
/** clang-extract: from include/openssl/objects.h:61:1 */
const char *OBJ_nid2sn(int n);

/** clang-extract: from include/openssl/objects.h:62:1 */
int OBJ_obj2nid(const ASN1_OBJECT *o);

#define EVP_get_cipherbynid(a) EVP_get_cipherbyname(OBJ_nid2sn(a))
#define EVP_get_cipherbyobj(a) EVP_get_cipherbynid(OBJ_obj2nid(a))
/** clang-extract: from include/openssl/evp.h:476:1 */
int EVP_CIPHER_CTX_block_size(const EVP_CIPHER_CTX *ctx);

/** clang-extract: from include/openssl/evp.h:586:12 */
int EVP_EncryptUpdate(EVP_CIPHER_CTX *ctx, unsigned char *out,
                                 int *outl, const unsigned char *in, int inl);

/** clang-extract: from include/openssl/evp.h:595:12 */
int EVP_DecryptInit_ex(EVP_CIPHER_CTX *ctx,
                                  const EVP_CIPHER *cipher, ENGINE *impl,
                                  const unsigned char *key,
                                  const unsigned char *iv);

/** clang-extract: from include/openssl/evp.h:599:12 */
int EVP_DecryptUpdate(EVP_CIPHER_CTX *ctx, unsigned char *out,
                                 int *outl, const unsigned char *in, int inl);

/** clang-extract: from include/openssl/evp.h:609:12 */
int EVP_CipherInit_ex(EVP_CIPHER_CTX *ctx,
                                 const EVP_CIPHER *cipher, ENGINE *impl,
                                 const unsigned char *key,
                                 const unsigned char *iv, int enc);

/** clang-extract: from include/openssl/evp.h:679:1 */
EVP_CIPHER_CTX *EVP_CIPHER_CTX_new(void);

/** clang-extract: from include/openssl/evp.h:681:1 */
void EVP_CIPHER_CTX_free(EVP_CIPHER_CTX *c);

/** clang-extract: from include/openssl/evp.h:683:1 */
int EVP_CIPHER_CTX_set_padding(EVP_CIPHER_CTX *c, int pad);

/** clang-extract: from include/openssl/evp.h:968:1 */
const EVP_CIPHER *EVP_get_cipherbyname(const char *name);

/** clang-extract: from include/openssl/evp.h:1077:1 */
int EVP_CIPHER_asn1_to_param(EVP_CIPHER_CTX *c, ASN1_TYPE *type);

/** clang-extract: from include/openssl/evp.h:1110:1 */
int EVP_PBE_CipherInit(ASN1_OBJECT *pbe_obj, const char *pass, int passlen,
                       ASN1_TYPE *param, EVP_CIPHER_CTX *ctx, int en_de);

/** clang-extract: from include/openssl/x509.h:59:1 */
struct X509_algor_st {
    ASN1_OBJECT *algorithm;
    ASN1_TYPE *parameter;
};

/** clang-extract: from include/openssl/x509.h:89:1 */
struct stack_st_X509_ATTRIBUTE;/* Full definition was removed.  */

/** clang-extract: from include/openssl/x509.h:503:1 */
void X509_ALGOR_free(X509_ALGOR *a);

/** clang-extract: from include/openssl/x509.h:503:1 */
extern const ASN1_ITEM X509_ALGOR_it;

#define CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT               167
#define CMS_F_KEK_UNWRAP_KEY                             180
#define CMS_R_CIPHER_PARAMETER_INITIALISATION_ERROR      102
#define CMS_R_INVALID_KEY_ENCRYPTION_PARAMETER           176
#define CMS_R_NO_PASSWORD                                178
#define CMS_R_UNKNOWN_CIPHER                             148
#define CMS_R_UNSUPPORTED_KEY_ENCRYPTION_ALGORITHM       179
#define CMS_R_UNWRAP_FAILURE                             180
/** clang-extract: from include/openssl/cms.h:23:1 */
typedef struct CMS_ContentInfo_st CMS_ContentInfo;

/** clang-extract: from include/openssl/cms.h:27:1 */
typedef struct CMS_RecipientInfo_st CMS_RecipientInfo;

/** clang-extract: from include/openssl/cms.h:35:1 */
struct stack_st_CMS_RecipientInfo;/* Full definition was removed.  */

/** clang-extract: from include/openssl/rand.h:42:1 */
int RAND_bytes(unsigned char *buf, int num);

/** clang-extract: from crypto/cms/cms_local.h:24:1 */
typedef struct CMS_SignedData_st CMS_SignedData;

/** clang-extract: from crypto/cms/cms_local.h:26:1 */
typedef struct CMS_OriginatorInfo_st CMS_OriginatorInfo;

/** clang-extract: from crypto/cms/cms_local.h:27:1 */
typedef struct CMS_EncryptedContentInfo_st CMS_EncryptedContentInfo;

/** clang-extract: from crypto/cms/cms_local.h:28:1 */
typedef struct CMS_EnvelopedData_st CMS_EnvelopedData;

/** clang-extract: from crypto/cms/cms_local.h:29:1 */
typedef struct CMS_DigestedData_st CMS_DigestedData;

/** clang-extract: from crypto/cms/cms_local.h:30:1 */
typedef struct CMS_EncryptedData_st CMS_EncryptedData;

/** clang-extract: from crypto/cms/cms_local.h:31:1 */
typedef struct CMS_AuthenticatedData_st CMS_AuthenticatedData;

/** clang-extract: from crypto/cms/cms_local.h:32:1 */
typedef struct CMS_CompressedData_st CMS_CompressedData;

/** clang-extract: from crypto/cms/cms_local.h:34:1 */
typedef struct CMS_KeyTransRecipientInfo_st CMS_KeyTransRecipientInfo;

/** clang-extract: from crypto/cms/cms_local.h:37:1 */
typedef struct CMS_KeyAgreeRecipientInfo_st CMS_KeyAgreeRecipientInfo;

/** clang-extract: from crypto/cms/cms_local.h:42:1 */
typedef struct CMS_KEKRecipientInfo_st CMS_KEKRecipientInfo;

/** clang-extract: from crypto/cms/cms_local.h:43:1 */
typedef struct CMS_PasswordRecipientInfo_st CMS_PasswordRecipientInfo;

/** clang-extract: from crypto/cms/cms_local.h:44:1 */
typedef struct CMS_OtherRecipientInfo_st CMS_OtherRecipientInfo;

/** clang-extract: from crypto/cms/cms_local.h:47:1 */
struct CMS_ContentInfo_st {
    ASN1_OBJECT *contentType;
    union {
        ASN1_OCTET_STRING *data;
        CMS_SignedData *signedData;
        CMS_EnvelopedData *envelopedData;
        CMS_DigestedData *digestedData;
        CMS_EncryptedData *encryptedData;
        CMS_AuthenticatedData *authenticatedData;
        CMS_CompressedData *compressedData;
        ASN1_TYPE *other;
        /* Other types ... */
        void *otherData;
    } d;
};

/** clang-extract: from crypto/cms/cms_local.h:105:1 */
struct CMS_EnvelopedData_st {
    int32_t version;
    CMS_OriginatorInfo *originatorInfo;
    STACK_OF(CMS_RecipientInfo) *recipientInfos;
    CMS_EncryptedContentInfo *encryptedContentInfo;
    STACK_OF(X509_ATTRIBUTE) *unprotectedAttrs;
};

/** clang-extract: from crypto/cms/cms_local.h:118:1 */
struct CMS_EncryptedContentInfo_st {
    ASN1_OBJECT *contentType;
    X509_ALGOR *contentEncryptionAlgorithm;
    ASN1_OCTET_STRING *encryptedContent;
    /* Content encryption algorithm and key */
    const EVP_CIPHER *cipher;
    unsigned char *key;
    size_t keylen;
    /* Set to 1 if we are debugging decrypt and don't fake keys for MMA */
    int debug;
    /* Set to 1 if we have no cert and need extra safety measures for MMA */
    int havenocert;
};

/** clang-extract: from crypto/cms/cms_local.h:132:1 */
struct CMS_RecipientInfo_st {
    int type;
    union {
        CMS_KeyTransRecipientInfo *ktri;
        CMS_KeyAgreeRecipientInfo *kari;
        CMS_KEKRecipientInfo *kekri;
        CMS_PasswordRecipientInfo *pwri;
        CMS_OtherRecipientInfo *ori;
    } d;
};

/** clang-extract: from crypto/cms/cms_local.h:220:1 */
struct CMS_PasswordRecipientInfo_st {
    int32_t version;
    X509_ALGOR *keyDerivationAlgorithm;
    X509_ALGOR *keyEncryptionAlgorithm;
    ASN1_OCTET_STRING *encryptedKey;
    /* Extra info: password to use */
    unsigned char *pass;
    size_t passlen;
};

/** clang-extract: from crypto/cms/cms_local.h:417:1 */
int cms_RecipientInfo_pwri_crypt(CMS_ContentInfo *cms, CMS_RecipientInfo *ri,
                                 int en_de);

/** clang-extract: from crypto/cms/cms_pwri.c:176:1 */
static int kek_unwrap_key(unsigned char *out, size_t *outlen,
                          const unsigned char *in, size_t inlen,
                          EVP_CIPHER_CTX *ctx)
{
    size_t blocklen = EVP_CIPHER_CTX_block_size(ctx);
    unsigned char *tmp;
    int outl, rv = 0;
    if (inlen < 2 * blocklen) {
        /* too small */
        return 0;
    }
    if (inlen % blocklen) {
        /* Invalid size */
        return 0;
    }
    if ((tmp = OPENSSL_malloc(inlen)) == NULL) {
        CMSerr(CMS_F_KEK_UNWRAP_KEY, ERR_R_MALLOC_FAILURE);
        return 0;
    }
    /* setup IV by decrypting last two blocks */
    if (!EVP_DecryptUpdate(ctx, tmp + inlen - 2 * blocklen, &outl,
                           in + inlen - 2 * blocklen, blocklen * 2)
        /*
         * Do a decrypt of last decrypted block to set IV to correct value
         * output it to start of buffer so we don't corrupt decrypted block
         * this works because buffer is at least two block lengths long.
         */
        || !EVP_DecryptUpdate(ctx, tmp, &outl,
                              tmp + inlen - blocklen, blocklen)
        /* Can now decrypt first n - 1 blocks */
        || !EVP_DecryptUpdate(ctx, tmp, &outl, in, inlen - blocklen)

        /* Reset IV to original value */
        || !EVP_DecryptInit_ex(ctx, NULL, NULL, NULL, NULL)
        /* Decrypt again */
        || !EVP_DecryptUpdate(ctx, tmp, &outl, tmp, inlen))
        goto err;
    /* Check check bytes */
    if (((tmp[1] ^ tmp[4]) & (tmp[2] ^ tmp[5]) & (tmp[3] ^ tmp[6])) != 0xff) {
        /* Check byte failure */
        goto err;
    }
    if (inlen < 4 + (size_t)tmp[0]) {
        /* Invalid length value */
        goto err;
    }
    *outlen = (size_t)tmp[0];
    memcpy(out, tmp + 4, *outlen);
    rv = 1;
 err:
    OPENSSL_clear_free(tmp, inlen);
    return rv;

}

/** clang-extract: from crypto/cms/cms_pwri.c:231:1 */
static int kek_wrap_key(unsigned char *out, size_t *outlen,
                        const unsigned char *in, size_t inlen,
                        EVP_CIPHER_CTX *ctx)
{
    size_t blocklen = EVP_CIPHER_CTX_block_size(ctx);
    size_t olen;
    int dummy;
    /*
     * First decide length of output buffer: need header and round up to
     * multiple of block length.
     */
    olen = (inlen + 4 + blocklen - 1) / blocklen;
    olen *= blocklen;
    if (olen < 2 * blocklen) {
        /* Key too small */
        return 0;
    }
    if (inlen > 0xFF) {
        /* Key too large */
        return 0;
    }
    if (out) {
        /* Set header */
        out[0] = (unsigned char)inlen;
        out[1] = in[0] ^ 0xFF;
        out[2] = in[1] ^ 0xFF;
        out[3] = in[2] ^ 0xFF;
        memcpy(out + 4, in, inlen);
        /* Add random padding to end */
        if (olen > inlen + 4
            && RAND_bytes(out + 4 + inlen, olen - 4 - inlen) <= 0)
            return 0;
        /* Encrypt twice */
        if (!EVP_EncryptUpdate(ctx, out, &dummy, out, olen)
            || !EVP_EncryptUpdate(ctx, out, &dummy, out, olen))
            return 0;
    }

    *outlen = olen;

    return 1;
}

/** clang-extract: from crypto/cms/cms_pwri.c:276:1 */
int cms_RecipientInfo_pwri_crypt_lp(CMS_ContentInfo *cms, CMS_RecipientInfo *ri,
                                 int en_de)
{
    CMS_EncryptedContentInfo *ec;
    CMS_PasswordRecipientInfo *pwri;
    int r = 0;
    X509_ALGOR *algtmp, *kekalg = NULL;
    EVP_CIPHER_CTX *kekctx = NULL;
    const EVP_CIPHER *kekcipher;
    unsigned char *key = NULL;
    size_t keylen;

    ec = cms->d.envelopedData->encryptedContentInfo;

    pwri = ri->d.pwri;

    if (!pwri->pass) {
        CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT, CMS_R_NO_PASSWORD);
        return 0;
    }
    algtmp = pwri->keyEncryptionAlgorithm;

    if (!algtmp || OBJ_obj2nid(algtmp->algorithm) != NID_id_alg_PWRI_KEK) {
        CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT,
               CMS_R_UNSUPPORTED_KEY_ENCRYPTION_ALGORITHM);
        return 0;
    }

    kekalg = ASN1_TYPE_unpack_sequence(ASN1_ITEM_rptr(X509_ALGOR),
                                       algtmp->parameter);

    if (kekalg == NULL) {
        CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT,
               CMS_R_INVALID_KEY_ENCRYPTION_PARAMETER);
        return 0;
    }

    kekcipher = EVP_get_cipherbyobj(kekalg->algorithm);

    if (!kekcipher) {
        CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT, CMS_R_UNKNOWN_CIPHER);
        return 0;
    }

    kekctx = EVP_CIPHER_CTX_new();
    if (kekctx == NULL) {
        CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT, ERR_R_MALLOC_FAILURE);
        return 0;
    }
    /* Fixup cipher based on AlgorithmIdentifier to set IV etc */
    if (!EVP_CipherInit_ex(kekctx, kekcipher, NULL, NULL, NULL, en_de))
        goto err;
    EVP_CIPHER_CTX_set_padding(kekctx, 0);
    if (EVP_CIPHER_asn1_to_param(kekctx, kekalg->parameter) <= 0) {
        CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT,
               CMS_R_CIPHER_PARAMETER_INITIALISATION_ERROR);
        goto err;
    }

    algtmp = pwri->keyDerivationAlgorithm;

    /* Finish password based key derivation to setup key in "ctx" */

    if (EVP_PBE_CipherInit(algtmp->algorithm,
                           (char *)pwri->pass, pwri->passlen,
                           algtmp->parameter, kekctx, en_de) < 0) {
        CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT, ERR_R_EVP_LIB);
        goto err;
    }

    /* Finally wrap/unwrap the key */

    if (en_de) {

        if (!kek_wrap_key(NULL, &keylen, ec->key, ec->keylen, kekctx))
            goto err;

        key = OPENSSL_malloc(keylen);

        if (key == NULL)
            goto err;

        if (!kek_wrap_key(key, &keylen, ec->key, ec->keylen, kekctx))
            goto err;
        pwri->encryptedKey->data = key;
        pwri->encryptedKey->length = keylen;
    } else {
        key = OPENSSL_malloc(pwri->encryptedKey->length);

        if (key == NULL) {
            CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT, ERR_R_MALLOC_FAILURE);
            goto err;
        }
        if (!kek_unwrap_key(key, &keylen,
                            pwri->encryptedKey->data,
                            pwri->encryptedKey->length, kekctx)) {
            CMSerr(CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT, CMS_R_UNWRAP_FAILURE);
            goto err;
        }

        OPENSSL_clear_free(ec->key, ec->keylen);
        ec->key = key;
        ec->keylen = keylen;

    }

    r = 1;

 err:

    EVP_CIPHER_CTX_free(kekctx);

    if (!r)
        OPENSSL_free(key);
    X509_ALGOR_free(kekalg);

    return r;

}

#endif
