import { Struct, Refiner } from '../struct';
/**
 * Ensure that a string or array has a length of zero.
 */
export declare function empty<T extends string | any[]>(struct: Struct<T>): Struct<T>;
/**
 * Ensure that a string or array has a length between `min` and `max`.
 */
export declare function length<T extends string | any[]>(struct: Struct<T>, min: number, max: number): Struct<T>;
/**
 * Ensure that a number is negative (not zero).
 */
export declare function negative<T extends number>(struct: Struct<T>): Struct<T>;
/**
 * Ensure that a number is non-negative (includes zero).
 */
export declare function nonnegative<T extends number>(struct: Struct<T>): Struct<T>;
/**
 * Ensure that a number is non-positive (includes zero).
 */
export declare function nonpositive<T extends number>(struct: Struct<T>): Struct<T>;
/**
 * Ensure that a string matches a regular expression.
 */
export declare function pattern<T extends string>(struct: Struct<T>, regexp: RegExp): Struct<T>;
/**
 * Ensure that a number is positive (not zero).
 */
export declare function positive<T extends number>(struct: Struct<T>): Struct<T>;
/**
 * Augment a `Struct` to add an additional refinement to the validation.
 *
 * The refiner function is guaranteed to receive a value of the struct's type,
 * because the struct's existing validation will already have passed. This
 * allows you to layer additional validation on top of existing structs.
 */
export declare function refinement<T, S>(name: string, struct: Struct<T, S>, refiner: Refiner<T, S>): Struct<T, S>;
//# sourceMappingURL=refinements.d.ts.map