import { Struct } from '../struct';
import { ObjectSchema, ObjectType } from '../utils';
/**
 * Augment a `Struct` to add an additional coercion step to its input.
 *
 * This allows you to transform input data before validating it, to increase the
 * likelihood that it passes validation—for example for default values, parsing
 * different formats, etc.
 *
 * Note: You must use `coerce(value, Struct)` on the value to have the coercion
 * take effect! Using simply `assert()` or `is()` will not use coercion.
 */
export declare function coercion<T, S>(struct: Struct<T, S>, coercer: Struct<T, S>['coercer']): Struct<T, S>;
/**
 * Augment a struct to replace `undefined` values with a default.
 *
 * Note: You must use `coerce(value, Struct)` on the value to have the coercion
 * take effect! Using simply `assert()` or `is()` will not use coercion.
 */
export declare function defaulted<T, S>(S: Struct<T, S>, fallback: any, strict?: true): Struct<T, S>;
/**
 * Augment a struct to mask its input to only properties defined in the struct.
 *
 * Note: You must use `coerce(value, Struct)` on the value to have the coercion
 * take effect! Using simply `assert()` or `is()` will not use coercion.
 */
export declare function masked<S extends ObjectSchema>(struct: Struct<ObjectType<S>, S>): Struct<ObjectType<S>, S>;
//# sourceMappingURL=coercions.d.ts.map