/**
 * A `StructFailure` represents a single specific failure in validation.
 */
export declare type Failure = {
    value: any;
    key: string | number | undefined;
    type: string;
    refinement: string | undefined;
    message: string;
    branch: Array<any>;
    path: Array<string | number>;
};
/**
 * `StructError` objects are thrown (or returned) when validation fails.
 *
 * Validation logic is design to exit early for maximum performance. The error
 * represents the first error encountered during validation. For more detail,
 * the `error.failures` property is a generator function that can be run to
 * continue validation and receive all the failures in the data.
 */
export declare class StructError extends TypeError {
    value: any;
    key: string | number | undefined;
    type: string;
    refinement: string | undefined;
    path: Array<number | string>;
    branch: Array<any>;
    failures: () => IterableIterator<Failure>;
    [key: string]: any;
    constructor(failure: Failure, iterable: Iterable<Failure>);
}
//# sourceMappingURL=error.d.ts.map