import * as React from 'react';
import { TypeOptions } from './../utils';
export interface ProgressBarProps {
    /**
     * The animation delay which determine when to close the toast
     */
    delay: number;
    /**
     * Whether or not the animation is running or paused
     */
    isRunning: boolean;
    /**
     * Func to close the current toast
     */
    closeToast: () => void;
    /**
     * Optional type : info, success ...
     */
    type: TypeOptions;
    /**
     * Hide or not the progress bar
     */
    hide?: boolean;
    /**
     * Optionnal className
     */
    className?: string | null;
    /**
     * Optionnal inline style
     */
    style?: React.CSSProperties;
    /**
     * Tell wether or not controlled progress bar is used
     */
    controlledProgress?: boolean;
    /**
     * Controlled progress value
     */
    progress?: number | string;
    /**
     * Support rtl content
     */
    rtl?: boolean;
    /**
     * Tell if the component is visible on screen or not
     */
    isIn?: boolean;
}
export declare function ProgressBar({ delay, isRunning, closeToast, type, hide, className, style: userStyle, controlledProgress, progress, rtl, isIn }: ProgressBarProps): JSX.Element;
export declare namespace ProgressBar {
    var defaultProps: {
        type: string;
        hide: boolean;
    };
}
