import { useState, useEffect, useRef, useCallback } from 'react';
import type { GroupBase } from 'react-select';
import sleep from 'sleep-promise';
import useIsMounted from 'react-is-mounted-hook';
import type { OptionsCache, OptionsCacheItem, UseAsyncPaginateBaseResult, UseAsyncPaginateBaseParams, ReduceOptions } from './types';
export declare const validateResponse: (console: Console, response: any) => void;
export declare const getInitialOptionsCache: <OptionType, Group extends GroupBase<OptionType>, Additional>({ options, defaultOptions, additional, defaultAdditional, }: UseAsyncPaginateBaseParams<OptionType, Group, Additional>) => OptionsCache<OptionType, Group, Additional>;
export declare const getInitialCache: <OptionType, Group extends GroupBase<OptionType>, Additional>(params: UseAsyncPaginateBaseParams<OptionType, Group, Additional>) => OptionsCacheItem<OptionType, Group, Additional>;
declare type MapOptionsCache<OptionType, Group extends GroupBase<OptionType>, Additional> = (prevCache: OptionsCache<OptionType, Group, Additional>) => OptionsCache<OptionType, Group, Additional>;
declare type SetOptionsCache<OptionType, Group extends GroupBase<OptionType>, Additional> = (stateMapper: MapOptionsCache<OptionType, Group, Additional>) => void;
export declare const requestOptions: <OptionType, Group extends GroupBase<OptionType>, Additional>(paramsRef: {
    current: UseAsyncPaginateBaseParams<OptionType, Group, Additional>;
}, optionsCacheRef: {
    current: OptionsCache<OptionType, Group, Additional>;
}, debounceTimeout: number, sleepParam: typeof sleep, setOptionsCache: SetOptionsCache<OptionType, Group, Additional>, validateResponseParam: typeof validateResponse, reduceOptions: ReduceOptions<OptionType, Group, Additional>) => Promise<void>;
export declare const increaseStateId: (prevStateId: number) => number;
export declare const useAsyncPaginateBasePure: <OptionType, Group extends GroupBase<OptionType>, Additional>(useRefParam: typeof useRef, useStateParam: typeof useState, useEffectParam: typeof useEffect, useCallbackParam: typeof useCallback, useIsMountedParam: typeof useIsMounted, validateResponseParam: typeof validateResponse, getInitialOptionsCacheParam: typeof getInitialOptionsCache, requestOptionsParam: typeof requestOptions, params: UseAsyncPaginateBaseParams<OptionType, Group, Additional>, deps?: ReadonlyArray<any>) => UseAsyncPaginateBaseResult<OptionType, Group>;
export declare const useAsyncPaginateBase: <OptionType, Group extends GroupBase<OptionType>, Additional>(params: UseAsyncPaginateBaseParams<OptionType, Group, Additional>, deps?: ReadonlyArray<any>) => UseAsyncPaginateBaseResult<OptionType, Group>;
export {};
