'use strict';

/**
 * Debounces function execution.
 * @param {!function()} fn
 * @param {number} delay
 * @return {!function()}
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});
function debounce(fn, delay) {
  return function debounced() {
    var args = Array.prototype.slice.call(arguments, 0);
    cancelDebounce(debounced);
    debounced.id = setTimeout(function () {
      fn.apply(null, args);
    }, delay);
  };
}

/**
 * Cancels the scheduled debounced function.
 * @param {function()} debounced
 */
function cancelDebounce(debounced) {
  clearTimeout(debounced.id);
}

exports.default = debounce;
exports.cancelDebounce = cancelDebounce;
exports.debounce = debounce;