#
# spec file for package python-shaptools
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/

%if 0%{?suse_version} < 1500
%bcond_with test
%else
%bcond_without test
%endif

%if 0%{?sle_version} <= 150300 && !0%{?is_opensuse}
%bcond_without python2
%else
%bcond_with python2
%endif

%{?!python_module:%define python_module() python-%{**} python3-%{**}}
Name:           python-shaptools
Version:        0
Release:        0
Summary:        Python tools to interact with SAP HANA utilities
License:        Apache-2.0
Group:          Development/Languages/Python
Url:            https://github.com/SUSE/shaptools
Source:         %{name}-%{version}.tar.gz
%if %{with test}
BuildRequires:  %{python_module pytest}
%endif
%if %{with python2}
BuildRequires:  python-mock
%endif
BuildRequires:  %{python_module setuptools}
BuildRequires:  fdupes
BuildRequires:  python-rpm-macros
Requires(post): update-alternatives
Requires(postun): update-alternatives
BuildArch:      noarch
%python_subpackages

%description
API to expose SAP HANA functionalities

%package -n python3-shaptools-venv-salt-minion
Summary:        Shaptools integration with Salt Bundle
Group:          Development/Languages/Python
Requires:       venv-salt-minion
Requires:       python3-shaptools
Supplements:    packageand(python3-shaptools:venv-salt-minion)
BuildArch:      noarch

%description -n python3-shaptools-venv-salt-minion
Integration of shaptools library inside the Salt Bundle, aka venv-salt-minion.

%prep
%setup -q -n %{name}-%{version}

%build
%python_build

%install
%python_install
%python_expand %fdupes %{buildroot}%{$python_sitelib}
# do not install tests
%python_expand rm -r %{buildroot}%{$python_sitelib}/tests
%python_clone -a %{buildroot}%{_bindir}/shapcli

%post
%python_install_alternative shapcli

%postun
%python_uninstall_alternative shapcli

%post -n python3-shaptools-venv-salt-minion
BUNDLE_SITELIB=
if [ -f /usr/lib/venv-salt-minion/bin/python ]
then
    BUNDLE_SITELIB=`/usr/lib/venv-salt-minion/bin/python -c "import sysconfig as s; print(s.get_paths().get('purelib'))"`
fi
if [ ! -z "$BUNDLE_SITELIB" ] && [ -d "%{python_sitelib}/shaptools" ] && [ ! -f "$BUNDLE_SITELIB/shaptools" ]
then
    ln -s %{python_sitelib}/shaptools/ $BUNDLE_SITELIB/shaptools
fi

%postun -n python3-shaptools-venv-salt-minion
BUNDLE_SITELIB=
if [ -f /usr/lib/venv-salt-minion/bin/python ]
then
    BUNDLE_SITELIB=`/usr/lib/venv-salt-minion/bin/python -c "import sysconfig as s; print(s.get_paths().get('purelib'))"`
fi
if [ ! -z "$BUNDLE_SITELIB" ] && [ -L "$BUNDLE_SITELIB/shaptools" ]
then
    rm $BUNDLE_SITELIB/shaptools
fi


%if %{with test}
%check
%pytest tests
%endif

%files %{python_files}
%if 0%{?sle_version:1} && 0%{?sle_version} < 120300
%doc README.md LICENSE
%else
%doc README.md
%license LICENSE
%endif
%{python_sitelib}/*
%python_alternative %{_bindir}/shapcli

%files -n python3-shaptools-venv-salt-minion

%changelog
