// Code generated by go-swagger; DO NOT EDIT.

package user_preferences

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new user preferences API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for user preferences API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetUserPreferences(opts ...ClientOption) (*GetUserPreferencesOK, error)
	GetUserPreferencesWithParams(params *GetUserPreferencesParams, opts ...ClientOption) (*GetUserPreferencesOK, error)

	PatchUserPreferences(body *models.PatchPrefsCmd, opts ...ClientOption) (*PatchUserPreferencesOK, error)
	PatchUserPreferencesWithParams(params *PatchUserPreferencesParams, opts ...ClientOption) (*PatchUserPreferencesOK, error)

	UpdateUserPreferences(body *models.UpdatePrefsCmd, opts ...ClientOption) (*UpdateUserPreferencesOK, error)
	UpdateUserPreferencesWithParams(params *UpdateUserPreferencesParams, opts ...ClientOption) (*UpdateUserPreferencesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetUserPreferences gets user preferences
*/
func (a *Client) GetUserPreferences(opts ...ClientOption) (*GetUserPreferencesOK, error) {
	params := NewGetUserPreferencesParams()
	return a.GetUserPreferencesWithParams(params, opts...)
}

func (a *Client) GetUserPreferencesWithParams(params *GetUserPreferencesParams, opts ...ClientOption) (*GetUserPreferencesOK, error) {
	if params == nil {
		params = NewGetUserPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserPreferences",
		Method:             "GET",
		PathPattern:        "/user/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PatchUserPreferences patches user preferences
*/
func (a *Client) PatchUserPreferences(body *models.PatchPrefsCmd, opts ...ClientOption) (*PatchUserPreferencesOK, error) {
	params := NewPatchUserPreferencesParams().WithBody(body)
	return a.PatchUserPreferencesWithParams(params, opts...)
}

func (a *Client) PatchUserPreferencesWithParams(params *PatchUserPreferencesParams, opts ...ClientOption) (*PatchUserPreferencesOK, error) {
	if params == nil {
		params = NewPatchUserPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "patchUserPreferences",
		Method:             "PATCH",
		PathPattern:        "/user/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PatchUserPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PatchUserPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for patchUserPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateUserPreferences updates user preferences

Omitting a key (`theme`, `homeDashboardId`, `timezone`) will cause the current value to be replaced with the system default value.
*/
func (a *Client) UpdateUserPreferences(body *models.UpdatePrefsCmd, opts ...ClientOption) (*UpdateUserPreferencesOK, error) {
	params := NewUpdateUserPreferencesParams().WithBody(body)
	return a.UpdateUserPreferencesWithParams(params, opts...)
}

func (a *Client) UpdateUserPreferencesWithParams(params *UpdateUserPreferencesParams, opts ...ClientOption) (*UpdateUserPreferencesOK, error) {
	if params == nil {
		params = NewUpdateUserPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateUserPreferences",
		Method:             "PUT",
		PathPattern:        "/user/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateUserPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateUserPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateUserPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
