// Code generated by go-swagger; DO NOT EDIT.

package teams

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SearchTeamsReader is a Reader for the SearchTeams structure.
type SearchTeamsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchTeamsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchTeamsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSearchTeamsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSearchTeamsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSearchTeamsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /teams/search] searchTeams", response, response.Code())
	}
}

// NewSearchTeamsOK creates a SearchTeamsOK with default headers values
func NewSearchTeamsOK() *SearchTeamsOK {
	return &SearchTeamsOK{}
}

/*
SearchTeamsOK describes a response with status code 200, with default header values.

(empty)
*/
type SearchTeamsOK struct {
	Payload *models.SearchTeamQueryResult
}

// IsSuccess returns true when this search teams Ok response has a 2xx status code
func (o *SearchTeamsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search teams Ok response has a 3xx status code
func (o *SearchTeamsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search teams Ok response has a 4xx status code
func (o *SearchTeamsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search teams Ok response has a 5xx status code
func (o *SearchTeamsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search teams Ok response a status code equal to that given
func (o *SearchTeamsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search teams Ok response
func (o *SearchTeamsOK) Code() int {
	return 200
}

func (o *SearchTeamsOK) Error() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsOk  %+v", 200, o.Payload)
}

func (o *SearchTeamsOK) String() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsOk  %+v", 200, o.Payload)
}

func (o *SearchTeamsOK) GetPayload() *models.SearchTeamQueryResult {
	return o.Payload
}

func (o *SearchTeamsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SearchTeamQueryResult)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchTeamsUnauthorized creates a SearchTeamsUnauthorized with default headers values
func NewSearchTeamsUnauthorized() *SearchTeamsUnauthorized {
	return &SearchTeamsUnauthorized{}
}

/*
SearchTeamsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SearchTeamsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search teams unauthorized response has a 2xx status code
func (o *SearchTeamsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search teams unauthorized response has a 3xx status code
func (o *SearchTeamsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search teams unauthorized response has a 4xx status code
func (o *SearchTeamsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this search teams unauthorized response has a 5xx status code
func (o *SearchTeamsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this search teams unauthorized response a status code equal to that given
func (o *SearchTeamsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the search teams unauthorized response
func (o *SearchTeamsUnauthorized) Code() int {
	return 401
}

func (o *SearchTeamsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsUnauthorized  %+v", 401, o.Payload)
}

func (o *SearchTeamsUnauthorized) String() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsUnauthorized  %+v", 401, o.Payload)
}

func (o *SearchTeamsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchTeamsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchTeamsForbidden creates a SearchTeamsForbidden with default headers values
func NewSearchTeamsForbidden() *SearchTeamsForbidden {
	return &SearchTeamsForbidden{}
}

/*
SearchTeamsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SearchTeamsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search teams forbidden response has a 2xx status code
func (o *SearchTeamsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search teams forbidden response has a 3xx status code
func (o *SearchTeamsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search teams forbidden response has a 4xx status code
func (o *SearchTeamsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this search teams forbidden response has a 5xx status code
func (o *SearchTeamsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this search teams forbidden response a status code equal to that given
func (o *SearchTeamsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the search teams forbidden response
func (o *SearchTeamsForbidden) Code() int {
	return 403
}

func (o *SearchTeamsForbidden) Error() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsForbidden  %+v", 403, o.Payload)
}

func (o *SearchTeamsForbidden) String() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsForbidden  %+v", 403, o.Payload)
}

func (o *SearchTeamsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchTeamsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchTeamsInternalServerError creates a SearchTeamsInternalServerError with default headers values
func NewSearchTeamsInternalServerError() *SearchTeamsInternalServerError {
	return &SearchTeamsInternalServerError{}
}

/*
SearchTeamsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SearchTeamsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search teams internal server error response has a 2xx status code
func (o *SearchTeamsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search teams internal server error response has a 3xx status code
func (o *SearchTeamsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search teams internal server error response has a 4xx status code
func (o *SearchTeamsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this search teams internal server error response has a 5xx status code
func (o *SearchTeamsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this search teams internal server error response a status code equal to that given
func (o *SearchTeamsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the search teams internal server error response
func (o *SearchTeamsInternalServerError) Code() int {
	return 500
}

func (o *SearchTeamsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsInternalServerError  %+v", 500, o.Payload)
}

func (o *SearchTeamsInternalServerError) String() string {
	return fmt.Sprintf("[GET /teams/search][%d] searchTeamsInternalServerError  %+v", 500, o.Payload)
}

func (o *SearchTeamsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchTeamsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
