// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewSendReportParams creates a new SendReportParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSendReportParams() *SendReportParams {
	return &SendReportParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSendReportParamsWithTimeout creates a new SendReportParams object
// with the ability to set a timeout on a request.
func NewSendReportParamsWithTimeout(timeout time.Duration) *SendReportParams {
	return &SendReportParams{
		timeout: timeout,
	}
}

// NewSendReportParamsWithContext creates a new SendReportParams object
// with the ability to set a context for a request.
func NewSendReportParamsWithContext(ctx context.Context) *SendReportParams {
	return &SendReportParams{
		Context: ctx,
	}
}

// NewSendReportParamsWithHTTPClient creates a new SendReportParams object
// with the ability to set a custom HTTPClient for a request.
func NewSendReportParamsWithHTTPClient(client *http.Client) *SendReportParams {
	return &SendReportParams{
		HTTPClient: client,
	}
}

/*
SendReportParams contains all the parameters to send to the API endpoint

	for the send report operation.

	Typically these are written to a http.Request.
*/
type SendReportParams struct {

	// Body.
	Body *models.ReportEmailDTO

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the send report params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SendReportParams) WithDefaults() *SendReportParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the send report params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SendReportParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the send report params
func (o *SendReportParams) WithTimeout(timeout time.Duration) *SendReportParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the send report params
func (o *SendReportParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the send report params
func (o *SendReportParams) WithContext(ctx context.Context) *SendReportParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the send report params
func (o *SendReportParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the send report params
func (o *SendReportParams) WithHTTPClient(client *http.Client) *SendReportParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the send report params
func (o *SendReportParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the send report params
func (o *SendReportParams) WithBody(body *models.ReportEmailDTO) *SendReportParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the send report params
func (o *SendReportParams) SetBody(body *models.ReportEmailDTO) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *SendReportParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
