// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SearchOrgsReader is a Reader for the SearchOrgs structure.
type SearchOrgsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchOrgsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchOrgsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSearchOrgsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSearchOrgsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewSearchOrgsConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSearchOrgsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /orgs] searchOrgs", response, response.Code())
	}
}

// NewSearchOrgsOK creates a SearchOrgsOK with default headers values
func NewSearchOrgsOK() *SearchOrgsOK {
	return &SearchOrgsOK{}
}

/*
SearchOrgsOK describes a response with status code 200, with default header values.

(empty)
*/
type SearchOrgsOK struct {
	Payload []*models.OrgDTO
}

// IsSuccess returns true when this search orgs Ok response has a 2xx status code
func (o *SearchOrgsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search orgs Ok response has a 3xx status code
func (o *SearchOrgsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search orgs Ok response has a 4xx status code
func (o *SearchOrgsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search orgs Ok response has a 5xx status code
func (o *SearchOrgsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search orgs Ok response a status code equal to that given
func (o *SearchOrgsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search orgs Ok response
func (o *SearchOrgsOK) Code() int {
	return 200
}

func (o *SearchOrgsOK) Error() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsOk  %+v", 200, o.Payload)
}

func (o *SearchOrgsOK) String() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsOk  %+v", 200, o.Payload)
}

func (o *SearchOrgsOK) GetPayload() []*models.OrgDTO {
	return o.Payload
}

func (o *SearchOrgsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchOrgsUnauthorized creates a SearchOrgsUnauthorized with default headers values
func NewSearchOrgsUnauthorized() *SearchOrgsUnauthorized {
	return &SearchOrgsUnauthorized{}
}

/*
SearchOrgsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SearchOrgsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search orgs unauthorized response has a 2xx status code
func (o *SearchOrgsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search orgs unauthorized response has a 3xx status code
func (o *SearchOrgsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search orgs unauthorized response has a 4xx status code
func (o *SearchOrgsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this search orgs unauthorized response has a 5xx status code
func (o *SearchOrgsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this search orgs unauthorized response a status code equal to that given
func (o *SearchOrgsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the search orgs unauthorized response
func (o *SearchOrgsUnauthorized) Code() int {
	return 401
}

func (o *SearchOrgsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsUnauthorized  %+v", 401, o.Payload)
}

func (o *SearchOrgsUnauthorized) String() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsUnauthorized  %+v", 401, o.Payload)
}

func (o *SearchOrgsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchOrgsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchOrgsForbidden creates a SearchOrgsForbidden with default headers values
func NewSearchOrgsForbidden() *SearchOrgsForbidden {
	return &SearchOrgsForbidden{}
}

/*
SearchOrgsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SearchOrgsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search orgs forbidden response has a 2xx status code
func (o *SearchOrgsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search orgs forbidden response has a 3xx status code
func (o *SearchOrgsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search orgs forbidden response has a 4xx status code
func (o *SearchOrgsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this search orgs forbidden response has a 5xx status code
func (o *SearchOrgsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this search orgs forbidden response a status code equal to that given
func (o *SearchOrgsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the search orgs forbidden response
func (o *SearchOrgsForbidden) Code() int {
	return 403
}

func (o *SearchOrgsForbidden) Error() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsForbidden  %+v", 403, o.Payload)
}

func (o *SearchOrgsForbidden) String() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsForbidden  %+v", 403, o.Payload)
}

func (o *SearchOrgsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchOrgsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchOrgsConflict creates a SearchOrgsConflict with default headers values
func NewSearchOrgsConflict() *SearchOrgsConflict {
	return &SearchOrgsConflict{}
}

/*
SearchOrgsConflict describes a response with status code 409, with default header values.

ConflictError
*/
type SearchOrgsConflict struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search orgs conflict response has a 2xx status code
func (o *SearchOrgsConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search orgs conflict response has a 3xx status code
func (o *SearchOrgsConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search orgs conflict response has a 4xx status code
func (o *SearchOrgsConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this search orgs conflict response has a 5xx status code
func (o *SearchOrgsConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this search orgs conflict response a status code equal to that given
func (o *SearchOrgsConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the search orgs conflict response
func (o *SearchOrgsConflict) Code() int {
	return 409
}

func (o *SearchOrgsConflict) Error() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsConflict  %+v", 409, o.Payload)
}

func (o *SearchOrgsConflict) String() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsConflict  %+v", 409, o.Payload)
}

func (o *SearchOrgsConflict) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchOrgsConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchOrgsInternalServerError creates a SearchOrgsInternalServerError with default headers values
func NewSearchOrgsInternalServerError() *SearchOrgsInternalServerError {
	return &SearchOrgsInternalServerError{}
}

/*
SearchOrgsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SearchOrgsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search orgs internal server error response has a 2xx status code
func (o *SearchOrgsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search orgs internal server error response has a 3xx status code
func (o *SearchOrgsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search orgs internal server error response has a 4xx status code
func (o *SearchOrgsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this search orgs internal server error response has a 5xx status code
func (o *SearchOrgsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this search orgs internal server error response a status code equal to that given
func (o *SearchOrgsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the search orgs internal server error response
func (o *SearchOrgsInternalServerError) Code() int {
	return 500
}

func (o *SearchOrgsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsInternalServerError  %+v", 500, o.Payload)
}

func (o *SearchOrgsInternalServerError) String() string {
	return fmt.Sprintf("[GET /orgs][%d] searchOrgsInternalServerError  %+v", 500, o.Payload)
}

func (o *SearchOrgsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchOrgsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
