// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TLSConfig TLSConfig configures the options for TLS connections.
//
// swagger:model TLSConfig
type TLSConfig struct {

	// Text of the CA cert to use for the targets.
	Ca string `json:"ca,omitempty"`

	// The CA cert to use for the targets.
	CaFile string `json:"ca_file,omitempty"`

	// Text of the client cert file for the targets.
	Cert string `json:"cert,omitempty"`

	// The client cert file for the targets.
	CertFile string `json:"cert_file,omitempty"`

	// Disable target certificate validation.
	InsecureSkipVerify bool `json:"insecure_skip_verify,omitempty"`

	// key
	Key Secret `json:"key,omitempty"`

	// The client key file for the targets.
	KeyFile string `json:"key_file,omitempty"`

	// max version
	MaxVersion TLSVersion `json:"max_version,omitempty"`

	// min version
	MinVersion TLSVersion `json:"min_version,omitempty"`

	// Used to verify the hostname for the targets.
	ServerName string `json:"server_name,omitempty"`
}

// Validate validates this TLS config
func (m *TLSConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TLSConfig) validateKey(formats strfmt.Registry) error {
	if swag.IsZero(m.Key) { // not required
		return nil
	}

	if err := m.Key.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("key")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("key")
		}
		return err
	}

	return nil
}

func (m *TLSConfig) validateMaxVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxVersion) { // not required
		return nil
	}

	if err := m.MaxVersion.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("max_version")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("max_version")
		}
		return err
	}

	return nil
}

func (m *TLSConfig) validateMinVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.MinVersion) { // not required
		return nil
	}

	if err := m.MinVersion.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("min_version")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("min_version")
		}
		return err
	}

	return nil
}

// ContextValidate validate this TLS config based on the context it is used
func (m *TLSConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TLSConfig) contextValidateKey(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Key) { // not required
		return nil
	}

	if err := m.Key.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("key")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("key")
		}
		return err
	}

	return nil
}

func (m *TLSConfig) contextValidateMaxVersion(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.MaxVersion) { // not required
		return nil
	}

	if err := m.MaxVersion.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("max_version")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("max_version")
		}
		return err
	}

	return nil
}

func (m *TLSConfig) contextValidateMinVersion(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.MinVersion) { // not required
		return nil
	}

	if err := m.MinVersion.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("min_version")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("min_version")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TLSConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TLSConfig) UnmarshalBinary(b []byte) error {
	var res TLSConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
