// Code generated by go-swagger; DO NOT EDIT.

package recording_rules

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateRecordingRuleReader is a Reader for the CreateRecordingRule structure.
type CreateRecordingRuleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateRecordingRuleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateRecordingRuleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewCreateRecordingRuleUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateRecordingRuleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreateRecordingRuleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateRecordingRuleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /recording-rules] createRecordingRule", response, response.Code())
	}
}

// NewCreateRecordingRuleOK creates a CreateRecordingRuleOK with default headers values
func NewCreateRecordingRuleOK() *CreateRecordingRuleOK {
	return &CreateRecordingRuleOK{}
}

/*
CreateRecordingRuleOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateRecordingRuleOK struct {
	Payload *models.RecordingRuleJSON
}

// IsSuccess returns true when this create recording rule Ok response has a 2xx status code
func (o *CreateRecordingRuleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create recording rule Ok response has a 3xx status code
func (o *CreateRecordingRuleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create recording rule Ok response has a 4xx status code
func (o *CreateRecordingRuleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create recording rule Ok response has a 5xx status code
func (o *CreateRecordingRuleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create recording rule Ok response a status code equal to that given
func (o *CreateRecordingRuleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create recording rule Ok response
func (o *CreateRecordingRuleOK) Code() int {
	return 200
}

func (o *CreateRecordingRuleOK) Error() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleOk  %+v", 200, o.Payload)
}

func (o *CreateRecordingRuleOK) String() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleOk  %+v", 200, o.Payload)
}

func (o *CreateRecordingRuleOK) GetPayload() *models.RecordingRuleJSON {
	return o.Payload
}

func (o *CreateRecordingRuleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RecordingRuleJSON)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRecordingRuleUnauthorized creates a CreateRecordingRuleUnauthorized with default headers values
func NewCreateRecordingRuleUnauthorized() *CreateRecordingRuleUnauthorized {
	return &CreateRecordingRuleUnauthorized{}
}

/*
CreateRecordingRuleUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateRecordingRuleUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create recording rule unauthorized response has a 2xx status code
func (o *CreateRecordingRuleUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create recording rule unauthorized response has a 3xx status code
func (o *CreateRecordingRuleUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create recording rule unauthorized response has a 4xx status code
func (o *CreateRecordingRuleUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create recording rule unauthorized response has a 5xx status code
func (o *CreateRecordingRuleUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create recording rule unauthorized response a status code equal to that given
func (o *CreateRecordingRuleUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create recording rule unauthorized response
func (o *CreateRecordingRuleUnauthorized) Code() int {
	return 401
}

func (o *CreateRecordingRuleUnauthorized) Error() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleUnauthorized  %+v", 401, o.Payload)
}

func (o *CreateRecordingRuleUnauthorized) String() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleUnauthorized  %+v", 401, o.Payload)
}

func (o *CreateRecordingRuleUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateRecordingRuleUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRecordingRuleForbidden creates a CreateRecordingRuleForbidden with default headers values
func NewCreateRecordingRuleForbidden() *CreateRecordingRuleForbidden {
	return &CreateRecordingRuleForbidden{}
}

/*
CreateRecordingRuleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateRecordingRuleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create recording rule forbidden response has a 2xx status code
func (o *CreateRecordingRuleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create recording rule forbidden response has a 3xx status code
func (o *CreateRecordingRuleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create recording rule forbidden response has a 4xx status code
func (o *CreateRecordingRuleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create recording rule forbidden response has a 5xx status code
func (o *CreateRecordingRuleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create recording rule forbidden response a status code equal to that given
func (o *CreateRecordingRuleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create recording rule forbidden response
func (o *CreateRecordingRuleForbidden) Code() int {
	return 403
}

func (o *CreateRecordingRuleForbidden) Error() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleForbidden  %+v", 403, o.Payload)
}

func (o *CreateRecordingRuleForbidden) String() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleForbidden  %+v", 403, o.Payload)
}

func (o *CreateRecordingRuleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateRecordingRuleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRecordingRuleNotFound creates a CreateRecordingRuleNotFound with default headers values
func NewCreateRecordingRuleNotFound() *CreateRecordingRuleNotFound {
	return &CreateRecordingRuleNotFound{}
}

/*
CreateRecordingRuleNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type CreateRecordingRuleNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create recording rule not found response has a 2xx status code
func (o *CreateRecordingRuleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create recording rule not found response has a 3xx status code
func (o *CreateRecordingRuleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create recording rule not found response has a 4xx status code
func (o *CreateRecordingRuleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create recording rule not found response has a 5xx status code
func (o *CreateRecordingRuleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create recording rule not found response a status code equal to that given
func (o *CreateRecordingRuleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create recording rule not found response
func (o *CreateRecordingRuleNotFound) Code() int {
	return 404
}

func (o *CreateRecordingRuleNotFound) Error() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleNotFound  %+v", 404, o.Payload)
}

func (o *CreateRecordingRuleNotFound) String() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleNotFound  %+v", 404, o.Payload)
}

func (o *CreateRecordingRuleNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateRecordingRuleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRecordingRuleInternalServerError creates a CreateRecordingRuleInternalServerError with default headers values
func NewCreateRecordingRuleInternalServerError() *CreateRecordingRuleInternalServerError {
	return &CreateRecordingRuleInternalServerError{}
}

/*
CreateRecordingRuleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateRecordingRuleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create recording rule internal server error response has a 2xx status code
func (o *CreateRecordingRuleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create recording rule internal server error response has a 3xx status code
func (o *CreateRecordingRuleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create recording rule internal server error response has a 4xx status code
func (o *CreateRecordingRuleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create recording rule internal server error response has a 5xx status code
func (o *CreateRecordingRuleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create recording rule internal server error response a status code equal to that given
func (o *CreateRecordingRuleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create recording rule internal server error response
func (o *CreateRecordingRuleInternalServerError) Code() int {
	return 500
}

func (o *CreateRecordingRuleInternalServerError) Error() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRecordingRuleInternalServerError) String() string {
	return fmt.Sprintf("[POST /recording-rules][%d] createRecordingRuleInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRecordingRuleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateRecordingRuleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
