// Code generated by go-swagger; DO NOT EDIT.

package dashboard_versions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetDashboardVersionByIDReader is a Reader for the GetDashboardVersionByID structure.
type GetDashboardVersionByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDashboardVersionByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDashboardVersionByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetDashboardVersionByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetDashboardVersionByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetDashboardVersionByIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDashboardVersionByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}] getDashboardVersionByID", response, response.Code())
	}
}

// NewGetDashboardVersionByIDOK creates a GetDashboardVersionByIDOK with default headers values
func NewGetDashboardVersionByIDOK() *GetDashboardVersionByIDOK {
	return &GetDashboardVersionByIDOK{}
}

/*
GetDashboardVersionByIDOK describes a response with status code 200, with default header values.

(empty)
*/
type GetDashboardVersionByIDOK struct {
	Payload *models.DashboardVersionMeta
}

// IsSuccess returns true when this get dashboard version by Id Ok response has a 2xx status code
func (o *GetDashboardVersionByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get dashboard version by Id Ok response has a 3xx status code
func (o *GetDashboardVersionByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard version by Id Ok response has a 4xx status code
func (o *GetDashboardVersionByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get dashboard version by Id Ok response has a 5xx status code
func (o *GetDashboardVersionByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get dashboard version by Id Ok response a status code equal to that given
func (o *GetDashboardVersionByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get dashboard version by Id Ok response
func (o *GetDashboardVersionByIDOK) Code() int {
	return 200
}

func (o *GetDashboardVersionByIDOK) Error() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdOk  %+v", 200, o.Payload)
}

func (o *GetDashboardVersionByIDOK) String() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdOk  %+v", 200, o.Payload)
}

func (o *GetDashboardVersionByIDOK) GetPayload() *models.DashboardVersionMeta {
	return o.Payload
}

func (o *GetDashboardVersionByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DashboardVersionMeta)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDashboardVersionByIDUnauthorized creates a GetDashboardVersionByIDUnauthorized with default headers values
func NewGetDashboardVersionByIDUnauthorized() *GetDashboardVersionByIDUnauthorized {
	return &GetDashboardVersionByIDUnauthorized{}
}

/*
GetDashboardVersionByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetDashboardVersionByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get dashboard version by Id unauthorized response has a 2xx status code
func (o *GetDashboardVersionByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get dashboard version by Id unauthorized response has a 3xx status code
func (o *GetDashboardVersionByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard version by Id unauthorized response has a 4xx status code
func (o *GetDashboardVersionByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get dashboard version by Id unauthorized response has a 5xx status code
func (o *GetDashboardVersionByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get dashboard version by Id unauthorized response a status code equal to that given
func (o *GetDashboardVersionByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get dashboard version by Id unauthorized response
func (o *GetDashboardVersionByIDUnauthorized) Code() int {
	return 401
}

func (o *GetDashboardVersionByIDUnauthorized) Error() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *GetDashboardVersionByIDUnauthorized) String() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *GetDashboardVersionByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDashboardVersionByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDashboardVersionByIDForbidden creates a GetDashboardVersionByIDForbidden with default headers values
func NewGetDashboardVersionByIDForbidden() *GetDashboardVersionByIDForbidden {
	return &GetDashboardVersionByIDForbidden{}
}

/*
GetDashboardVersionByIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetDashboardVersionByIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get dashboard version by Id forbidden response has a 2xx status code
func (o *GetDashboardVersionByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get dashboard version by Id forbidden response has a 3xx status code
func (o *GetDashboardVersionByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard version by Id forbidden response has a 4xx status code
func (o *GetDashboardVersionByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get dashboard version by Id forbidden response has a 5xx status code
func (o *GetDashboardVersionByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get dashboard version by Id forbidden response a status code equal to that given
func (o *GetDashboardVersionByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get dashboard version by Id forbidden response
func (o *GetDashboardVersionByIDForbidden) Code() int {
	return 403
}

func (o *GetDashboardVersionByIDForbidden) Error() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetDashboardVersionByIDForbidden) String() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetDashboardVersionByIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDashboardVersionByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDashboardVersionByIDNotFound creates a GetDashboardVersionByIDNotFound with default headers values
func NewGetDashboardVersionByIDNotFound() *GetDashboardVersionByIDNotFound {
	return &GetDashboardVersionByIDNotFound{}
}

/*
GetDashboardVersionByIDNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetDashboardVersionByIDNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get dashboard version by Id not found response has a 2xx status code
func (o *GetDashboardVersionByIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get dashboard version by Id not found response has a 3xx status code
func (o *GetDashboardVersionByIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard version by Id not found response has a 4xx status code
func (o *GetDashboardVersionByIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get dashboard version by Id not found response has a 5xx status code
func (o *GetDashboardVersionByIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get dashboard version by Id not found response a status code equal to that given
func (o *GetDashboardVersionByIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get dashboard version by Id not found response
func (o *GetDashboardVersionByIDNotFound) Code() int {
	return 404
}

func (o *GetDashboardVersionByIDNotFound) Error() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdNotFound  %+v", 404, o.Payload)
}

func (o *GetDashboardVersionByIDNotFound) String() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdNotFound  %+v", 404, o.Payload)
}

func (o *GetDashboardVersionByIDNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDashboardVersionByIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDashboardVersionByIDInternalServerError creates a GetDashboardVersionByIDInternalServerError with default headers values
func NewGetDashboardVersionByIDInternalServerError() *GetDashboardVersionByIDInternalServerError {
	return &GetDashboardVersionByIDInternalServerError{}
}

/*
GetDashboardVersionByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetDashboardVersionByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get dashboard version by Id internal server error response has a 2xx status code
func (o *GetDashboardVersionByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get dashboard version by Id internal server error response has a 3xx status code
func (o *GetDashboardVersionByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get dashboard version by Id internal server error response has a 4xx status code
func (o *GetDashboardVersionByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get dashboard version by Id internal server error response has a 5xx status code
func (o *GetDashboardVersionByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get dashboard version by Id internal server error response a status code equal to that given
func (o *GetDashboardVersionByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get dashboard version by Id internal server error response
func (o *GetDashboardVersionByIDInternalServerError) Code() int {
	return 500
}

func (o *GetDashboardVersionByIDInternalServerError) Error() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDashboardVersionByIDInternalServerError) String() string {
	return fmt.Sprintf("[GET /dashboards/id/{DashboardID}/versions/{DashboardVersionID}][%d] getDashboardVersionByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDashboardVersionByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDashboardVersionByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
