// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// IDatacenterClient ...
type IDatacenterClient interface {
	// GetByID retrieves a datacenter by its ID. If the datacenter does not exist, nil is returned.
	GetByID(ctx context.Context, id int64) (*Datacenter, *Response, error)
	// GetByName retrieves a datacenter by its name. If the datacenter does not exist, nil is returned.
	GetByName(ctx context.Context, name string) (*Datacenter, *Response, error)
	// Get retrieves a datacenter by its ID if the input can be parsed as an integer, otherwise it
	// retrieves a datacenter by its name. If the datacenter does not exist, nil is returned.
	Get(ctx context.Context, idOrName string) (*Datacenter, *Response, error)
	// List returns a list of datacenters for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	List(ctx context.Context, opts DatacenterListOpts) ([]*Datacenter, *Response, error)
	// All returns all datacenters.
	All(ctx context.Context) ([]*Datacenter, error)
	// AllWithOpts returns all datacenters for the given options.
	AllWithOpts(ctx context.Context, opts DatacenterListOpts) ([]*Datacenter, error)
}
