// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package ebpfcommon

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpfConnectionInfoT struct {
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type bpfHttp2GrpcRequestT struct {
	Flags           uint8
	Ssl             uint8
	Type            uint8
	Pad0            [1]uint8
	ConnInfo        bpfConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Data            [256]uint8
	RetData         [64]uint8
	Len             int32
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	NewConnId uint64
	Tp        struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type bpfHttpInfoT struct {
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        bpfConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len     uint32
	RespLen uint32
	TaskTid uint32
	Status  uint16
	Buf     [256]uint8
	Pad     [6]uint8
}

type bpfHttpRequestTrace struct {
	Type              uint8
	Pad0              [1]uint8
	Status            uint16
	Method            [7]uint8
	Scheme            [10]uint8
	Pad1              [11]uint8
	GoStartMonotimeNs uint64
	StartMonotimeNs   uint64
	EndMonotimeNs     uint64
	ContentLength     int64
	ResponseLength    int64
	Path              [100]uint8
	Host              [100]uint8
	Tp                struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Conn bpfConnectionInfoT
	Pid  struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
}

type bpfKafkaClientReqT struct {
	Type            uint8
	Pad             [7]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Buf             [256]uint8
	Conn            bpfConnectionInfoT
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
}

type bpfKafkaGoReqT struct {
	Type uint8
	Op   uint8
	Pad0 [2]uint8
	Pid  struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Conn bpfConnectionInfoT
	Pad1 [4]uint8
	Tp   struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Topic           [64]uint8
}

type bpfRedisClientReqT struct {
	Type            uint8
	Err             uint8
	Pad             [6]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Buf  [256]uint8
	Conn bpfConnectionInfoT
	Tp   struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type bpfSqlRequestTrace struct {
	Type   uint8
	Pad    [1]uint8
	Status uint16
	Pid    struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Tp              struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Conn bpfConnectionInfoT
	Sql  [500]uint8
}

type bpfTcpReqT struct {
	Flags           uint8
	Ssl             uint8
	Direction       uint8
	Pad             [1]uint8
	ConnInfo        bpfConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	Len             uint32
	ReqLen          uint32
	RespLen         uint32
	Buf             [256]uint8
	Rbuf            [128]uint8
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Tp struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

// loadBpf returns the embedded CollectionSpec for bpf.
func loadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf: %w", err)
	}

	return spec, err
}

// loadBpfObjects loads bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpfObjects
//	*bpfPrograms
//	*bpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfSpecs struct {
	bpfProgramSpecs
	bpfMapSpecs
	bpfVariableSpecs
}

// bpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfProgramSpecs struct {
}

// bpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfMapSpecs struct {
}

// bpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfVariableSpecs struct {
	Ip4ip6Prefix *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.VariableSpec `ebpf:"unused"`
	Unused3      *ebpf.VariableSpec `ebpf:"unused_3"`
	Unused4      *ebpf.VariableSpec `ebpf:"unused_4"`
	Unused5      *ebpf.VariableSpec `ebpf:"unused_5"`
	Unused6      *ebpf.VariableSpec `ebpf:"unused_6"`
	Unused7      *ebpf.VariableSpec `ebpf:"unused_7"`
	Unused8      *ebpf.VariableSpec `ebpf:"unused_8"`
	UnusedHttp2  *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// bpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfObjects struct {
	bpfPrograms
	bpfMaps
	bpfVariables
}

func (o *bpfObjects) Close() error {
	return _BpfClose(
		&o.bpfPrograms,
		&o.bpfMaps,
	)
}

// bpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfMaps struct {
}

func (m *bpfMaps) Close() error {
	return _BpfClose()
}

// bpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfVariables struct {
	Ip4ip6Prefix *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.Variable `ebpf:"unused"`
	Unused3      *ebpf.Variable `ebpf:"unused_3"`
	Unused4      *ebpf.Variable `ebpf:"unused_4"`
	Unused5      *ebpf.Variable `ebpf:"unused_5"`
	Unused6      *ebpf.Variable `ebpf:"unused_6"`
	Unused7      *ebpf.Variable `ebpf:"unused_7"`
	Unused8      *ebpf.Variable `ebpf:"unused_8"`
	UnusedHttp2  *ebpf.Variable `ebpf:"unused_http2"`
}

// bpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfPrograms struct {
}

func (p *bpfPrograms) Close() error {
	return _BpfClose()
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
