// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// ObservabilityPipelineRemoveFieldsProcessorType The processor type. The value should always be `remove_fields`.
type ObservabilityPipelineRemoveFieldsProcessorType string

// List of ObservabilityPipelineRemoveFieldsProcessorType.
const (
	OBSERVABILITYPIPELINEREMOVEFIELDSPROCESSORTYPE_REMOVE_FIELDS ObservabilityPipelineRemoveFieldsProcessorType = "remove_fields"
)

var allowedObservabilityPipelineRemoveFieldsProcessorTypeEnumValues = []ObservabilityPipelineRemoveFieldsProcessorType{
	OBSERVABILITYPIPELINEREMOVEFIELDSPROCESSORTYPE_REMOVE_FIELDS,
}

// GetAllowedValues reeturns the list of possible values.
func (v *ObservabilityPipelineRemoveFieldsProcessorType) GetAllowedValues() []ObservabilityPipelineRemoveFieldsProcessorType {
	return allowedObservabilityPipelineRemoveFieldsProcessorTypeEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *ObservabilityPipelineRemoveFieldsProcessorType) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = ObservabilityPipelineRemoveFieldsProcessorType(value)
	return nil
}

// NewObservabilityPipelineRemoveFieldsProcessorTypeFromValue returns a pointer to a valid ObservabilityPipelineRemoveFieldsProcessorType
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewObservabilityPipelineRemoveFieldsProcessorTypeFromValue(v string) (*ObservabilityPipelineRemoveFieldsProcessorType, error) {
	ev := ObservabilityPipelineRemoveFieldsProcessorType(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for ObservabilityPipelineRemoveFieldsProcessorType: valid values are %v", v, allowedObservabilityPipelineRemoveFieldsProcessorTypeEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v ObservabilityPipelineRemoveFieldsProcessorType) IsValid() bool {
	for _, existing := range allowedObservabilityPipelineRemoveFieldsProcessorTypeEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to ObservabilityPipelineRemoveFieldsProcessorType value.
func (v ObservabilityPipelineRemoveFieldsProcessorType) Ptr() *ObservabilityPipelineRemoveFieldsProcessorType {
	return &v
}
