//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// BaselinesClient contains the methods for the Baselines group.
// Don't use this type directly, use NewBaselinesClient() instead.
type BaselinesClient struct {
	internal *arm.Client
}

// NewBaselinesClient creates a new instance of BaselinesClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewBaselinesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*BaselinesClient, error) {
	cl, err := arm.NewClient(moduleName+".BaselinesClient", moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &BaselinesClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Lists the metric baseline values for a resource.
//
// Generated from API version 2019-03-01
//   - resourceURI - The identifier of the resource.
//   - options - BaselinesClientListOptions contains the optional parameters for the BaselinesClient.NewListPager method.
func (client *BaselinesClient) NewListPager(resourceURI string, options *BaselinesClientListOptions) *runtime.Pager[BaselinesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[BaselinesClientListResponse]{
		More: func(page BaselinesClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *BaselinesClientListResponse) (BaselinesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "BaselinesClient.NewListPager")
			req, err := client.listCreateRequest(ctx, resourceURI, options)
			if err != nil {
				return BaselinesClientListResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return BaselinesClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return BaselinesClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *BaselinesClient) listCreateRequest(ctx context.Context, resourceURI string, options *BaselinesClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.Insights/metricBaselines"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Metricnames != nil {
		reqQP.Set("metricnames", *options.Metricnames)
	}
	if options != nil && options.Metricnamespace != nil {
		reqQP.Set("metricnamespace", *options.Metricnamespace)
	}
	if options != nil && options.Timespan != nil {
		reqQP.Set("timespan", *options.Timespan)
	}
	if options != nil && options.Interval != nil {
		reqQP.Set("interval", *options.Interval)
	}
	if options != nil && options.Aggregation != nil {
		reqQP.Set("aggregation", *options.Aggregation)
	}
	if options != nil && options.Sensitivities != nil {
		reqQP.Set("sensitivities", *options.Sensitivities)
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.ResultType != nil {
		reqQP.Set("resultType", string(*options.ResultType))
	}
	reqQP.Set("api-version", "2019-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *BaselinesClient) listHandleResponse(resp *http.Response) (BaselinesClientListResponse, error) {
	result := BaselinesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricBaselinesResponse); err != nil {
		return BaselinesClientListResponse{}, err
	}
	return result, nil
}
